/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParentScopes {
    private List<String> m_ancestorScopes = new ArrayList<String>();
    private boolean m_hasScopedParent = false;

    public Iterator<String> iterator() {
        return this.m_ancestorScopes.iterator();
    }

    public void addParentToCurrentScope(String scope) {
        this.m_ancestorScopes.add(0, scope);
    }

    public void appendScope(String scope) {
        this.m_ancestorScopes.add(scope);
    }

    public String removeFirst() {
        if (this.m_ancestorScopes.isEmpty()) {
            return null;
        }
        return this.m_ancestorScopes.remove(0);
    }

    public String removeLast() {
        if (this.m_ancestorScopes.isEmpty()) {
            return null;
        }
        return this.m_ancestorScopes.remove(this.m_ancestorScopes.size() - 1);
    }

    public String getFirst() {
        if (this.m_ancestorScopes.isEmpty()) {
            return null;
        }
        return this.m_ancestorScopes.get(0);
    }

    public String getLast() {
        if (this.m_ancestorScopes.isEmpty()) {
            return null;
        }
        return this.m_ancestorScopes.get(this.m_ancestorScopes.size() - 1);
    }

    public String get(int index) {
        return this.m_ancestorScopes.get(index);
    }

    public int size() {
        return this.m_ancestorScopes.size();
    }

    public boolean hasScopedParent() {
        return this.m_hasScopedParent;
    }

    public void setHasScopedParent(boolean set) {
        this.m_hasScopedParent = set;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParentScopes)) {
            return false;
        }
        ParentScopes scopes2 = (ParentScopes)obj;
        return ParentScopes.isEqual(this, scopes2);
    }

    private static boolean isEqual(ParentScopes scopes1, ParentScopes scopes2) {
        if (scopes1.size() != scopes2.size()) {
            return false;
        }
        Iterator<String> iter1 = scopes1.iterator();
        Iterator<String> iter2 = scopes2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            String s2;
            String s1 = iter1.next();
            if (s1.equals(s2 = iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }
}

