/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.node.visitor;

import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeHandlingStrategy;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.common.node.visitor.TraversalUtil;
import org.eclipse.vjet.dsf.common.phase.PhaseId;
import org.eclipse.vjet.dsf.dom.DNode;

public class DepthFirstDNodeTraversal
implements IDNodeHandlingStrategy {
    private PhaseId m_phaseId = PhaseId.ANY_PHASE;

    @Override
    public PhaseId getApplicablePhaseId() {
        return this.m_phaseId;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setApplicablePhaseId(PhaseId phaseId) {
        this.m_phaseId = phaseId;
    }

    @Override
    public void handle(DNode node, IDNodeVisitor visitor) {
        DNodeVisitStatus status = visitor.preVisit(node);
        if (status != DNodeVisitStatus.ABORT_SUBTREE && status != DNodeVisitStatus.STOP_SUBTREE_TRAVERSAL) {
            this.traverse(node, visitor);
        }
        if (status != DNodeVisitStatus.ABORT_CURRENT_NODE || status != DNodeVisitStatus.ABORT_SUBTREE) {
            status = visitor.visit(node);
        }
        if (status != DNodeVisitStatus.ABORT_CURRENT_NODE || status != DNodeVisitStatus.ABORT_SUBTREE) {
            visitor.postVisit(node);
        }
    }

    protected void traverse(DNode node, IDNodeVisitor visitor) {
        TraversalUtil.traverseChildrenOnly(node, visitor);
        TraversalUtil.traverseFacetsOnly(node, visitor);
    }
}

