/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DEntity;
import org.eclipse.vjet.dsf.dom.DEntityReference;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.util.IChildIntercepter;
import org.eclipse.vjet.dsf.html.dom.util.INodeEmitter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomToRawSaxGenerator
implements INodeEmitter {
    private final IRawSaxHandler m_rawSaxHandler;
    private final boolean m_handlerIsChildInterceptor;
    private final IChildIntercepter m_saxHandlerCastToInterceptor;
    protected boolean debugChildIntercepter = false;

    public DomToRawSaxGenerator(IRawSaxHandler rawSaxHandler) {
        this.m_rawSaxHandler = rawSaxHandler;
        this.m_handlerIsChildInterceptor = rawSaxHandler instanceof IChildIntercepter;
        this.m_saxHandlerCastToInterceptor = this.m_handlerIsChildInterceptor ? (IChildIntercepter)((Object)this.m_rawSaxHandler) : null;
    }

    @Override
    public void genEvents(Node node, IXmlStreamWriter writer) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                DElement elem = (DElement)node;
                this.genEventsForElement(elem, writer);
                break;
            }
            case 3: {
                if (node instanceof DRawString) {
                    this.m_rawSaxHandler.handleRawString((DRawString)node);
                    break;
                }
                this.m_rawSaxHandler.handleText((DText)node);
                break;
            }
            case 4: {
                this.m_rawSaxHandler.handleCData((DCDATASection)node);
                break;
            }
            case 8: {
                this.m_rawSaxHandler.handleComment((DComment)node);
                break;
            }
            case 9: {
                this.genEventsForDocument((DDocument)node, writer);
                break;
            }
            case 10: {
                this.m_rawSaxHandler.handleDocType((DDocumentType)node);
                break;
            }
            case 6: {
                this.m_rawSaxHandler.handleEntity((DEntity)node);
                break;
            }
            case 5: {
                this.m_rawSaxHandler.handleEntityReference((DEntityReference)node);
                break;
            }
            case 11: {
                this.genChildEvents(node, writer);
                break;
            }
            case 7: {
                this.m_rawSaxHandler.handleProcessingInstruction((DProcessingInstruction)node);
                break;
            }
            default: {
                throw new DsfRuntimeException("unknown node type of " + nodeType);
            }
        }
    }

    public void genEventsForElement(DElement element, IXmlStreamWriter writer) {
        if (this.m_handlerIsChildInterceptor) {
            boolean handled;
            boolean bl = handled = this.debugChildIntercepter ? this.m_saxHandlerCastToInterceptor.genDebugEvents(element, this, writer) : this.m_saxHandlerCastToInterceptor.genEvents(element, this, writer);
            if (handled) {
                return;
            }
        }
        this.genEventsForElementInternal(element, writer);
    }

    protected void genEventsForElementInternal(DElement element, IXmlStreamWriter writer) {
        this.m_rawSaxHandler.startElement(element);
        this.genChildEvents(element, writer);
        this.m_rawSaxHandler.endElement(element);
    }

    public void genEventsForDocument(DDocument document, IXmlStreamWriter writer) {
        this.m_rawSaxHandler.startDocument(document);
        this.genChildEvents(document, writer);
        this.m_rawSaxHandler.endDocument(document);
    }

    protected void genChildEvents(Node node, IXmlStreamWriter writer) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        Node lastChild = null;
        boolean expended = false;
        int i = 0;
        while (i < size) {
            lastChild = children.item(i);
            this.genEvents(lastChild, writer);
            if (size < children.getLength()) {
                expended = true;
                break;
            }
            ++i;
        }
        if (expended) {
            Node next = lastChild.getNextSibling();
            while (next != null) {
                this.genEvents(next, writer);
                next = next.getNextSibling();
            }
        }
    }
}

