import type { TextDocument } from 'vscode-languageserver-textdocument';
import { Service, ServiceContext, Rule, RuleContext, RuleType } from '../types';
import { FileRangeCapabilities, VirtualFile } from '@volar/language-core';
import { SourceMapWithDocuments } from '../documents';
export declare function documentFeatureWorker<T>(context: ServiceContext, uri: string, isValidSourceMap: (file: VirtualFile, sourceMap: SourceMapWithDocuments<FileRangeCapabilities>) => boolean, worker: (service: ReturnType<Service>, document: TextDocument) => T, transform: (result: NonNullable<Awaited<T>>, sourceMap: SourceMapWithDocuments<FileRangeCapabilities> | undefined) => Awaited<T> | undefined, combineResult?: (results: NonNullable<Awaited<T>>[]) => NonNullable<Awaited<T>>): Promise<NonNullable<Awaited<T>> | undefined>;
export declare function languageFeatureWorker<T, K>(context: ServiceContext, uri: string, arg: K, transformArg: (arg: K, sourceMap: SourceMapWithDocuments<FileRangeCapabilities>, file: VirtualFile) => Generator<K> | K[], worker: (service: ReturnType<Service>, document: TextDocument, arg: K, sourceMap: SourceMapWithDocuments<FileRangeCapabilities> | undefined, file: VirtualFile | undefined) => T, transform: (result: NonNullable<Awaited<T>>, sourceMap: SourceMapWithDocuments<FileRangeCapabilities> | undefined) => Awaited<T> | undefined, combineResult?: (results: NonNullable<Awaited<T>>[]) => NonNullable<Awaited<T>>, reportProgress?: (result: NonNullable<Awaited<T>>) => void): Promise<NonNullable<Awaited<T>> | undefined>;
export declare function ruleWorker<T>(context: ServiceContext, ruleType: RuleType, uri: string, isValidSourceMap: (file: VirtualFile) => boolean, worker: (ruleId: string, rule: Rule, document: TextDocument, ruleCtx: RuleContext) => T, transform: (result: NonNullable<Awaited<T>>, sourceMap: SourceMapWithDocuments<FileRangeCapabilities> | undefined) => Awaited<T> | undefined, combineResult?: (results: NonNullable<Awaited<T>>[]) => NonNullable<Awaited<T>>, reportProgress?: (result: NonNullable<Awaited<T>>) => void): Promise<NonNullable<Awaited<T>> | undefined>;
export declare function safeCall<T>(cb: () => Promise<T> | T, errorMsg?: string): Promise<T | undefined>;
//# sourceMappingURL=featureWorkers.d.ts.map