/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.nebula.ctabletree;

import java.util.List;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.swt.support.RectangleSupport;

public final class CTableTreeItemInfo
extends ItemInfo {
    public CTableTreeItemInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    protected void refresh_fetch() throws Exception {
        Rectangle bounds = this.getComponentBounds();
        if (this.getParent() instanceof CTableTreeItemInfo) {
            CTableTreeItemInfo parent = (CTableTreeItemInfo)this.getParent();
            Rectangle parentBounds = parent.getComponentBounds();
            if (parent.getComponentExpanded()) {
                bounds.translate(-parentBounds.x, -parentBounds.y);
            } else {
                bounds.translate(0, parentBounds.height);
            }
        } else {
            bounds.translate(0, this.getHeaderHeight());
        }
        this.setModelBounds(bounds);
        super.refresh_fetch();
    }

    private Rectangle getComponentBounds() throws Exception {
        Object swtBounds = ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getUnifiedBounds()", (Object[])new Object[0]);
        Rectangle bounds = RectangleSupport.getRectangle((Object)swtBounds);
        if (this.getComponentVisible()) {
            List childItems = this.getChildren(CTableTreeItemInfo.class);
            for (CTableTreeItemInfo childrenItem : childItems) {
                if (!childrenItem.getComponentVisible()) continue;
                Rectangle childBounds = childrenItem.getComponentBounds();
                if (childBounds.height <= 0 || childBounds.width <= 0) continue;
                bounds.union(childBounds);
            }
        }
        return bounds;
    }

    private boolean getComponentVisible() throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getVisible()", (Object[])new Object[0]);
    }

    private boolean getComponentExpanded() throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)this.getObject(), (String)"getExpanded()", (Object[])new Object[0]);
    }

    private int getHeaderHeight() throws Exception {
        Object container = ReflectionUtils.getFieldObject((Object)this.getObject(), (String)"container");
        return (Boolean)ReflectionUtils.invokeMethod((Object)container, (String)"getHeaderVisible()", (Object[])new Object[0]) != false ? (Integer)ReflectionUtils.invokeMethod((Object)container, (String)"getHeaderHeight()", (Object[])new Object[0]) : 0;
    }
}

