/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wb.core.model.broadcast.BroadcastSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.BundleClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.CompositeClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentHandler;
import org.eclipse.wb.internal.core.utils.xml.DocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContextCommitListener;
import org.eclipse.wb.internal.core.xml.model.ILiveEditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlLoadingContext;
import org.osgi.framework.Bundle;

public abstract class EditorContext {
    private final BroadcastSupport m_broadcastSupport = new BroadcastSupport();
    private final ToolkitDescription m_toolkit;
    private final String m_toolkitId;
    private final IDocument m_document;
    protected final IFile m_file;
    protected final IProject m_project;
    protected final IJavaProject m_javaProject;
    protected ClassLoader m_classLoader;
    private ILoadingContext m_loadingContext;
    private DocumentEditContext m_documentEditContext;
    private DocumentElement m_rootElement;
    private boolean m_parsing;
    private final Map<String, Object> m_versions = Maps.newHashMap();
    private final List<IDescriptionVersionsProvider> m_descriptionVersionsProviders = Lists.newArrayList();
    private final List<EditorWarning> m_warnings = Lists.newArrayList();
    private boolean m_isLiveComponent;

    public EditorContext(ToolkitDescription toolkit, IFile file, IDocument document) throws Exception {
        this.m_toolkit = toolkit;
        this.m_toolkitId = toolkit.getId();
        this.m_document = document;
        this.m_file = file;
        this.m_project = file.getProject();
        this.m_javaProject = JavaCore.create((IProject)this.m_project);
        if (!this.m_javaProject.exists()) {
            throw new DesignerException(5004, new String[]{this.m_file.getFullPath().toPortableString(), this.m_project.getFullPath().toPortableString()});
        }
    }

    public void initialize() throws Exception {
        this.createClassLoader();
        this.m_loadingContext = new XmlLoadingContext(this);
        this.m_documentEditContext = new DocumentEditContext(this.m_document){

            protected AbstractDocumentHandler createDocumentHandler() {
                return new AbstractDocumentHandler();
            }
        };
        this.m_rootElement = this.m_documentEditContext.getRoot();
        String charset = this.m_file.getCharset();
        this.m_rootElement.getModel().setCharset(charset);
    }

    public void commit() throws Exception {
        ((EditorContextCommitListener)this.m_broadcastSupport.getListener(EditorContextCommitListener.class)).aboutToCommit();
        this.m_documentEditContext.commit();
        ((EditorContextCommitListener)this.m_broadcastSupport.getListener(EditorContextCommitListener.class)).doneCommit();
    }

    public void dispose() throws Exception {
        this.m_documentEditContext.disconnect();
    }

    protected void createClassLoader() throws Exception {
        CompositeClassLoader parentClassLoader = new CompositeClassLoader();
        this.addParentClassLoaders(parentClassLoader);
        ClassLoader projectClassLoader = this.createProjectClassLoader(parentClassLoader);
        CompositeClassLoader compositeClassLoader = new CompositeClassLoader();
        compositeClassLoader.add(projectClassLoader, null);
        this.addLibraryClassLoaders(compositeClassLoader, projectClassLoader);
        this.m_classLoader = compositeClassLoader;
    }

    protected ClassLoader createProjectClassLoader(CompositeClassLoader parentClassLoader) throws Exception {
        return ProjectClassLoader.create((ClassLoader)parentClassLoader, (IJavaProject)this.m_javaProject);
    }

    protected void addParentClassLoaders(CompositeClassLoader parentClassLoader) throws Exception {
        List toolkitElements = DescriptionHelper.getToolkitElements((String)this.m_toolkitId);
        for (IConfigurationElement toolkitElement : toolkitElements) {
            IConfigurationElement[] contributorElements;
            IConfigurationElement[] iConfigurationElementArray = contributorElements = toolkitElement.getChildren("classLoader-bundle");
            int n = contributorElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement contributorElement = iConfigurationElementArray[n2];
                Bundle bundle = EditorContext.getExistingBundle(contributorElement);
                List<String> namespaces = EditorContext.getBundleClassLoaderNamespaces(contributorElement);
                ClassLoader classLoader = BundleClassLoader.create((Bundle)bundle);
                parentClassLoader.add(classLoader, namespaces);
                ++n2;
            }
        }
    }

    private static List<String> getBundleClassLoaderNamespaces(IConfigurationElement contributorElement) {
        String namespacesString = contributorElement.getAttribute("namespaces");
        if (namespacesString != null) {
            return ImmutableList.copyOf((Object[])StringUtils.split((String)namespacesString));
        }
        return null;
    }

    private void addLibraryClassLoaders(CompositeClassLoader compositeClassLoader, ClassLoader mainClassLoader) throws Exception {
        List toolkitElements = DescriptionHelper.getToolkitElements((String)this.m_toolkitId);
        for (IConfigurationElement toolkitElement : toolkitElements) {
            IConfigurationElement[] contributorElements = toolkitElement.getChildren("classLoader-library");
            if (contributorElements.length == 0) continue;
            URL[] urls = new URL[contributorElements.length];
            int i = 0;
            while (i < contributorElements.length) {
                IConfigurationElement contributorElement = contributorElements[i];
                Bundle bundle = EditorContext.getExistingBundle(contributorElement);
                String jarPath = contributorElement.getAttribute("jar");
                URL jarEntry = bundle.getEntry(jarPath);
                Assert.isNotNull((Object)jarEntry, (String)"Unable to find %s in %s", (Object[])new Object[]{jarPath, bundle.getSymbolicName()});
                urls[i] = FileLocator.toFileURL((URL)jarEntry);
                ++i;
            }
            compositeClassLoader.add((ClassLoader)new URLClassLoader(urls, mainClassLoader), null);
        }
    }

    private static Bundle getExistingBundle(IConfigurationElement contributorElement) {
        String bundleId = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)contributorElement, (String)"bundle");
        return ExternalFactoriesHelper.getRequiredBundle((String)bundleId);
    }

    public ToolkitDescription getToolkit() {
        return this.m_toolkit;
    }

    public BroadcastSupport getBroadcastSupport() {
        return this.m_broadcastSupport;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public ILoadingContext getLoadingContext() {
        return this.m_loadingContext;
    }

    public IFile getFile() {
        return this.m_file;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public IDocument getDocument() {
        return this.m_document;
    }

    public String getContent() {
        return this.m_documentEditContext.getText();
    }

    public DocumentElement getRootElement() {
        return this.m_rootElement;
    }

    public boolean isParsing() {
        return this.m_parsing;
    }

    public void setParsing(boolean parsing) {
        this.m_parsing = parsing;
        GlobalState.setParsing((boolean)parsing);
    }

    public Map<String, Object> getVersions() {
        return this.m_versions;
    }

    public List<IDescriptionVersionsProvider> getDescriptionVersionsProviders() {
        return this.m_descriptionVersionsProviders;
    }

    public void addVersions(Map<String, ?> versions) {
        this.m_versions.putAll(versions);
    }

    public void addDescriptionVersionsProvider(IDescriptionVersionsProvider provider) {
        Assert.isNotNull((Object)provider);
        if (!this.m_descriptionVersionsProviders.contains(provider)) {
            this.m_descriptionVersionsProviders.add(provider);
        }
    }

    public List<EditorWarning> getWarnings() {
        return this.m_warnings;
    }

    public void addWarning(EditorWarning warning) {
        this.m_warnings.add(warning);
    }

    public boolean isLiveComponent() {
        return this.m_isLiveComponent;
    }

    public void setLiveComponent(boolean isLiveComponent) {
        this.m_isLiveComponent = isLiveComponent;
    }

    public abstract ILiveEditorContext getLiveContext();
}

