/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NetSchem
extends NetCell {
    NetSchem implementation;
    int[] portImplementation;
    private int[] equivPortsF;
    private int[] equivPortsT;
    int[] nodeOffsets;
    int[] drawnOffsets;
    Proxy[] nodeProxies;
    Map proxyExcludeGlobals;
    Map name2proxy = new HashMap();
    Global.Set globals = Global.Set.empty;
    int[] portOffsets = new int[1];
    int netNamesOffset;
    Name[] drawnNames;
    int[] drawnWidths;
    private Netlist netlistF;
    private Netlist netlistT;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void updateCellGroup(Cell.CellGroup cellGroup) {
        Cell mainSchematics = cellGroup.getMainSchematics();
        NetSchem mainSchem = null;
        if (mainSchematics != null) {
            mainSchem = (NetSchem)NetworkTool.getNetCell(mainSchematics);
        }
        Iterator it = cellGroup.getCells();
        while (it.hasNext()) {
            NetSchem icon;
            Cell cell = (Cell)it.next();
            if (!cell.isIcon() || (icon = (NetSchem)NetworkTool.getNetCell(cell)) == null) continue;
            icon.setImplementation(mainSchem != null ? mainSchem : icon);
        }
    }

    NetSchem(Cell cell) {
        super(cell);
        this.setImplementation(this);
        NetSchem.updateCellGroup(cell.getCellGroup());
    }

    private void setImplementation(NetSchem implementation) {
        if (this.implementation == implementation) {
            return;
        }
        this.implementation = implementation;
        this.updatePortImplementation();
    }

    private boolean updatePortImplementation() {
        Export e;
        int i;
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.portImplementation == null || this.portImplementation.length != numPorts) {
            changed = true;
            this.portImplementation = new int[numPorts];
        }
        Cell c = this.implementation.cell;
        for (i = 0; i < numPorts; ++i) {
            Export equiv;
            e = (Export)this.cell.getPort(i);
            int equivIndex = -1;
            if (c != null && (equiv = e.getEquivalentPort(c)) != null) {
                equivIndex = equiv.getPortIndex();
            }
            if (this.portImplementation[i] != equivIndex) {
                changed = true;
                this.portImplementation[i] = equivIndex;
            }
            if (equivIndex >= 0) continue;
            String msg = this.cell + ": Icon port <" + e.getNameKey() + "> has no equivalent port";
            System.out.println(msg);
            ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 2);
            log.addExport(e, true, this.cell, null);
        }
        if (!this.cell.isMultiPartIcon() && c != null && numPorts != c.getNumPorts()) {
            for (i = 0; i < c.getNumPorts(); ++i) {
                e = (Export)c.getPort(i);
                if (e.getEquivalentPort(this.cell) != null) continue;
                String msg = c + ": Schematic port <" + e.getNameKey() + "> has no equivalent port in " + this.cell;
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, c, 2);
                log.addExport(e, true, c, null);
            }
        }
        return changed;
    }

    int getPortOffset(int portIndex, int busIndex) {
        if ((portIndex = this.portImplementation[portIndex]) < 0) {
            return -1;
        }
        int portOffset = this.implementation.portOffsets[portIndex] + busIndex;
        if (busIndex < 0 || portOffset >= this.implementation.portOffsets[portIndex + 1]) {
            return -1;
        }
        return portOffset;
    }

    NetSchem getSchem() {
        return this.implementation;
    }

    static int getPortOffset(PortProto pp, int busIndex) {
        int portIndex = pp.getPortIndex();
        NodeProto np = pp.getParent();
        if (!(np instanceof Cell)) {
            return busIndex == 0 ? portIndex : -1;
        }
        NetCell netCell = NetworkTool.getNetCell((Cell)np);
        return netCell.getPortOffset(portIndex, busIndex);
    }

    Netlist getNetlist(boolean shortResistors) {
        if ((this.flags & 1) == 0) {
            this.redoNetworks();
        }
        return shortResistors ? this.netlistT : this.netlistF;
    }

    Iterator getNodables() {
        Proxy proxy;
        ArrayList<Nodable> nodables = new ArrayList<Nodable>();
        Iterator it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (this.nodeOffsets[ni.getNodeIndex()] < 0) continue;
            nodables.add(ni);
        }
        for (int i = 0; i < this.nodeProxies.length; ++i) {
            proxy = this.nodeProxies[i];
            if (proxy == null || proxy.isShared()) continue;
            nodables.add(proxy);
        }
        Iterator it2 = this.name2proxy.values().iterator();
        while (it2.hasNext()) {
            proxy = (Proxy)it2.next();
            if (!proxy.isShared()) continue;
            nodables.add(proxy);
        }
        return nodables.iterator();
    }

    Global.Set getGlobals() {
        return this.globals;
    }

    int getNetMapOffset(Global global) {
        return this.globals.indexOf(global);
    }

    int getNetMapOffset(Nodable no, Global global) {
        if (!(no instanceof Proxy)) {
            return -1;
        }
        Proxy proxy = (Proxy)no;
        NetSchem schem = NetworkTool.getNetCell((Cell)proxy.nodeInst.getProto()).getSchem();
        int i = schem.globals.indexOf(global);
        if (i < 0) {
            return -1;
        }
        return proxy.nodeOffset + i;
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            int nodeIndex = ni.getNodeIndex();
            int proxyOffset = this.nodeOffsets[nodeIndex];
            int drawn = this.drawns[this.ni_pi[nodeIndex] + portProto.getPortIndex()];
            if (drawn < 0) {
                return -1;
            }
            if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
                return -1;
            }
            return this.drawnOffsets[drawn] + busIndex;
        }
        Proxy proxy = (Proxy)no;
        if (proxy == null) {
            return -1;
        }
        int portOffset = NetSchem.getPortOffset(portProto, busIndex);
        if (portOffset < 0) {
            return -1;
        }
        return proxy.nodeOffset + portOffset;
    }

    int getBusWidth(Nodable no, PortProto portProto) {
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            int nodeIndex = ni.getNodeIndex();
            int proxyOffset = this.nodeOffsets[nodeIndex];
            int drawn = this.drawns[this.ni_pi[nodeIndex] + portProto.getPortIndex()];
            if (drawn < 0) {
                return 0;
            }
            return this.drawnWidths[drawn];
        }
        return portProto.getNameKey().busWidth();
    }

    int getNetMapOffset(Export export, int busIndex) {
        int drawn = this.drawns[export.getPortIndex()];
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        int drawn = this.drawns[this.arcsOffset + ai.getArcIndex()];
        if (drawn < 0) {
            return -1;
        }
        if (busIndex < 0 || busIndex >= this.drawnWidths[drawn]) {
            return -1;
        }
        return this.drawnOffsets[drawn] + busIndex;
    }

    Name getBusName(ArcInst ai) {
        int drawn = this.drawns[this.arcsOffset + ai.getArcIndex()];
        return this.drawnNames[drawn];
    }

    public int getBusWidth(ArcInst ai) {
        int drawn;
        if ((this.flags & 1) == 0) {
            this.redoNetworks();
        }
        if ((drawn = this.drawns[this.arcsOffset + ai.getArcIndex()]) < 0) {
            return 0;
        }
        return this.drawnWidths[drawn];
    }

    void invalidateUsagesOf(boolean strong) {
        super.invalidateUsagesOf(strong);
        if (this.cell.isIcon()) {
            return;
        }
        Iterator it = this.cell.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (!c.isIcon()) continue;
            NetSchem icon = (NetSchem)NetworkTool.getNetCell(c);
            icon.setInvalid(strong, strong);
        }
    }

    private boolean initNodables() {
        int i;
        if (this.nodeOffsets == null || this.nodeOffsets.length != this.cell.getNumNodes()) {
            this.nodeOffsets = new int[this.cell.getNumNodes()];
        }
        int numNodes = this.cell.getNumNodes();
        Global.Buf globalBuf = new Global.Buf();
        int nodeProxiesOffset = 0;
        HashMap nodeInstExcludeGlobal = null;
        for (int i2 = 0; i2 < numNodes; ++i2) {
            PortCharacteristic characteristic;
            ErrorLogger.MessageLog log;
            String msg;
            NodeInst ni = this.cell.getNode(i2);
            NodeProto np = ni.getProto();
            NetCell netCell = null;
            if (np instanceof Cell) {
                netCell = NetworkTool.getNetCell((Cell)np);
            }
            if (netCell != null && netCell instanceof NetSchem) {
                if (ni.getNameKey().hasDuplicates()) {
                    msg = this.cell + ": Node name <" + ni.getNameKey() + "> has duplicate subnames";
                    System.out.println(msg);
                    log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                    log.addGeom(ni, true, this.cell, null);
                }
                this.nodeOffsets[i2] = ~nodeProxiesOffset;
                nodeProxiesOffset += ni.getNameKey().busWidth();
            } else {
                if (ni.getNameKey().isBus()) {
                    msg = this.cell + ": Array name <" + ni.getNameKey() + "> can be assigned only to icon nodes";
                    System.out.println(msg);
                    log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                    log.addGeom(ni, true, this.cell, null);
                }
                this.nodeOffsets[i2] = 0;
            }
            if (netCell != null) {
                String errorMsg;
                NetSchem sch = netCell.getSchem();
                if (sch == null || sch == this) continue;
                Global.Set gs = sch.globals;
                int numPortInsts = np.getNumPorts();
                HashSet<Global> gb = null;
                for (int j = 0; j < numPortInsts; ++j) {
                    Export e;
                    int portIndex;
                    PortInst pi = ni.getPortInst(j);
                    int piOffset = this.getPortInstOffset(pi);
                    int drawn = this.drawns[piOffset];
                    if (drawn < 0 || drawn >= this.numConnectedDrawns || (portIndex = ((NetSchem)netCell).portImplementation[j]) < 0 || !(e = (Export)sch.cell.getPort(portIndex)).isGlobalPartition()) continue;
                    if (gb == null) {
                        gb = new HashSet<Global>();
                    }
                    int busWidth = e.getNameKey().busWidth();
                    for (int k = 0; k < busWidth; ++k) {
                        int q = sch.equivPortsF[sch.portOffsets[portIndex] + k];
                        for (int l = 0; l < sch.globals.size(); ++l) {
                            if (sch.equivPortsF[l] != q) continue;
                            Global g = sch.globals.get(l);
                            gb.add(g);
                        }
                    }
                }
                if (gb != null) {
                    if (nodeInstExcludeGlobal == null) {
                        nodeInstExcludeGlobal = new HashMap();
                    }
                    nodeInstExcludeGlobal.put(ni, gb);
                    gs = gs.remove(gb.iterator());
                }
                if ((errorMsg = globalBuf.addToBuf(gs)) == null) continue;
                String msg2 = "Network: " + this.cell + " has globals with conflicting characteristic " + errorMsg;
                System.out.println(msg2);
                ErrorLogger.MessageLog log2 = NetworkTool.errorLogger.logError(msg2, this.cell, 0);
                continue;
            }
            Global g = NetSchem.globalInst(ni);
            if (g == null) continue;
            if (g == Global.ground) {
                characteristic = PortCharacteristic.GND;
            } else if (g == Global.power) {
                characteristic = PortCharacteristic.PWR;
            } else {
                characteristic = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
                if (characteristic == null) {
                    String msg3 = "Network: " + this.cell + " has global " + g.getName() + " with unknown characteristic bits";
                    System.out.println(msg3);
                    ErrorLogger.MessageLog log3 = NetworkTool.errorLogger.logError(msg3, this.cell, 0);
                    log3.addGeom(ni, true, this.cell, null);
                    characteristic = PortCharacteristic.UNKNOWN;
                }
            }
            String errorMsg = globalBuf.addToBuf(g, characteristic);
            if (errorMsg == null) continue;
            String msg4 = "Network: " + this.cell + " has global with conflicting characteristic " + errorMsg;
            System.out.println(msg4);
            ErrorLogger.MessageLog log4 = NetworkTool.errorLogger.logError(msg4, this.cell, 0);
        }
        Global.Set newGlobals = globalBuf.getBuf();
        boolean changed = false;
        if (this.globals != newGlobals) {
            changed = true;
            this.globals = newGlobals;
            if (NetworkTool.debug) {
                System.out.println(this.cell + " has " + this.globals);
            }
        }
        int mapOffset = this.portOffsets[0] = this.globals.size();
        int numPorts = this.cell.getNumPorts();
        for (i = 1; i <= numPorts; ++i) {
            Export export = (Export)this.cell.getPort(i - 1);
            if (NetworkTool.debug) {
                System.out.println(export + " " + this.portOffsets[i - 1]);
            }
            if (this.portOffsets[i] == (mapOffset += export.getNameKey().busWidth())) continue;
            changed = true;
            this.portOffsets[i] = mapOffset;
        }
        if (this.equivPortsF == null || this.equivPortsF.length != mapOffset) {
            this.equivPortsF = new int[mapOffset];
            this.equivPortsT = new int[mapOffset];
        }
        for (i = 0; i < this.numDrawns; ++i) {
            this.drawnOffsets[i] = mapOffset;
            mapOffset += this.drawnWidths[i];
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i + " has offset " + this.drawnOffsets[i]);
        }
        if (this.nodeProxies == null || this.nodeProxies.length != nodeProxiesOffset) {
            this.nodeProxies = new Proxy[nodeProxiesOffset];
        }
        this.name2proxy.clear();
        this.proxyExcludeGlobals = null;
        for (int n = 0; n < numNodes; ++n) {
            NodeInst ni = this.cell.getNode(n);
            int proxyOffset = this.nodeOffsets[n];
            if (NetworkTool.debug) {
                System.out.println(ni + " " + proxyOffset);
            }
            if (proxyOffset >= 0) continue;
            Cell iconCell = (Cell)ni.getProto();
            NetSchem netSchem = NetworkTool.getNetCell(iconCell).getSchem();
            if (ni.isIconOfParent()) {
                netSchem = null;
            }
            HashSet gs = null;
            if (netSchem != null && nodeInstExcludeGlobal != null) {
                gs = (HashSet)nodeInstExcludeGlobal.get(ni);
            }
            for (int i3 = 0; i3 < ni.getNameKey().busWidth(); ++i3) {
                Proxy proxy = null;
                if (netSchem != null) {
                    Proxy namedProxy;
                    Name name = ni.getNameKey().subname(i3);
                    if (!name.isTempname() && (namedProxy = (Proxy)this.name2proxy.get(name)) != null) {
                        ErrorLogger.MessageLog log;
                        String msg;
                        Cell namedIconCell = (Cell)namedProxy.nodeInst.getProto();
                        if (namedProxy.hasMulti(iconCell)) {
                            msg = "Network: " + this.cell + " has instances of " + iconCell + " with same name <" + name + ">";
                            System.out.println(msg);
                            log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                            log.addGeom(ni, true, this.cell, null);
                        } else if (!iconCell.isMultiPartIcon() || !namedIconCell.isMultiPartIcon() || NetworkTool.getNetCell(namedIconCell).getSchem() != netSchem) {
                            msg = "Network: " + this.cell + " has instances of " + iconCell + " and " + namedIconCell + " with same name <" + name + ">";
                            System.out.println(msg);
                            log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                            log.addGeom(ni, true, this.cell, null);
                            log.addGeom(namedProxy.nodeInst, true, this.cell, null);
                        } else {
                            proxy = namedProxy;
                            proxy.addMulti(ni, i3);
                            System.out.println("Info: " + this.cell + " has instances of multipart icon " + name);
                        }
                    }
                    if (proxy == null) {
                        proxy = new Proxy(ni, i3);
                        if (!name.isTempname()) {
                            this.name2proxy.put(name, proxy);
                        }
                        if (NetworkTool.debug) {
                            System.out.println(proxy + " " + mapOffset + " " + netSchem.equivPortsF.length);
                        }
                        proxy.nodeOffset = mapOffset;
                        mapOffset += netSchem.equivPortsF.length;
                    }
                    if (gs != null) {
                        Set gs0;
                        if (this.proxyExcludeGlobals == null) {
                            this.proxyExcludeGlobals = new HashMap();
                        }
                        if ((gs0 = (Set)this.proxyExcludeGlobals.get(proxy)) != null) {
                            gs = new HashSet(gs);
                            gs.addAll(gs0);
                        }
                        this.proxyExcludeGlobals.put(proxy, gs);
                    }
                }
                this.nodeProxies[(proxyOffset ^ 0xFFFFFFFF) + i3] = proxy;
            }
        }
        this.netNamesOffset = mapOffset;
        if (NetworkTool.debug) {
            System.out.println("netNamesOffset=" + this.netNamesOffset);
        }
        return changed;
    }

    private static Global globalInst(NodeInst ni) {
        Variable var;
        NodeProto np = ni.getProto();
        if (np == Schematics.tech.groundNode) {
            return Global.ground;
        }
        if (np == Schematics.tech.powerNode) {
            return Global.power;
        }
        if (np == Schematics.tech.globalNode && (var = ni.getVar(Schematics.SCHEM_GLOBAL_NAME, String.class)) != null) {
            return Global.newGlobal((String)var.getObject());
        }
        return null;
    }

    void calcDrawnWidths() {
        int i;
        int oldWidth;
        int drawn;
        int i2;
        Arrays.fill(this.drawnNames, null);
        Arrays.fill(this.drawnWidths, -1);
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        for (i2 = 0; i2 < numPorts; ++i2) {
            drawn = this.drawns[i2];
            Name name = this.cell.getPort(i2).getNameKey();
            int newWidth = name.busWidth();
            int oldWidth2 = this.drawnWidths[drawn];
            if (oldWidth2 < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = name.busWidth();
                continue;
            }
            if (oldWidth2 == newWidth) continue;
            this.reportDrawnWidthError((Export)this.cell.getPort(i2), null, this.drawnNames[drawn].toString(), name.toString());
        }
        for (i2 = 0; i2 < numArcs; ++i2) {
            ArcInst ai;
            Name name;
            drawn = this.drawns[this.arcsOffset + i2];
            if (drawn < 0 || (name = (ai = this.cell.getArc(i2)).getNameKey()).isTempname()) continue;
            int newWidth = name.busWidth();
            oldWidth = this.drawnWidths[drawn];
            if (oldWidth < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth == newWidth) continue;
            this.reportDrawnWidthError(null, ai, this.drawnNames[drawn].toString(), name.toString());
        }
        ArcProto busArc = Schematics.tech.bus_arc;
        for (i = 0; i < numArcs; ++i) {
            ArcInst ai;
            Name name;
            int drawn2 = this.drawns[this.arcsOffset + i];
            if (drawn2 < 0 || !(name = (ai = this.cell.getArc(i)).getNameKey()).isTempname() || (oldWidth = this.drawnWidths[drawn2]) >= 0) continue;
            this.drawnNames[drawn2] = name;
            if (ai.getProto() == busArc) continue;
            this.drawnWidths[drawn2] = 1;
        }
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            NodeProto np = ni.getProto();
            if (np instanceof PrimitiveNode && (np.getFunction() == PrimitiveNode.Function.PIN || np == Schematics.tech.offpageNode)) continue;
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                NetCell netCell;
                PortInst pi = ni.getPortInst(j);
                int drawn3 = this.drawns[this.getPortInstOffset(pi)];
                if (drawn3 < 0) continue;
                int oldWidth3 = this.drawnWidths[drawn3];
                int newWidth = 1;
                if (np instanceof Cell && (netCell = NetworkTool.getNetCell((Cell)np)) instanceof NetSchem) {
                    int arraySize = ((Cell)np).isIcon() ? ni.getNameKey().busWidth() : 1;
                    int portWidth = pi.getPortProto().getNameKey().busWidth();
                    if (oldWidth3 == portWidth) continue;
                    newWidth = arraySize * portWidth;
                }
                if (oldWidth3 < 0) {
                    this.drawnWidths[drawn3] = newWidth;
                    continue;
                }
                if (oldWidth3 == newWidth) continue;
                String msg = "Network: Schematic " + this.cell + " has net <" + this.drawnNames[drawn3] + "> with width conflict in connection " + pi.describe(true);
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 0);
                log.addPoly(pi.getPoly(), true, this.cell);
            }
        }
        for (i = 0; i < this.drawnWidths.length; ++i) {
            if (this.drawnWidths[i] < 1) {
                this.drawnWidths[i] = 1;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("Drawn " + i + " " + (this.drawnNames[i] != null ? this.drawnNames[i].toString() : "") + " has width " + this.drawnWidths[i]);
        }
    }

    void reportDrawnWidthError(Export pp, ArcInst ai, String firstname, String badname) {
        String name;
        int i;
        int numPorts = this.cell.getNumPorts();
        int numArcs = this.cell.getNumArcs();
        String msg = "Network: Schematic " + this.cell + " has net with conflict width of names <" + firstname + "> and <" + badname + ">";
        System.out.println(msg);
        ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 0);
        boolean originalFound = false;
        for (i = 0; i < numPorts; ++i) {
            name = this.cell.getPort(i).getName();
            if (!name.equals(firstname)) continue;
            log.addExport((Export)this.cell.getPort(i), true, this.cell, null);
            originalFound = true;
            break;
        }
        if (!originalFound) {
            for (i = 0; i < numArcs; ++i) {
                name = this.cell.getArc(i).getName();
                if (!name.equals(firstname)) continue;
                log.addGeom(this.cell.getArc(i), true, this.cell, null);
                break;
            }
        }
        if (ai != null) {
            log.addGeom(ai, true, this.cell, null);
        }
        if (pp != null) {
            log.addExport(pp, true, this.cell, null);
        }
    }

    void addNetNames(Name name) {
        for (int i = 0; i < name.busWidth(); ++i) {
            this.addNetName(name.subname(i));
        }
    }

    private void localConnections() {
        int k;
        int numExports = this.cell.getNumPorts();
        for (int k2 = 0; k2 < numExports; ++k2) {
            Export e = (Export)this.cell.getPort(k2);
            int portOffset = this.portOffsets[k2];
            Name expNm = e.getNameKey();
            int busWidth = expNm.busWidth();
            int drawn = this.drawns[k2];
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                this.netlistF.connectMap(portOffset + i, drawnOffset + (busWidth == this.drawnWidths[drawn] ? i : i % this.drawnWidths[drawn]));
                NetCell.NetName nn = (NetCell.NetName)this.netNames.get(expNm.subname(i));
                this.netlistF.connectMap(portOffset + i, this.netNamesOffset + nn.index);
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int k3 = 0; k3 < numNodes; ++k3) {
            NetCell netCell;
            NodeInst ni = this.cell.getNode(k3);
            if (ni.isIconOfParent()) continue;
            NodeProto np = ni.getProto();
            if (np instanceof PrimitiveNode) {
                Global g = NetSchem.globalInst(ni);
                if (g != null) {
                    int drawn = this.drawns[this.ni_pi[k3]];
                    this.netlistF.connectMap(this.globals.indexOf(g), this.drawnOffsets[drawn]);
                }
                if (np != Schematics.tech.wireConNode) continue;
                this.connectWireCon(ni);
                continue;
            }
            if (this.nodeOffsets[k3] >= 0 || !((netCell = NetworkTool.getNetCell((Cell)np)) instanceof NetSchem)) continue;
            NetSchem icon = (NetSchem)netCell;
            NetSchem schem = netCell.getSchem();
            if (schem == null) continue;
            Name nodeName = ni.getNameKey();
            int arraySize = nodeName.busWidth();
            int proxyOffset = this.nodeOffsets[k3];
            int numPorts = np.getNumPorts();
            for (int m = 0; m < numPorts; ++m) {
                int width;
                Export e = (Export)np.getPort(m);
                int portIndex = m;
                if ((portIndex = icon.portImplementation[portIndex]) < 0) continue;
                int portOffset = schem.portOffsets[portIndex];
                int busWidth = e.getNameKey().busWidth();
                int drawn = this.drawns[this.ni_pi[k3] + m];
                if (drawn < 0 || (width = this.drawnWidths[drawn]) != busWidth && width != busWidth * arraySize) continue;
                for (int i = 0; i < arraySize; ++i) {
                    Proxy proxy = this.nodeProxies[~proxyOffset + i];
                    if (proxy == null) continue;
                    int nodeOffset = proxy.nodeOffset + portOffset;
                    int busOffset = this.drawnOffsets[drawn];
                    if (width != busWidth) {
                        busOffset += busWidth * i;
                    }
                    for (int j = 0; j < busWidth; ++j) {
                        this.netlistF.connectMap(busOffset + j, nodeOffset + j);
                    }
                }
            }
        }
        int numArcs = this.cell.getNumArcs();
        for (k = 0; k < numArcs; ++k) {
            ArcInst ai = this.cell.getArc(k);
            int drawn = this.drawns[this.arcsOffset + k];
            if (drawn < 0 || !ai.isUsernamed()) continue;
            int busWidth = this.drawnWidths[drawn];
            Name arcNm = ai.getNameKey();
            if (arcNm.busWidth() != busWidth) continue;
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                NetCell.NetName nn = (NetCell.NetName)this.netNames.get(arcNm.subname(i));
                this.netlistF.connectMap(drawnOffset + i, this.netNamesOffset + nn.index);
            }
        }
        for (k = 0; k < this.nodeProxies.length; ++k) {
            Proxy proxy = this.nodeProxies[k];
            if (proxy == null) continue;
            NodeProto np = proxy.getProto();
            NetSchem schem = (NetSchem)NetworkTool.getNetCell((Cell)np);
            int numGlobals = schem.portOffsets[0];
            if (numGlobals == 0) continue;
            Set excludeGlobals = null;
            if (this.proxyExcludeGlobals != null) {
                excludeGlobals = (Set)this.proxyExcludeGlobals.get(proxy);
            }
            for (int i = 0; i < numGlobals; ++i) {
                Global g = schem.globals.get(i);
                if (excludeGlobals != null && excludeGlobals.contains(g)) continue;
                this.netlistF.connectMap(this.globals.indexOf(g), proxy.nodeOffset + i);
            }
        }
    }

    private void connectWireCon(NodeInst ni) {
        ArcInst ai1 = null;
        ArcInst ai2 = null;
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (ai1 == null) {
                ai1 = ai;
                continue;
            }
            if (ai2 == null) {
                ai2 = ai;
                continue;
            }
            String msg = "Network: Schematic " + this.cell + " has connector " + ni + " which merges more than two arcs";
            System.out.println(msg);
            ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 0);
            log.addGeom(ni, true, this.cell, null);
            return;
        }
        if (ai2 == null || ai1 == ai2) {
            return;
        }
        int large = this.drawns[this.arcsOffset + ai1.getArcIndex()];
        int small = this.drawns[this.arcsOffset + ai2.getArcIndex()];
        if (large < 0 || small < 0) {
            return;
        }
        if (this.drawnWidths[small] > this.drawnWidths[large]) {
            int temp = small;
            small = large;
            large = temp;
        }
        for (int i = 0; i < this.drawnWidths[large]; ++i) {
            this.netlistF.connectMap(this.drawnOffsets[large] + i, this.drawnOffsets[small] + i % this.drawnWidths[small]);
        }
    }

    private void internalConnections() {
        int k;
        int numNodes = this.cell.getNumNodes();
        for (k = 0; k < numNodes; ++k) {
            NodeInst ni = this.cell.getNode(k);
            int nodeOffset = this.ni_pi[k];
            NodeProto np = ni.getProto();
            if (np instanceof PrimitiveNode) {
                if (np != Schematics.tech.resistorNode) continue;
                this.netlistT.connectMap(this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                continue;
            }
            NetCell netCell = NetworkTool.getNetCell((Cell)np);
            if (this.nodeOffsets[k] < 0) continue;
            int numPorts = netCell.getNumEquivPorts();
            for (int i = 0; i < numPorts; ++i) {
                int j = netCell.getEquivPorts(i);
                if (i == j) continue;
                int di = this.drawns[nodeOffset + i];
                int dj = this.drawns[nodeOffset + j];
                if (di < 0 || dj < 0) continue;
                this.netlistF.connectMap(this.drawnOffsets[di], this.drawnOffsets[dj]);
                this.netlistT.connectMap(this.drawnOffsets[di], this.drawnOffsets[dj]);
            }
        }
        for (k = 0; k < this.nodeProxies.length; ++k) {
            Proxy proxy = this.nodeProxies[k];
            if (proxy == null) continue;
            NodeProto np = proxy.getProto();
            NetSchem schem = (NetSchem)NetworkTool.getNetCell((Cell)np);
            int[] eqF = schem.equivPortsF;
            int[] eqT = schem.equivPortsT;
            if (!$assertionsDisabled && eqF.length != eqT.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < eqF.length; ++i) {
                int jT;
                int io = proxy.nodeOffset + i;
                int jF = eqF[i];
                if (i != jF) {
                    this.netlistF.connectMap(io, proxy.nodeOffset + jF);
                }
                if (i == (jT = eqT[i])) continue;
                this.netlistT.connectMap(io, proxy.nodeOffset + jT);
            }
        }
    }

    private void buildNetworkLists() {
        int i;
        NetCell.NetName nn;
        this.netlistF.initNetworks(this.equivPortsF.length);
        this.netlistT.initNetworks(this.equivPortsT.length);
        for (int i2 = 0; i2 < this.globals.size(); ++i2) {
            this.netlistF.getNetworkByMap(i2).addUserName(this.globals.get(i2).getNameKey(), true);
            this.netlistT.getNetworkByMap(i2).addUserName(this.globals.get(i2).getNameKey(), true);
        }
        Iterator it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetCell.NetName)it.next();
            if (nn.index < 0 || nn.index >= this.exportedNetNameCount) continue;
            this.netlistF.getNetworkByMap(this.netNamesOffset + nn.index).addUserName(nn.name, true);
            this.netlistT.getNetworkByMap(this.netNamesOffset + nn.index).addUserName(nn.name, true);
        }
        it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetCell.NetName)it.next();
            if (nn.index < this.exportedNetNameCount) continue;
            this.netlistF.getNetworkByMap(this.netNamesOffset + nn.index).addUserName(nn.name, false);
            this.netlistT.getNetworkByMap(this.netNamesOffset + nn.index).addUserName(nn.name, false);
        }
        int numArcs = this.cell.getNumArcs();
        for (int i3 = 0; i3 < numArcs; ++i3) {
            ArcInst ai = this.cell.getArc(i3);
            int drawn = this.drawns[this.arcsOffset + i3];
            if (drawn < 0) continue;
            for (int j = 0; j < this.drawnWidths[drawn]; ++j) {
                Network networkT;
                Network networkF = this.netlistF.getNetwork(ai, j);
                if (networkF != null && networkF.hasNames()) {
                    networkF = null;
                }
                if ((networkT = this.netlistT.getNetwork(ai, j)) != null && networkT.hasNames()) {
                    networkT = null;
                }
                if (networkF == null && networkT == null || this.drawnNames[drawn] == null) continue;
                String netName = this.drawnWidths[drawn] == 1 ? this.drawnNames[drawn].toString() : (this.drawnNames[drawn].isTempname() ? this.drawnNames[drawn].toString() + "[" + j + "]" : this.drawnNames[drawn].subname(j).toString());
                if (networkF != null) {
                    networkF.addTempName(netName);
                }
                if (networkT == null) continue;
                networkT.addTempName(netName);
            }
        }
        Iterator it2 = this.getNodables();
        while (it2.hasNext()) {
            Nodable no = (Nodable)it2.next();
            NodeProto np = no.getProto();
            int numPorts = np.getNumPorts();
            for (int i4 = 0; i4 < numPorts; ++i4) {
                PortProto pp = np.getPort(i4);
                int busWidth = pp.getNameKey().busWidth();
                for (int k = 0; k < busWidth; ++k) {
                    Network networkT;
                    Network networkF = this.netlistF.getNetwork(no, pp, k);
                    if (networkF != null && !networkF.hasNames()) {
                        networkF.addTempName(no.getName() + "." + pp.getNameKey().subname(k));
                    }
                    if ((networkT = this.netlistT.getNetwork(no, pp, k)) == null || networkT.hasNames()) continue;
                    networkT.addTempName(no.getName() + "." + pp.getNameKey().subname(k));
                }
            }
        }
        int numNodes = this.cell.getNumNodes();
        for (int n = 0; n < numNodes; ++n) {
            NodeInst ni = this.cell.getNode(n);
            NodeProto np = ni.getProto();
            int arraySize = ni.getNameKey().busWidth();
            int numPorts = np.getNumPorts();
            for (int i5 = 0; i5 < numPorts; ++i5) {
                PortProto pp = np.getPort(i5);
                int drawn = this.drawns[this.ni_pi[n] + i5];
                if (drawn < 0) continue;
                int busWidth = pp.getNameKey().busWidth();
                int drawnWidth = this.drawnWidths[drawn];
                for (int l = 0; l < drawnWidth; ++l) {
                    Network networkT;
                    Network networkF = this.netlistF.getNetworkByMap(this.drawnOffsets[drawn] + l);
                    if (networkF != null && !networkF.hasNames()) {
                        int arrayIndex = l / busWidth % arraySize;
                        int busIndex = l % busWidth;
                        networkF.addTempName(ni.getNameKey().subname(arrayIndex) + "." + pp.getNameKey().subname(busIndex));
                    }
                    if ((networkT = this.netlistT.getNetworkByMap(this.drawnOffsets[drawn] + l)) == null || networkT.hasNames()) continue;
                    int arrayIndex = l / busWidth % arraySize;
                    int busIndex = l % busWidth;
                    networkT.addTempName(ni.getNameKey().subname(arrayIndex) + "." + pp.getNameKey().subname(busIndex));
                }
            }
        }
        int numNetworks = this.netlistF.getNumNetworks();
        for (i = 0; i < numNetworks; ++i) {
            if (!$assertionsDisabled && !this.netlistF.getNetwork(i).hasNames()) {
                throw new AssertionError();
            }
        }
        numNetworks = this.netlistT.getNumNetworks();
        for (i = 0; i < numNetworks; ++i) {
            if (!$assertionsDisabled && !this.netlistT.getNetwork(i).hasNames()) {
                throw new AssertionError();
            }
        }
    }

    private boolean updateInterface() {
        boolean changed = false;
        for (int i = 0; i < this.equivPortsF.length; ++i) {
            if (this.equivPortsF[i] != this.netlistF.netMap[i]) {
                changed = true;
                this.equivPortsF[i] = this.netlistF.netMap[i];
            }
            if (this.equivPortsT[i] == this.netlistT.netMap[i]) continue;
            changed = true;
            this.equivPortsT[i] = this.netlistT.netMap[i];
        }
        return changed;
    }

    boolean redoNetworks1() {
        int numPorts = this.cell.getNumPorts();
        if (this.portOffsets.length != numPorts + 1) {
            this.portOffsets = new int[numPorts + 1];
        }
        if (this.drawnNames == null || this.drawnNames.length != this.numDrawns) {
            this.drawnNames = new Name[this.numDrawns];
            this.drawnWidths = new int[this.numDrawns];
            this.drawnOffsets = new int[this.numDrawns];
        }
        this.calcDrawnWidths();
        boolean changed = this.initNodables();
        int mapSize = this.netNamesOffset + this.netNames.size();
        this.netlistF = new Netlist((NetCell)this, false, mapSize);
        this.localConnections();
        this.netlistT = new Netlist((NetCell)this, true, this.netlistF);
        this.internalConnections();
        this.buildNetworkLists();
        if (this.updatePortImplementation()) {
            changed = true;
        }
        if (this.updateInterface()) {
            changed = true;
        }
        return changed;
    }

    static {
        $assertionsDisabled = !NetSchem.class.desiredAssertionStatus();
    }

    private class Proxy
    implements Nodable {
        NodeInst nodeInst;
        int arrayIndex;
        int nodeOffset;
        MultiProxy[] shared;

        Proxy(NodeInst nodeInst, int arrayIndex) {
            this.nodeInst = nodeInst;
            this.arrayIndex = arrayIndex;
        }

        private final boolean isShared() {
            return this.shared != null;
        }

        private boolean hasMulti(Cell iconCell) {
            if (this.shared == null) {
                return this.nodeInst.getProto() == iconCell;
            }
            for (int i = 0; i < this.shared.length; ++i) {
                if (this.shared[i].nodeInst.getProto() != iconCell) continue;
                return true;
            }
            return false;
        }

        private void addMulti(NodeInst nodeInst, int arrayIndex) {
            if (this.shared == null) {
                this.shared = new MultiProxy[2];
                this.shared[0] = new MultiProxy(this.nodeInst, this.arrayIndex);
            } else {
                MultiProxy[] newShared = new MultiProxy[this.shared.length + 1];
                for (int i = 0; i < this.shared.length; ++i) {
                    newShared[i] = this.shared[i];
                }
                this.shared = newShared;
            }
            this.shared[this.shared.length - 1] = new MultiProxy(nodeInst, arrayIndex);
        }

        public NodeProto getProto() {
            NetSchem schem = NetworkTool.getNetCell((Cell)this.nodeInst.getProto()).getSchem();
            return schem.cell;
        }

        public int getNumActualProtos() {
            return this.shared == null ? 1 : this.shared.length;
        }

        public NodeProto getActualProto(int i) {
            if (this.shared == null && i == 0) {
                return this.nodeInst.getProto();
            }
            return this.shared[i].nodeInst.getProto();
        }

        public Cell getParent() {
            return NetSchem.this.cell;
        }

        public String getName() {
            return this.getNameKey().toString();
        }

        public Name getNameKey() {
            return this.nodeInst.getNameKey().subname(this.arrayIndex);
        }

        public Variable getVar(String name) {
            if (this.shared == null) {
                return this.nodeInst.getVar(name);
            }
            Variable var = null;
            for (int i = 0; i < this.shared.length; ++i) {
                Variable v = this.shared[i].nodeInst.getVar(name);
                if (v == null) continue;
                if (var == null) {
                    var = v;
                    continue;
                }
                if (v.getObject().equals(var.getObject())) continue;
                String msg = "Network: " + NetSchem.this.cell + " has multipart icon <" + this.getName() + "> with ambigouos definition of variable " + name;
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, NetSchem.this.cell, 1);
                log.addGeom(this.shared[i].nodeInst, true, NetSchem.this.cell, null);
            }
            return var;
        }

        public Variable getVar(Variable.Key key) {
            if (this.shared == null) {
                return this.nodeInst.getVar(key);
            }
            Variable var = null;
            for (int i = 0; i < this.shared.length; ++i) {
                Variable v = this.shared[i].nodeInst.getVar(key);
                if (v == null) continue;
                if (var == null) {
                    var = v;
                    continue;
                }
                if (v.getObject().equals(var.getObject())) continue;
                String msg = "Network: " + NetSchem.this.cell + " has multipart icon <" + this.getName() + "> with ambigouos definition of variable " + key.getName();
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, NetSchem.this.cell, 1);
                log.addGeom(this.shared[i].nodeInst, true, NetSchem.this.cell, null);
            }
            return var;
        }

        public Variable getParameter(String name) {
            if (this.shared == null) {
                return this.nodeInst.getParameter(name);
            }
            Variable var = null;
            for (int i = 0; i < this.shared.length; ++i) {
                Variable v = this.shared[i].nodeInst.getParameter(name);
                if (v == null) continue;
                if (var == null) {
                    var = v;
                    continue;
                }
                if (v.getObject().equals(var.getObject())) continue;
                String msg = "Network: " + NetSchem.this.cell + " has multipart icon <" + this.getName() + "> with ambigouos definition of parameter " + name;
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, NetSchem.this.cell, 1);
                log.addGeom(this.shared[i].nodeInst, true, NetSchem.this.cell, null);
            }
            return var;
        }

        public Variable newVar(String name, Object value) {
            if (this.shared == null) {
                return this.nodeInst.newVar(name, value);
            }
            Variable v = this.shared[0].nodeInst.newVar(name, value);
            return v;
        }

        public Variable newVar(Variable.Key key, Object value) {
            if (this.shared == null) {
                return this.nodeInst.newVar(key, value);
            }
            Variable v = this.shared[0].nodeInst.newVar(key, value);
            return v;
        }

        public void delVar(Variable.Key key) {
            if (this.shared == null) {
                this.nodeInst.delVar(key);
            } else {
                for (int i = 0; i < this.shared.length; ++i) {
                    if (this.shared[i].nodeInst.getVar(key) == null) continue;
                    this.shared[i].nodeInst.delVar(key);
                    return;
                }
            }
        }

        public ElectricObject getVarDefaultOwner() {
            return this.nodeInst.getVarDefaultOwner();
        }

        public Iterator getVariables() {
            if (this.shared == null) {
                return this.nodeInst.getVariables();
            }
            ArrayList allVariables = new ArrayList();
            for (int i = 0; i < this.shared.length; ++i) {
                Iterator it = this.shared[i].nodeInst.getVariables();
                while (it.hasNext()) {
                    allVariables.add(it.next());
                }
            }
            return allVariables.iterator();
        }

        public Iterator getParameters() {
            if (this.shared == null) {
                return this.nodeInst.getParameters();
            }
            HashMap<Variable.Key, Variable> allParameters = new HashMap<Variable.Key, Variable>();
            for (int i = 0; i < this.shared.length; ++i) {
                Iterator it = this.shared[i].nodeInst.getParameters();
                while (it.hasNext()) {
                    Variable v = (Variable)it.next();
                    Variable var = (Variable)allParameters.get(v.getKey());
                    if (var == null) {
                        allParameters.put(v.getKey(), v);
                        continue;
                    }
                    if (var.getObject().equals(v.getObject())) continue;
                    String msg = "Network: " + NetSchem.this.cell + " has multipart icon <" + this.getName() + "> with ambigouos definition of variable " + v.getKey().getName();
                    System.out.println(msg);
                    ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, NetSchem.this.cell, 1);
                    log.addGeom(this.shared[i].nodeInst, true, NetSchem.this.cell, null);
                }
            }
            return allParameters.values().iterator();
        }

        public String toString() {
            return "NetSchem.Proxy " + this.getName();
        }

        public boolean contains(NodeInst ni, int arrayIndex) {
            return this.nodeInst == ni && this.arrayIndex == arrayIndex;
        }

        public NodeInst getNodeInst() {
            return this.nodeInst;
        }
    }

    private static class MultiProxy {
        NodeInst nodeInst;
        int arrayIndex;

        MultiProxy(NodeInst nodeInst, int arrayIndex) {
            this.nodeInst = nodeInst;
            this.arrayIndex = arrayIndex;
        }
    }
}

