/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.ImmutableVariable;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class JELIB
extends Output {
    static final /* synthetic */ boolean $assertionsDisabled;

    JELIB() {
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        Cell cell;
        this.gatherReferencedObjects(lib, false);
        this.printWriter.println("# header information:");
        this.printWriter.print("H" + this.convertString(lib.getName()) + "|" + Version.getVersion());
        this.printlnVars(lib, null);
        boolean viewHeaderPrinted = false;
        Iterator it = View.getViews();
        while (it.hasNext()) {
            View view = (View)it.next();
            if (!this.objInfo.containsKey(view)) continue;
            if (!viewHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Views:");
                viewHeaderPrinted = true;
            }
            this.printWriter.println("V" + this.convertString(view.getFullName()) + "|" + this.convertString(view.getAbbreviation()));
        }
        boolean libraryHeaderPrinted = false;
        Iterator it2 = Library.getLibraries();
        while (it2.hasNext()) {
            String thisLibPath;
            String mainLibPath;
            Library eLib = (Library)it2.next();
            if (eLib == lib || !this.objInfo.containsKey(eLib)) continue;
            if (!libraryHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# External Libraries and cells:");
                libraryHeaderPrinted = true;
            }
            URL libUrl = eLib.getLibFile();
            String libFile = eLib.getName();
            if (libUrl != null && !(mainLibPath = TextUtils.getFilePath(lib.getLibFile())).equals(thisLibPath = TextUtils.getFilePath(libUrl))) {
                libFile = libUrl.toString();
            }
            this.printWriter.println();
            this.printWriter.println("L" + this.convertString(eLib.getName()) + "|" + this.convertString(libFile));
            Iterator cIt = eLib.getCells();
            while (cIt.hasNext()) {
                Cell cell2 = (Cell)cIt.next();
                if (!this.objInfo.containsKey(cell2)) continue;
                Rectangle2D bounds = cell2.getBounds();
                this.printWriter.println("R" + this.convertString(cell2.getCellName().toString()) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMinX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMaxX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMinY()), 0) + "|" + TextUtils.formatDouble(DBMath.round(bounds.getMaxY()), 0) + "|" + cell2.getCreationDate().getTime() + "|" + cell2.getRevisionDate().getTime());
                this.objInfo.put(cell2, this.getFullCellName(cell2));
                Iterator eIt = cell2.getPorts();
                while (eIt.hasNext()) {
                    Export export = (Export)eIt.next();
                    Poly poly = export.getOriginalPort().getPoly();
                    this.printWriter.println("F" + this.convertString(export.getName()) + "|" + TextUtils.formatDouble(DBMath.round(poly.getCenterX()), 0) + "|" + TextUtils.formatDouble(DBMath.round(poly.getCenterY()), 0));
                }
            }
        }
        boolean toolHeaderPrinted = false;
        Iterator it3 = Tool.getTools();
        while (it3.hasNext()) {
            Tool tool = (Tool)it3.next();
            if (Pref.getMeaningVariables(tool).size() == 0) continue;
            if (!toolHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Tools:");
                toolHeaderPrinted = true;
            }
            this.printWriter.print("O" + this.convertString(tool.getName()));
            this.printlnMeaningPrefs(tool);
        }
        boolean technologyHeaderPrinted = false;
        Iterator it4 = Technology.getTechnologies();
        while (it4.hasNext()) {
            Technology tech = (Technology)it4.next();
            if (!this.objInfo.containsKey(tech)) continue;
            if (!technologyHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Technologies:");
                technologyHeaderPrinted = true;
            }
            this.printWriter.print("T" + this.convertString(tech.getTechName()));
            this.printlnMeaningPrefs(tech);
        }
        LinkedHashSet<Cell.CellGroup> groups = new LinkedHashSet<Cell.CellGroup>();
        Iterator cIt = lib.getCells();
        while (cIt.hasNext()) {
            cell = (Cell)cIt.next();
            if (!groups.contains(cell.getCellGroup())) {
                groups.add(cell.getCellGroup());
            }
            this.objInfo.put(cell, this.convertString(cell.getCellName().toString()));
        }
        cIt = lib.getCells();
        while (cIt.hasNext()) {
            cell = (Cell)cIt.next();
            this.printWriter.println();
            this.printWriter.println("# Cell " + cell.noLibDescribe());
            this.printWriter.print("C" + this.convertString(cell.getCellName().toString()));
            this.printWriter.print("|" + this.convertString(cell.getTechnology().getTechName()));
            this.printWriter.print("|" + cell.getCreationDate().getTime());
            this.printWriter.print("|" + cell.getRevisionDate().getTime());
            StringBuffer cellBits = new StringBuffer();
            if (cell.isInCellLibrary()) {
                cellBits.append("C");
            }
            if (cell.isWantExpanded()) {
                cellBits.append("E");
            }
            if (cell.isInstancesLocked()) {
                cellBits.append("I");
            }
            if (cell.isAllLocked()) {
                cellBits.append("L");
            }
            if (cell.isInTechnologyLibrary()) {
                cellBits.append("T");
            }
            this.printWriter.print("|" + cellBits.toString());
            this.printlnVars(cell, cell);
            Iterator it5 = cell.getNodes();
            while (it5.hasNext()) {
                int ts;
                int angle;
                NodeInst ni = (NodeInst)it5.next();
                NodeProto np = ni.getProto();
                if (np instanceof Cell) {
                    this.printWriter.print("I" + this.objInfo.get(np));
                } else {
                    PrimitiveNode prim = (PrimitiveNode)np;
                    if (cell.getTechnology() == prim.getTechnology()) {
                        this.printWriter.print("N" + this.convertString(prim.getName()));
                    } else {
                        this.printWriter.print("N" + this.convertString(prim.getFullName()));
                    }
                }
                String diskNodeName = this.getGeomName(ni);
                this.objInfo.put(ni, diskNodeName);
                this.printWriter.print("|" + diskNodeName + "|");
                if (!ni.getNameKey().isTempname()) {
                    this.printWriter.print(this.describeDescriptor(null, ni.getTextDescriptor(NodeInst.NODE_NAME_TD)));
                }
                this.printWriter.print("|" + TextUtils.formatDouble(ni.getAnchorCenterX(), 0));
                this.printWriter.print("|" + TextUtils.formatDouble(ni.getAnchorCenterY(), 0));
                if (np instanceof PrimitiveNode) {
                    this.printWriter.print("|" + TextUtils.formatDouble(ni.getXSize(), 0));
                    this.printWriter.print("|" + TextUtils.formatDouble(ni.getYSize(), 0));
                }
                this.printWriter.print('|');
                if (ni.isXMirrored()) {
                    this.printWriter.print('X');
                }
                if (ni.isYMirrored()) {
                    this.printWriter.print('Y');
                }
                if ((angle = ni.getAngle() % 3600) == 900 || angle == -2700) {
                    this.printWriter.print("R");
                } else if (angle == 1800 || angle == -1800) {
                    this.printWriter.print("RR");
                } else if (angle == 2700 || angle == -900) {
                    this.printWriter.print("RRR");
                } else if (angle != 0) {
                    this.printWriter.print(angle);
                }
                StringBuffer nodeBits = new StringBuffer();
                if (ni.isHardSelect()) {
                    nodeBits.append("A");
                }
                if (ni.isLocked()) {
                    nodeBits.append("L");
                }
                if (ni.isVisInside()) {
                    nodeBits.append("V");
                }
                if ((ts = ni.getTechSpecific()) != 0) {
                    nodeBits.append(ts);
                }
                this.printWriter.print("|" + nodeBits.toString());
                if (np instanceof Cell) {
                    String tdString = this.describeDescriptor(null, ni.getTextDescriptor(NodeInst.NODE_PROTO_TD));
                    this.printWriter.print("|" + tdString);
                }
                this.printlnVars(ni, cell);
            }
            it5 = cell.getArcs();
            while (it5.hasNext()) {
                ArcInst ai = (ArcInst)it5.next();
                ArcProto ap = ai.getProto();
                if (cell.getTechnology() == ap.getTechnology()) {
                    this.printWriter.print("A" + this.convertString(ap.getName()));
                } else {
                    this.printWriter.print("A" + this.convertString(ap.getFullName()));
                }
                this.printWriter.print("|" + this.getGeomName(ai) + "|");
                if (!ai.getNameKey().isTempname()) {
                    this.printWriter.print(this.describeDescriptor(null, ai.getTextDescriptor(ArcInst.ARC_NAME_TD)));
                }
                this.printWriter.print("|" + TextUtils.formatDouble(ai.getWidth(), 0));
                StringBuffer arcBits = new StringBuffer();
                if (ai.isHardSelect()) {
                    arcBits.append("A");
                }
                if (ai.isBodyArrowed()) {
                    arcBits.append("B");
                }
                if (!ai.isFixedAngle()) {
                    arcBits.append("F");
                }
                if (ai.isHeadNegated()) {
                    arcBits.append("G");
                }
                if (!ai.isHeadExtended()) {
                    arcBits.append("I");
                }
                if (!ai.isTailExtended()) {
                    arcBits.append("J");
                }
                if (ai.isTailNegated()) {
                    arcBits.append("N");
                }
                if (ai.isRigid()) {
                    arcBits.append("R");
                }
                if (ai.isSlidable()) {
                    arcBits.append("S");
                }
                if (ai.isHeadArrowed()) {
                    arcBits.append("X");
                }
                if (ai.isTailArrowed()) {
                    arcBits.append("Y");
                }
                this.printWriter.print("|" + arcBits.toString() + ai.getAngle());
                for (int e = 1; e >= 0; --e) {
                    NodeInst ni = ai.getPortInst(e).getNodeInst();
                    this.printWriter.print("|" + this.objInfo.get(ni) + "|");
                    PortProto pp = ai.getPortInst(e).getPortProto();
                    if (ni.getProto().getNumPorts() > 1) {
                        this.printWriter.print(this.convertString(pp.getName()));
                    }
                    this.printWriter.print("|" + TextUtils.formatDouble(ai.getLocation(e).getX(), 0));
                    this.printWriter.print("|" + TextUtils.formatDouble(ai.getLocation(e).getY(), 0));
                }
                this.printlnVars(ai, cell);
            }
            it5 = cell.getPorts();
            while (it5.hasNext()) {
                Export pp = (Export)it5.next();
                this.printWriter.print("E" + this.convertString(pp.getName()));
                this.printWriter.print("|" + this.describeDescriptor(null, pp.getTextDescriptor(Export.EXPORT_NAME_TD)));
                PortInst subPI = pp.getOriginalPort();
                NodeInst subNI = subPI.getNodeInst();
                PortProto subPP = subPI.getPortProto();
                this.printWriter.print("|" + this.objInfo.get(subNI) + "|");
                if (subNI.getProto().getNumPorts() > 1) {
                    this.printWriter.print(this.convertString(subPP.getName()));
                }
                this.printWriter.print("|" + pp.getCharacteristic().getShortName());
                if (pp.isAlwaysDrawn()) {
                    this.printWriter.print("/A");
                }
                if (pp.isBodyOnly()) {
                    this.printWriter.print("/B");
                }
                this.printlnVars(pp, cell);
            }
            this.printWriter.println("X");
        }
        this.printWriter.println();
        this.printWriter.println("# Groups:");
        Iterator it6 = groups.iterator();
        while (it6.hasNext()) {
            Cell.CellGroup group = (Cell.CellGroup)it6.next();
            this.printWriter.print("G");
            Cell main = group.getMainSchematics();
            if (main != null) {
                this.printWriter.print(this.convertString(main.getCellName().toString()));
            }
            Iterator cIt2 = group.getCells();
            while (cIt2.hasNext()) {
                Cell cell3 = (Cell)cIt2.next();
                if (cell3 == main) continue;
                this.printWriter.print("|");
                this.printWriter.print((String)this.objInfo.get(cell3));
            }
            this.printWriter.println();
        }
        lib.clearChanged();
        lib.setFromDisk();
        System.out.println(this.filePath + " written");
        return false;
    }

    private String getGeomName(Geometric geom) {
        int duplicate = geom.getDuplicate();
        if (duplicate == 0) {
            return this.convertString(geom.getName());
        }
        return "\"" + this.convertQuotedString(geom.getName()) + "\"" + duplicate;
    }

    private String describeDescriptor(ImmutableVariable var, TextDescriptor td) {
        TextDescriptor.Unit unit;
        Object value;
        StringBuffer ret = new StringBuffer();
        boolean display = false;
        if (var == null || td.isDisplay()) {
            display = true;
        }
        if (display) {
            int color;
            TextDescriptor.Size size = td.getSize();
            if (size.isAbsolute()) {
                ret.append("A" + (int)size.getSize() + ";");
            }
            if (td.isBold()) {
                ret.append("B");
            }
            if ((color = td.getColorIndex()) != 0) {
                ret.append("C" + color + ";");
            }
            ret.append("D");
            TextDescriptor.Position pos = td.getPos();
            if (pos == TextDescriptor.Position.UP) {
                ret.append("8");
            } else if (pos == TextDescriptor.Position.DOWN) {
                ret.append("2");
            } else if (pos == TextDescriptor.Position.LEFT) {
                ret.append("4");
            } else if (pos == TextDescriptor.Position.RIGHT) {
                ret.append("6");
            } else if (pos == TextDescriptor.Position.UPLEFT) {
                ret.append("7");
            } else if (pos == TextDescriptor.Position.UPRIGHT) {
                ret.append("9");
            } else if (pos == TextDescriptor.Position.DOWNLEFT) {
                ret.append("1");
            } else if (pos == TextDescriptor.Position.DOWNRIGHT) {
                ret.append("3");
            } else if (pos == TextDescriptor.Position.BOXED) {
                ret.append("0");
            } else {
                ret.append("5");
            }
            int font = td.getFace();
            if (font != 0) {
                TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(font);
                ret.append("F" + this.convertString(af.toString()) + ";");
            }
            if (!size.isAbsolute()) {
                ret.append("G" + TextUtils.formatDouble(size.getSize()) + ";");
            }
        }
        if (td.isInherit()) {
            ret.append("H");
        }
        if (display) {
            TextDescriptor.DispPos dispPos;
            if (td.isItalic()) {
                ret.append("I");
            }
            if (td.isUnderline()) {
                ret.append("L");
            }
            if ((dispPos = td.getDispPart()) == TextDescriptor.DispPos.NAMEVALUE) {
                ret.append("N");
            }
        }
        if (var != null && td.isCode() && ((value = var.getValue()) instanceof String || value instanceof String[])) {
            TextDescriptor.Code codeType = td.getCode();
            if (codeType == TextDescriptor.Code.JAVA) {
                ret.append("OJ");
            } else if (codeType == TextDescriptor.Code.LISP) {
                ret.append("OL");
            } else if (codeType == TextDescriptor.Code.TCL) {
                ret.append("OT");
            }
        }
        if (var != null && td.isParam()) {
            ret.append("P");
        }
        if (display) {
            TextDescriptor.Rotation rot = td.getRotation();
            if (rot == TextDescriptor.Rotation.ROT90) {
                ret.append("R");
            } else if (rot == TextDescriptor.Rotation.ROT180) {
                ret.append("RR");
            } else if (rot == TextDescriptor.Rotation.ROT270) {
                ret.append("RRR");
            }
        }
        if (td.isInterior()) {
            ret.append("T");
        }
        if ((unit = td.getUnit()) == TextDescriptor.Unit.RESISTANCE) {
            ret.append("UR");
        } else if (unit == TextDescriptor.Unit.CAPACITANCE) {
            ret.append("UC");
        } else if (unit == TextDescriptor.Unit.INDUCTANCE) {
            ret.append("UI");
        } else if (unit == TextDescriptor.Unit.CURRENT) {
            ret.append("UA");
        } else if (unit == TextDescriptor.Unit.VOLTAGE) {
            ret.append("UV");
        } else if (unit == TextDescriptor.Unit.DISTANCE) {
            ret.append("UD");
        } else if (unit == TextDescriptor.Unit.TIME) {
            ret.append("UT");
        }
        if (display) {
            double offY;
            double offX = td.getXOff();
            if (offX != 0.0) {
                ret.append("X" + TextUtils.formatDouble(offX, 0) + ";");
            }
            if ((offY = td.getYOff()) != 0.0) {
                ret.append("Y" + TextUtils.formatDouble(offY, 0) + ";");
            }
        }
        return ret.toString();
    }

    private void printlnVars(ElectricObject eObj, Cell curCell) {
        this.printVars(eObj, curCell);
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                if (pi.getNumVariables() == 0) continue;
                this.printVars(pi, curCell);
            }
        }
        this.printWriter.println();
    }

    private void printVars(ElectricObject eObj, Cell curCell) {
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            ImmutableVariable v = var.getD();
            String tdString = this.describeDescriptor(v, v.descriptor);
            this.printWriter.print("|" + this.convertVariableName(this.diskName(var)) + "(" + tdString + ")");
            Object varObj = v.getValueInCurrentThread();
            String pt = this.makeString(varObj, curCell);
            if (pt == null) {
                pt = "";
            }
            this.printWriter.print(pt);
        }
    }

    private void printlnMeaningPrefs(Object obj) {
        List prefs = Pref.getMeaningVariables(obj);
        Iterator it = prefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            Object value = pref.getValue();
            this.printWriter.print("|" + this.convertVariableName(pref.getPrefName()) + "()" + this.makeString(value, null));
        }
        this.printWriter.println();
    }

    private String makeString(Object obj, Cell curCell) {
        StringBuffer infstr = new StringBuffer();
        char type = this.getVarType(obj);
        infstr.append(type);
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            infstr.append('[');
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i != 0) {
                    infstr.append(',');
                }
                this.makeStringVar(infstr, type, oneObj, curCell, true);
            }
            infstr.append(']');
        } else {
            this.makeStringVar(infstr, type, obj, curCell, false);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, char type, Object obj, Cell curCell, boolean inArray) {
        if (obj == null) {
            return;
        }
        switch (type) {
            case 'B': {
                infstr.append((Boolean)obj != false ? (char)'T' : 'F');
                return;
            }
            case 'C': {
                infstr.append(this.convertString(this.getFullCellName((Cell)obj), inArray));
                return;
            }
            case 'D': {
                infstr.append((Double)obj);
                return;
            }
            case 'E': {
                Export pp = (Export)obj;
                infstr.append(this.convertString(this.getFullCellName((Cell)pp.getParent()) + ":" + pp.getName(), inArray));
                return;
            }
            case 'F': {
                infstr.append(((Float)obj).floatValue());
                return;
            }
            case 'G': {
                infstr.append((Long)obj);
                return;
            }
            case 'H': {
                infstr.append(((Short)obj).shortValue());
                return;
            }
            case 'I': {
                infstr.append((Integer)obj);
                return;
            }
            case 'L': {
                infstr.append(this.convertString(((Library)obj).getName(), inArray));
                return;
            }
            case 'O': {
                infstr.append(this.convertString(((Tool)obj).getName(), inArray));
                return;
            }
            case 'P': {
                infstr.append(this.convertString(((PrimitiveNode)obj).getFullName(), inArray));
                return;
            }
            case 'R': {
                infstr.append(this.convertString(((ArcProto)obj).getFullName(), inArray));
                return;
            }
            case 'S': {
                infstr.append(this.convertString((String)obj, inArray));
                return;
            }
            case 'T': {
                infstr.append(this.convertString(((Technology)obj).getTechName(), inArray));
                return;
            }
            case 'V': {
                EPoint pt2 = (EPoint)obj;
                infstr.append(TextUtils.formatDouble(pt2.getX(), 0) + "/" + TextUtils.formatDouble(pt2.getY(), 0));
                return;
            }
            case 'Y': {
                infstr.append(((Byte)obj).byteValue());
                return;
            }
        }
    }

    private String getFullCellName(Cell cell) {
        return this.convertString(cell.getLibrary().getName() + ":" + cell.getCellName());
    }

    private char getVarType(Object obj) {
        if (obj instanceof String || obj instanceof String[]) {
            return 'S';
        }
        if (obj instanceof ArcInst || obj instanceof ArcInst[]) {
            return 'S';
        }
        if (obj instanceof Boolean || obj instanceof Boolean[]) {
            return 'B';
        }
        if (obj instanceof Cell || obj instanceof Cell[]) {
            return 'C';
        }
        if (obj instanceof Double || obj instanceof Double[]) {
            return 'D';
        }
        if (obj instanceof Export || obj instanceof Export[]) {
            return 'E';
        }
        if (obj instanceof Float || obj instanceof Float[]) {
            return 'F';
        }
        if (obj instanceof Long || obj instanceof Long[]) {
            return 'G';
        }
        if (obj instanceof Short || obj instanceof Short[]) {
            return 'H';
        }
        if (obj instanceof Integer || obj instanceof Integer[]) {
            return 'I';
        }
        if (obj instanceof Library || obj instanceof Library[]) {
            return 'L';
        }
        if (obj instanceof NodeInst || obj instanceof NodeInst[]) {
            return 'S';
        }
        if (obj instanceof Tool || obj instanceof Tool[]) {
            return 'O';
        }
        if (obj instanceof PrimitiveNode || obj instanceof PrimitiveNode[]) {
            return 'P';
        }
        if (obj instanceof ArcProto || obj instanceof ArcProto[]) {
            return 'R';
        }
        if (obj instanceof Technology || obj instanceof Technology[]) {
            return 'T';
        }
        if (obj instanceof EPoint || obj instanceof EPoint[]) {
            return 'V';
        }
        if (obj instanceof Byte || obj instanceof Byte[]) {
            return 'Y';
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(obj);
        }
        return 'X';
    }

    private String convertQuotedString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                infstr.append("\\n");
                continue;
            }
            if (ch == '\r') {
                infstr.append("\\r");
                continue;
            }
            if (ch == '\"' || ch == '\\') {
                infstr.append('\\');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private String convertString(String str) {
        return this.convertString(str, '\u0000', '\u0000');
    }

    private String convertString(String str, char delim1, char delim2) {
        if (!(str.length() == 0 || str.indexOf(10) >= 0 || str.indexOf(13) >= 0 || str.indexOf(92) >= 0 || str.indexOf(34) >= 0 || str.indexOf(124) >= 0 || delim1 != '\u0000' && str.indexOf(delim1) >= 0 || delim2 != '\u0000' && str.indexOf(delim2) >= 0)) {
            return str;
        }
        return '\"' + this.convertQuotedString(str) + '\"';
    }

    private String convertVariableName(String str) {
        return this.convertString(str, '(', '\u0000');
    }

    private String convertString(String str, boolean inArray) {
        return inArray ? this.convertString(str, ',', ']') : this.convertString(str, '\u0000', '\u0000');
    }

    static {
        $assertionsDisabled = !JELIB.class.desiredAssertionStatus();
    }
}

