/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Port
extends NetObject {
    private Wire wire;
    private List names = new ArrayList();
    private List types = new ArrayList();
    private boolean toBeRenamed = false;

    public Port(String name, Object type, Wire w) {
        this.wire = w;
        this.names.add(name);
        this.types.add(type);
    }

    public String getName() {
        LayoutLib.error(this.names.size() == 0, "Port with no name?");
        return (String)this.names.iterator().next();
    }

    public NetObject.Type getNetObjType() {
        return NetObject.Type.PORT;
    }

    public Iterator getConnected() {
        return new ArrayList().iterator();
    }

    public void addExport(String nm, PortCharacteristic type) {
        this.names.add(nm);
        this.types.add(type);
    }

    public PortCharacteristic getType() {
        HashMap<PortCharacteristic, Integer> typeToCount = new HashMap<PortCharacteristic, Integer>();
        Iterator it = this.types.iterator();
        while (it.hasNext()) {
            PortCharacteristic t = (PortCharacteristic)it.next();
            Integer count = (Integer)typeToCount.get(t);
            int c = count != null ? count : 0;
            typeToCount.put(t, new Integer(c + 1));
        }
        int popularCount = 0;
        PortCharacteristic popularType = null;
        Iterator it2 = typeToCount.keySet().iterator();
        while (it2.hasNext()) {
            PortCharacteristic t = (PortCharacteristic)it2.next();
            int count = (Integer)typeToCount.get(t);
            if (count <= popularCount && (count != popularCount || t == PortCharacteristic.UNKNOWN)) continue;
            popularCount = count;
            popularType = t;
        }
        return popularType;
    }

    public Wire getWire() {
        return this.wire;
    }

    public void checkMe(Circuit parent) {
        Port.error(parent != this.getParent(), "wrong parent");
        Port.error(this.wire == null, this.instanceDescription() + " has null connection");
        Port.error(!this.wire.touches(this), this.instanceDescription() + " has inconsistant connection to " + this.wire.instanceDescription());
    }

    public String exportNamesString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        Iterator it = new TreeSet(this.names).iterator();
        while (it.hasNext()) {
            if (sb.length() > 2) {
                sb.append(", ");
            }
            sb.append((String)it.next());
        }
        sb.append(" }");
        return sb.toString();
    }

    public Iterator getExportNames() {
        return this.names.iterator();
    }

    public boolean isDeleted() {
        return false;
    }

    public void setToBeRenamed() {
        this.toBeRenamed = true;
    }

    public boolean getToBeRenamed() {
        return this.toBeRenamed;
    }

    public String instanceDescription() {
        return "Port " + this.exportNamesString();
    }

    public String valueDescription() {
        return "";
    }

    public String connectionDescription(int n) {
        return "is on Wire: " + this.wire.getName();
    }
}

