/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class VerilogTab
extends PreferencePanel {
    private HashMap initialVerilogBehaveFiles;
    private JList verilogCellList;
    private DefaultListModel verilogCellListModel;
    private JLabel jLabel54;
    private JButton verBrowse;
    private JScrollPane verCells;
    private JCheckBox verDefWireTrireg;
    private JRadioButton verDeriveModel;
    private JTextField verFileName;
    private JComboBox verLibrary;
    private JCheckBox verUseAssign;
    private JRadioButton verUseModelFile;
    private JPanel verilog;
    private ButtonGroup verilogModel;

    public VerilogTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.verilog;
    }

    public String getName() {
        return "Verilog";
    }

    public void init() {
        Library lib;
        this.verUseAssign.setSelected(Simulation.getVerilogUseAssign());
        this.verDefWireTrireg.setSelected(Simulation.getVerilogUseTrireg());
        this.initialVerilogBehaveFiles = new HashMap();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                String behaveFile = "";
                Variable var = cell.getVar(Verilog.VERILOG_BEHAVE_FILE_KEY);
                if (var != null) {
                    behaveFile = var.getObject().toString();
                }
                this.initialVerilogBehaveFiles.put(cell, Pref.makeStringPref(null, null, behaveFile));
            }
        }
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            lib = (Library)it.next();
            this.verLibrary.addItem(lib.getName());
        }
        this.verLibrary.setSelectedItem(this.curLib.getName());
        this.verLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.verilogLoadCellList();
            }
        });
        this.verilogCellListModel = new DefaultListModel();
        this.verilogCellList = new JList(this.verilogCellListModel);
        this.verilogCellList.setSelectionMode(0);
        this.verCells.setViewportView(this.verilogCellList);
        this.verilogCellList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                VerilogTab.this.verilogCellListClick();
            }
        });
        this.verBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.verModelFileBrowseActionPerformed();
            }
        });
        this.verDeriveModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.verilogModelClick();
            }
        });
        this.verUseModelFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VerilogTab.this.verilogModelClick();
            }
        });
        this.verFileName.getDocument().addDocumentListener(new VerilogDocumentListener(this));
        this.verilogLoadCellList();
    }

    private void verModelFileBrowseActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.VERILOG, null);
        if (fileName == null) {
            return;
        }
        this.verUseModelFile.setSelected(true);
        this.verFileName.setEditable(true);
        this.verFileName.setText(fileName);
    }

    private void verilogLoadCellList() {
        String libName = (String)this.verLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        this.verilogCellListModel.clear();
        boolean notEmpty = false;
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            this.verilogCellListModel.addElement(cell.noLibDescribe());
            notEmpty = true;
        }
        if (notEmpty) {
            this.verilogCellList.setSelectedIndex(0);
            this.verilogCellListClick();
        }
    }

    private void verilogCellListClick() {
        String cellName;
        String libName = (String)this.verLibrary.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        Cell cell = lib.findNodeProto(cellName = (String)this.verilogCellList.getSelectedValue());
        if (cell == null) {
            return;
        }
        Pref pref = (Pref)this.initialVerilogBehaveFiles.get(cell);
        if (pref == null) {
            return;
        }
        String behaveFile = pref.getString();
        if (behaveFile.length() == 0) {
            this.verDeriveModel.setSelected(true);
            this.verFileName.setEditable(false);
            this.verFileName.setText("");
        } else {
            this.verUseModelFile.setSelected(true);
            this.verFileName.setEditable(true);
            this.verFileName.setText(behaveFile);
        }
    }

    private void verilogModelClick() {
        if (this.verDeriveModel.isSelected()) {
            this.verFileName.setEditable(false);
            this.verFileName.setText("");
        } else {
            this.verFileName.setEditable(true);
        }
    }

    public void term() {
        boolean currBoolean = this.verUseAssign.isSelected();
        if (currBoolean != Simulation.getVerilogUseAssign()) {
            Simulation.setVerilogUseAssign(currBoolean);
        }
        if ((currBoolean = this.verDefWireTrireg.isSelected()) != Simulation.getVerilogUseTrireg()) {
            Simulation.setVerilogUseTrireg(currBoolean);
        }
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Pref pref = (Pref)this.initialVerilogBehaveFiles.get(cell);
                if (pref == null || pref.getStringFactoryValue().equals(pref.getString())) continue;
                cell.newVar(Verilog.VERILOG_BEHAVE_FILE_KEY, (Object)pref.getString());
            }
        }
    }

    private void initComponents() {
        this.verilogModel = new ButtonGroup();
        this.verilog = new JPanel();
        this.jLabel54 = new JLabel();
        this.verLibrary = new JComboBox();
        this.verCells = new JScrollPane();
        this.verUseAssign = new JCheckBox();
        this.verDefWireTrireg = new JCheckBox();
        this.verDeriveModel = new JRadioButton();
        this.verUseModelFile = new JRadioButton();
        this.verBrowse = new JButton();
        this.verFileName = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                VerilogTab.this.closeDialog(evt);
            }
        });
        this.verilog.setLayout(new GridBagLayout());
        this.jLabel54.setText("Library:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.verilog.add((Component)this.jLabel54, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.verilog.add((Component)this.verCells, gridBagConstraints);
        this.verUseAssign.setText("Use ASSIGN Construct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verUseAssign, gridBagConstraints);
        this.verDefWireTrireg.setText("Default wire is Trireg");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verDefWireTrireg, gridBagConstraints);
        this.verDeriveModel.setText("Derive Model from Circuitry");
        this.verilogModel.add(this.verDeriveModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 4, 4, 4);
        this.verilog.add((Component)this.verDeriveModel, gridBagConstraints);
        this.verUseModelFile.setText("Use Model from File:");
        this.verilogModel.add(this.verUseModelFile);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verUseModelFile, gridBagConstraints);
        this.verBrowse.setText("Browse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.verilog.add((Component)this.verFileName, gridBagConstraints);
        this.getContentPane().add((Component)this.verilog, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class VerilogDocumentListener
    implements DocumentListener {
        VerilogTab dialog;

        VerilogDocumentListener(VerilogTab dialog) {
            this.dialog = dialog;
        }

        private void change(DocumentEvent e) {
            String text;
            String cellName;
            String libName = (String)this.dialog.verLibrary.getSelectedItem();
            Library lib = Library.findLibrary(libName);
            Cell cell = lib.findNodeProto(cellName = (String)this.dialog.verilogCellList.getSelectedValue());
            if (cell == null) {
                return;
            }
            Pref pref = (Pref)this.dialog.initialVerilogBehaveFiles.get(cell);
            if (pref == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            pref.setString(text);
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }
}

