/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.output.Output;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReadableDump
extends Output {
    private int nodeInstError;
    private int portProtoError;
    private int arcInstError;
    private int typeError;
    private LinkedHashMap<Cell, Integer> cellOrdering = new LinkedHashMap();
    private HashMap<Cell, GenMath.MutableInteger> cellGrouping;
    private HashMap<NodeInst, Integer> nodeMap;
    private HashMap<ArcInst, Integer> arcMap;
    private HashMap<Export, Integer> portMap;

    ReadableDump() {
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        Technology tech;
        Cell cell;
        Iterator<Cell> it;
        this.typeError = 0;
        this.arcInstError = 0;
        this.portProtoError = 0;
        this.nodeInstError = 0;
        this.gatherReferencedObjects(lib);
        this.cellGrouping = new HashMap();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library oLib = lIt.next();
            if (oLib == lib || !this.objInfo.containsKey(oLib)) continue;
            it = oLib.getCells();
            while (it.hasNext()) {
                cell = it.next();
                if (!this.objInfo.containsKey(cell)) continue;
                this.cellOrdering.put(cell, null);
            }
        }
        Iterator<Cell> it2 = lib.getCells();
        while (it2.hasNext()) {
            Cell cell2 = it2.next();
            if (this.cellOrdering.containsKey(cell2)) continue;
            this.textRecurse(lib, cell2);
        }
        int cellNumber = 0;
        for (Map.Entry<Cell, Integer> e : this.cellOrdering.entrySet()) {
            e.setValue(new Integer(cellNumber++));
        }
        Iterator<Cell> it3 = lib.getCells();
        while (it3.hasNext()) {
            Cell cell3 = it3.next();
            this.cellGrouping.put(cell3, new GenMath.MutableInteger(0));
        }
        int cellGroup = 0;
        it = lib.getCells();
        while (it.hasNext()) {
            cell = it.next();
            GenMath.MutableInteger mi = this.cellGrouping.get(cell);
            if (mi == null || mi.intValue() != 0) continue;
            ++cellGroup;
            Iterator<Cell> gIt = cell.getCellGroup().getCells();
            while (gIt.hasNext()) {
                Cell oCell = gIt.next();
                mi = this.cellGrouping.get(oCell);
                mi.setValue(cellGroup);
            }
        }
        int toolCount = 0;
        Iterator<Tool> it4 = Tool.getTools();
        while (it4.hasNext()) {
            Tool tool = it4.next();
            if (!this.objInfo.containsKey(tool)) continue;
            ++toolCount;
        }
        int techCount = 0;
        Iterator<Comparable<Technology>> it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = it5.next();
            if (!this.objInfo.containsKey(tech)) continue;
            ++techCount;
        }
        this.printWriter.println("****library: \"" + lib.getName() + "\"");
        this.printWriter.println("version: " + Version.getVersion());
        this.printWriter.println("aids: " + toolCount);
        it5 = Tool.getTools();
        while (it5.hasNext()) {
            Tool tool = (Tool)it5.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.printWriter.println("aidname: " + tool.getName());
            this.writeMeaningPrefs(tool);
        }
        this.printWriter.println("techcount: " + techCount);
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            if (!this.objInfo.containsKey(tech)) continue;
            this.printWriter.println("techname: " + tech.getTechName() + " lambda: " + (int)(tech.getScale() * 2.0));
            this.writeMeaningPrefs(tech);
        }
        it5 = View.getViews();
        while (it5.hasNext()) {
            View v = (View)it5.next();
            if (!this.objInfo.containsKey(v)) continue;
            this.printWriter.println("view: " + v.getFullName() + "{" + v.getAbbreviation() + "}");
        }
        this.printWriter.println("cellcount: " + cellNumber);
        this.writeVars(lib, null);
        for (Map.Entry<Cell, Integer> entry : this.cellOrdering.entrySet()) {
            NodeInst ni;
            Cell cell4 = entry.getKey();
            int groupIndex = 0;
            GenMath.MutableInteger mig = this.cellGrouping.get(cell4);
            if (mig != null) {
                groupIndex = mig.intValue();
            }
            this.printWriter.println("***cell: " + entry.getValue() + "/" + groupIndex);
            this.printWriter.print("name: " + cell4.getName());
            if (cell4.getView().getAbbreviation().length() > 0) {
                this.printWriter.print("{" + cell4.getView().getAbbreviation() + "}");
            }
            this.printWriter.println();
            this.printWriter.println("version: " + cell4.getVersion());
            this.printWriter.println("creationdate: " + ELIBConstants.dateToSeconds(cell4.getCreationDate()));
            this.printWriter.println("revisiondate: " + ELIBConstants.dateToSeconds(cell4.getRevisionDate()));
            ERectangle bounds = cell4.getBounds();
            Technology tech2 = cell4.getTechnology();
            double scale = tech2.getScale() * 2.0;
            int lowX = (int)(bounds.getMinX() * scale);
            int highX = (int)(bounds.getMaxX() * scale);
            int lowY = (int)(bounds.getMinY() * scale);
            int highY = (int)(bounds.getMaxY() * scale);
            this.printWriter.println("lowx: " + lowX + " highx: " + highX + " lowy: " + lowY + " highy: " + highY);
            if (cell4.getLibrary() != lib) {
                URL libUrl = cell4.getLibrary().getLibFile();
                String libFile = libUrl != null ? libUrl.getFile() : cell4.getLibrary().getName();
                this.printWriter.println("externallibrary: \"" + libFile + "\"");
                continue;
            }
            this.printWriter.println("userbits: " + (cell4.lowLevelGetUserbits() & 0xF00002));
            this.nodeMap = new HashMap();
            this.arcMap = new HashMap();
            this.portMap = new HashMap();
            int nodeCount = 0;
            int arcCount = 0;
            int portCount = 0;
            Iterator<Object> it6 = cell4.getNodes();
            while (it6.hasNext()) {
                ni = it6.next();
                this.nodeMap.put(ni, new Integer(nodeCount++));
            }
            it6 = cell4.getArcs();
            while (it6.hasNext()) {
                ArcInst ai = (ArcInst)it6.next();
                this.arcMap.put(ai, new Integer(arcCount++));
            }
            it6 = cell4.getPorts();
            while (it6.hasNext()) {
                Export pp = (Export)it6.next();
                this.portMap.put(pp, new Integer(portCount++));
            }
            this.printWriter.println("nodes: " + cell4.getNumNodes() + " arcs: " + cell4.getNumArcs() + " porttypes: " + cell4.getNumPorts());
            this.writeVars(cell4, cell4);
            it6 = cell4.getNodes();
            while (it6.hasNext()) {
                int transpose;
                ni = (NodeInst)it6.next();
                NodeProto np = ni.getProto();
                Integer nodeIndex = this.nodeMap.get(ni);
                this.printWriter.println("**node: " + nodeIndex);
                if (ni.isCellInstance()) {
                    Integer subMi = this.cellOrdering.get(np);
                    this.printWriter.println("type: [" + subMi + "]");
                } else {
                    this.printWriter.println("type: " + np.getTechnology().getTechName() + ":" + np.getName());
                }
                if (ni.isCellInstance()) {
                    lowX = (int)((ni.getTrueCenterX() - ni.getXSize() / 2.0) * scale);
                    highX = (int)((ni.getTrueCenterX() + ni.getXSize() / 2.0) * scale);
                    lowY = (int)((ni.getTrueCenterY() - ni.getYSize() / 2.0) * scale);
                    highY = (int)((ni.getTrueCenterY() + ni.getYSize() / 2.0) * scale);
                } else {
                    lowX = (int)((ni.getAnchorCenterX() - ni.getXSize() / 2.0) * scale);
                    highX = (int)((ni.getAnchorCenterX() + ni.getXSize() / 2.0) * scale);
                    lowY = (int)((ni.getAnchorCenterY() - ni.getYSize() / 2.0) * scale);
                    highY = (int)((ni.getAnchorCenterY() + ni.getYSize() / 2.0) * scale);
                }
                this.printWriter.println("lowx: " + lowX + " highx: " + highX + " lowy: " + lowY + " highy: " + highY);
                int angle = ni.getAngle();
                int n = transpose = ni.isXMirrored() != ni.isYMirrored() ? 1 : 0;
                if (ni.isXMirrored()) {
                    angle = ni.isYMirrored() ? (angle + 1800) % 3600 : (angle + 900) % 3600;
                } else if (ni.isYMirrored()) {
                    angle = (angle + 2700) % 3600;
                }
                this.printWriter.println("rotation: " + angle + " transpose: " + transpose);
                if (ni.isCellInstance()) {
                    this.writeTextDescriptor(-1, ni.getTextDescriptor(NodeInst.NODE_PROTO));
                }
                this.printWriter.println("userbits: " + ni.getD().getElibBits());
                this.writeVars(ni, cell4);
                Iterator<PortProto> pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = pIt.next();
                    ArrayList<Connection> sortedConnections = new ArrayList<Connection>();
                    ArrayList<Export> sortedExports = new ArrayList<Export>();
                    Iterator<Connection> aIt = ni.getConnections();
                    while (aIt.hasNext()) {
                        Connection con = aIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        sortedConnections.add(con);
                    }
                    Collections.sort(sortedConnections, TextUtils.CONNECTIONS_ORDER);
                    Iterator<Export> eIt = ni.getExports();
                    while (eIt.hasNext()) {
                        Export e = eIt.next();
                        if (e.getOriginalPort().getPortProto() != pp) continue;
                        sortedExports.add(e);
                    }
                    Collections.sort(sortedExports, EXPORTS_ORDER);
                    if (sortedConnections.size() > 0 || sortedExports.size() > 0) {
                        this.printWriter.println("*port: " + pp.getName());
                    }
                    for (Connection con : sortedConnections) {
                        Integer aIndex = this.arcMap.get(con.getArc());
                        if (aIndex == null) {
                            aIndex = new Integer(-1);
                        }
                        this.printWriter.println("arc: " + aIndex);
                    }
                    for (Export e : sortedExports) {
                        Integer pIndex = this.portMap.get(e);
                        if (pIndex == null) {
                            pIndex = new Integer(-1);
                        }
                        this.printWriter.println("exported: " + pIndex);
                    }
                }
            }
            int poc = 0;
            Iterator<Object> it7 = cell4.getPorts();
            while (it7.hasNext()) {
                Export pp = (Export)it7.next();
                this.printWriter.println("**porttype: " + poc);
                ++poc;
                NodeInst subNi = pp.getOriginalPort().getNodeInst();
                Integer subNodeIndex = this.nodeMap.get(subNi);
                PortProto subPp = pp.getOriginalPort().getPortProto();
                this.printWriter.println("subnode: " + subNodeIndex);
                this.printWriter.println("subport: " + subPp.getName());
                this.printWriter.println("name: " + pp.getName());
                this.writeTextDescriptor(-1, pp.getTextDescriptor(Export.EXPORT_NAME));
                this.printWriter.println("userbits: " + pp.getElibBits());
                this.writeVars(pp, cell4);
            }
            it7 = cell4.getArcs();
            while (it7.hasNext()) {
                ArcInst ai = (ArcInst)it7.next();
                Integer arcIndex = this.arcMap.get(ai);
                this.printWriter.println("**arc: " + arcIndex);
                this.printWriter.println("type: " + ai.getProto().getTechnology().getTechName() + ":" + ai.getProto().getName());
                int width = (int)(ai.getWidth() * scale);
                int length = (int)(ai.getLength() * scale);
                this.printWriter.println("width: " + width + " length: " + length);
                int userBits = ai.getD().getElibBits();
                this.printWriter.println("userbits: " + userBits);
                for (int e = 0; e < 2; ++e) {
                    NodeInst conNi = ai.getPortInst(e).getNodeInst();
                    Integer conNodeIndex = this.nodeMap.get(conNi);
                    this.printWriter.println("*end: " + e);
                    this.printWriter.println("node: " + conNodeIndex);
                    this.printWriter.println("nodeport: " + ai.getPortInst(e).getPortProto().getName());
                    int endX = (int)(ai.getLocation(e).getX() * scale);
                    int endY = (int)(ai.getLocation(e).getY() * scale);
                    this.printWriter.println("xpos: " + endX + " ypos: " + endY);
                }
                this.writeVars(ai, cell4);
            }
            this.printWriter.println("celldone: " + cell4.getName());
        }
        if (this.nodeInstError != 0) {
            System.out.println("Warning: " + this.nodeInstError + " node pointers point outside cell: not saved");
        }
        if (this.arcInstError != 0) {
            System.out.println("Warning: " + this.arcInstError + " arc pointers point outside cell: not saved");
        }
        if (this.portProtoError != 0) {
            System.out.println("Warning: " + this.portProtoError + " export pointers point outside cell: not saved");
        }
        if (this.typeError != 0) {
            System.out.println("Warning: " + this.typeError + " objects of unknown type could not be saved");
        }
        return false;
    }

    private void textRecurse(Library lib, Cell cell) {
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).getLibrary() != lib || this.cellOrdering.containsKey(subCell)) continue;
            this.textRecurse(lib, subCell);
        }
        this.cellOrdering.put(cell, null);
    }

    private void writeVars(ElectricObject obj, Cell curCell) {
        String[] fontAssociation;
        PortInst pi;
        Iterator<PortInst> pit;
        NodeInst ni;
        int count = obj.getNumVariables();
        Variable.Key additionalVarKey = null;
        int additionalVarType = 4;
        String[] additionalVarValue = null;
        if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            pit = ni.getPortInsts();
            while (pit.hasNext()) {
                pi = pit.next();
                count += pi.getNumVariables();
            }
            additionalVarKey = NodeInst.NODE_NAME;
            if (ni.isUsernamed()) {
                additionalVarType |= 0x40;
            }
            additionalVarValue = ni.getName();
        } else if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            additionalVarKey = ArcInst.ARC_NAME;
            if (ai.isUsernamed()) {
                additionalVarType |= 0x40;
            }
            additionalVarValue = ai.getName();
        } else if (obj instanceof Library && (fontAssociation = this.createFontAssociation()) != null) {
            additionalVarKey = Library.FONT_ASSOCIATIONS;
            additionalVarType |= 0x80 | fontAssociation.length << 9;
            additionalVarValue = fontAssociation;
        }
        if (additionalVarKey != null) {
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.printWriter.println("variables: " + count + "");
        Iterator<Variable> it = obj.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            this.writeVar(obj, var, curCell);
        }
        if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            pit = ni.getPortInsts();
            while (pit.hasNext()) {
                pi = pit.next();
                if (pi.getNumVariables() == 0) continue;
                Iterator<Variable> it2 = pi.getVariables();
                while (it2.hasNext()) {
                    Variable var = it2.next();
                    this.writeVar(pi, var, curCell);
                }
            }
        }
        if (additionalVarKey != null) {
            this.printName(additionalVarKey.getName());
            TextDescriptor td = (additionalVarType & 0x40) != 0 ? obj.getTextDescriptor(additionalVarKey) : null;
            this.writeTextDescriptor(additionalVarType, td);
            String pt = this.makeString(additionalVarValue, curCell);
            if (pt == null) {
                pt = "";
            }
            this.printWriter.println(pt);
        }
    }

    private void writeVar(ElectricObject owner, Variable var, Cell curCell) {
        String pt;
        int type = var.getTextDescriptor().getCFlags();
        Float[] varObj = var.getObjectInDatabase(EDatabase.serverDatabase());
        if (owner instanceof NodeInst && var.getKey() == NodeInst.TRACE && varObj instanceof EPoint[]) {
            EPoint[] points = (EPoint[])varObj;
            int len = points.length * 2;
            Float[] newPoints = new Float[len];
            for (int j = 0; j < points.length; ++j) {
                newPoints[j * 2] = new Float(points[j].getX());
                newPoints[j * 2 + 1] = new Float(points[j].getY());
            }
            varObj = newPoints;
        }
        if ((pt = this.makeString(varObj, curCell)) == null) {
            pt = "";
        }
        this.printName(var.getKey().getName());
        TextDescriptor td = var.getTextDescriptor();
        if (varObj instanceof Object[]) {
            Object[] objList = varObj;
            int objType = ELIBConstants.getVarType(objList[0]);
            if (objType == 6) {
                objType = 5;
            }
            int len = objList.length;
            type |= objType | 0x80 | len << 9;
        } else {
            int objType = ELIBConstants.getVarType(varObj);
            if (objType == 6) {
                objType = 5;
            }
            type |= objType;
        }
        this.writeTextDescriptor(type, td);
        this.printWriter.println(pt);
    }

    private void writeMeaningPrefs(Object obj) {
        List<Pref> prefs = Pref.getMeaningVariables(obj);
        if (prefs.size() == 0) {
            return;
        }
        this.printWriter.println("variables: " + prefs.size());
        for (Pref pref : prefs) {
            String pt;
            Object varObj = pref.getValue();
            int objType = ELIBConstants.getVarType(varObj);
            if (objType == 6) {
                objType = 5;
            }
            if ((pt = this.makeString(varObj, null)) == null) {
                pt = "";
            }
            this.printWriter.println(pref.getPrefName() + "[0" + Integer.toOctalString(objType) + ",0/0]: " + pt);
        }
    }

    private String makeString(Object obj, Cell curCell) {
        StringBuffer infstr = new StringBuffer();
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i == 0) {
                    infstr.append("[");
                } else {
                    infstr.append(",");
                }
                this.makeStringVar(infstr, oneObj, curCell);
            }
            infstr.append("]");
        } else {
            this.makeStringVar(infstr, obj, curCell);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, Object obj, Cell curCell) {
        if (obj instanceof Integer) {
            infstr.append((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            infstr.append(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Byte) {
            infstr.append(((Byte)obj).byteValue());
            return;
        }
        if (obj instanceof String) {
            infstr.append("\"");
            infstr.append(this.convertString((String)obj));
            infstr.append("\"");
            return;
        }
        if (obj instanceof Float) {
            infstr.append(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            infstr.append((Double)obj);
            return;
        }
        if (obj instanceof Boolean) {
            infstr.append((Boolean)obj != false ? 1 : 0);
            return;
        }
        if (obj instanceof Long) {
            infstr.append((Long)obj);
            return;
        }
        if (obj instanceof Technology) {
            Technology tech = (Technology)obj;
            infstr.append(tech.getTechName());
            return;
        }
        if (obj instanceof Library) {
            Library lib = (Library)obj;
            infstr.append("\"" + lib.getName() + "\"");
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            infstr.append(tool.getName());
            return;
        }
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            Integer nodeIndex = this.nodeMap.get(ni);
            int cIndex = -1;
            if (nodeIndex == null) {
                ++this.nodeInstError;
            } else {
                cIndex = nodeIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            Integer arcIndex = this.arcMap.get(ai);
            int cIndex = -1;
            if (arcIndex == null) {
                ++this.arcInstError;
            } else {
                cIndex = arcIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            Integer mi = this.cellOrdering.get(cell);
            int cIndex = -1;
            if (mi != null) {
                cIndex = mi;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof PrimitiveNode) {
            PrimitiveNode np = (PrimitiveNode)obj;
            infstr.append(np.getTechnology().getTechName() + ":" + np.getName());
            return;
        }
        if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            infstr.append(ap.getTechnology().getTechName() + ":" + ap.getName());
            return;
        }
        if (obj instanceof Export) {
            Export pp = (Export)obj;
            Integer portIndex = this.portMap.get(pp);
            int cIndex = -1;
            if (portIndex == null) {
                ++this.portProtoError;
            } else {
                cIndex = portIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        ++this.typeError;
    }

    private void writeTextDescriptor(int varBits, TextDescriptor td) {
        int td1;
        int td0;
        if (td != null) {
            td0 = td.lowLevelGet0();
            td1 = td.lowLevelGet1();
            if ((td1 & 0x3F8000) != 0) {
                int face = (td1 & 0x3F8000) >> 15;
                td1 = td1 & 0xFFC07FFF | this.faceMap[face] << 15;
            }
        } else {
            td0 = 0;
            td1 = 0;
        }
        if (varBits == -1) {
            this.printWriter.println("descript: " + td0 + "/" + td1);
            return;
        }
        if ((varBits & 0x80) != 0) {
            this.printWriter.print("(" + ((varBits & 0x1FFFFE00) >> 9) + ")");
        }
        this.printWriter.print("[0" + Integer.toOctalString(varBits) + ",0" + Integer.toOctalString(td0) + "/0" + Integer.toOctalString(td1) + "]: ");
    }

    private String convertString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '[' || ch == ']' || ch == '\"' || ch == '^') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private void printName(String name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char pt = name.charAt(i);
            if (pt == '^' || pt == '[' || pt == '(' || pt == ':') {
                this.printWriter.print("^");
            }
            this.printWriter.print(pt);
        }
    }
}

