/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NccResults
implements Iterable<NccResult>,
Serializable {
    static final long serialVersionUID = 0L;
    private List<NccResult> results = new ArrayList<NccResult>();
    private boolean exportMatch = true;
    private boolean topologyMatch = true;
    private boolean sizeMatch = true;
    private boolean fatalError;

    public void add(NccResult r) {
        if (r.userAbort()) {
            return;
        }
        LayoutLib.error(r == null, "Null NccResult shouldn't be possible?");
        this.results.add(r);
        this.exportMatch &= r.exportMatch();
        this.topologyMatch &= r.topologyMatch();
        this.sizeMatch &= r.sizeMatch();
        NccGuiInfo cr = r.getNccGuiInfo();
        cr.setNccResult(r);
    }

    public void abandonPriorResults() {
    }

    public List<NccGuiInfo> getAllComparisonMismatches() {
        ArrayList<NccGuiInfo> mismatches = new ArrayList<NccGuiInfo>();
        for (NccResult r : this.results) {
            if (!r.guiNeedsToReport()) continue;
            mismatches.add(r.getNccGuiInfo());
        }
        return mismatches;
    }

    public boolean exportMatch() {
        return this.exportMatch;
    }

    public boolean topologyMatch() {
        return this.topologyMatch;
    }

    public boolean match() {
        return this.exportMatch && this.topologyMatch && this.sizeMatch && !this.fatalError;
    }

    @Override
    public Iterator<NccResult> iterator() {
        return this.results.iterator();
    }

    public NccResult getResultFromRootCells() {
        int sz = this.results.size();
        LayoutLib.error(sz == 0, "No results in NccResults");
        return this.results.get(sz - 1);
    }

    public String summary(boolean checkSizes) {
        String s = this.exportMatch ? "exports match, " : "exports mismatch, ";
        s = this.topologyMatch ? s + "topologies match, " : s + "topologies mismatch, ";
        s = !checkSizes ? s + "sizes not checked" : (this.sizeMatch ? s + "sizes match" : s + "sizes mismatch");
        return s;
    }
}

