/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.netlist.ExportGlobalConflict;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.UserAbort;
import com.sun.electric.tool.ncc.netlist.Visitor;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;

public class NccNetlist {
    private final NccGlobals globals;
    private final Cell rootCell;
    private final VarContext rootContext;
    private ArrayList<Wire> wires;
    private ArrayList<Part> parts;
    private ArrayList<Port> ports;
    private boolean exportAssertionFailures;
    private boolean exportGlobalConflicts;
    private boolean badTransistorType;
    private boolean userAbort;

    public NccNetlist(Cell root, VarContext context, HierarchyInfo hierInfo, boolean blackBox, NccGlobals globals) {
        this.globals = globals;
        this.rootCell = root;
        this.rootContext = context;
        try {
            Visitor v = new Visitor(globals, hierInfo, blackBox, context);
            HierarchyEnumerator.enumerateCell(root, context, v, true, false, true, true);
            this.wires = v.getWireList();
            this.parts = v.getPartList();
            this.ports = v.getPortList();
            this.exportAssertionFailures = v.exportAssertionFailures();
            this.badTransistorType = v.badTransistorType();
        }
        catch (RuntimeException e) {
            if (e instanceof ExportGlobalConflict) {
                this.exportGlobalConflicts = true;
            }
            if (e instanceof UserAbort) {
                this.userAbort = true;
            }
            throw e;
        }
        if (this.cantBuildNetlist()) {
            this.wires = new ArrayList();
            this.parts = new ArrayList();
            this.ports = new ArrayList();
        }
    }

    public ArrayList<Wire> getWireArray() {
        return this.wires;
    }

    public ArrayList<Part> getPartArray() {
        return this.parts;
    }

    public ArrayList<Port> getPortArray() {
        return this.ports;
    }

    public boolean cantBuildNetlist() {
        return this.exportAssertionFailures || this.exportGlobalConflicts || this.badTransistorType;
    }

    public boolean userAbort() {
        return this.userAbort;
    }

    public Cell getRootCell() {
        return this.rootCell;
    }

    public VarContext getRootContext() {
        return this.rootContext;
    }
}

