/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.extract.GeometrySearch;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.CellLists;
import com.sun.electric.tool.user.dialogs.CellProperties;
import com.sun.electric.tool.user.dialogs.CrossLibCopy;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class CellMenu {
    static EMenu makeMenu() {
        return new EMenu("_Cell", new EMenuItem("Ne_w Cell...", 'N'){

            @Override
            public void run() {
                CellMenu.newCellCommand();
            }
        }, new EMenuItem("_Edit Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.editCell);
            }
        }, new EMenuItem("_Place Cell Instance...", KeyStroke.getKeyStroke(78, 0)){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
            }
        }, new EMenuItem("_Rename Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.renameCell);
            }
        }, new EMenuItem("Duplic_ate Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.duplicateCell);
            }
        }, new EMenuItem("De_lete Cell..."){

            @Override
            public void run() {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.deleteCell);
            }
        }, new EMenu("_Multi-Page Cells", new EMenuItem("_Make Cell Multi-Page"){

            @Override
            public void run() {
                CellMenu.makeMultiPageCell();
            }
        }, new EMenuItem("_Create New Page"){

            @Override
            public void run() {
                CellMenu.createNewMultiPage();
            }
        }, new EMenuItem("_Delete This Page"){

            @Override
            public void run() {
                CellMenu.deleteThisMultiPage();
            }
        }, new EMenuItem("_Edit Next Page"){

            @Override
            public void run() {
                CellMenu.editNextMultiPage();
            }
        }, new EMenuItem("Con_vert old-style Multi-Page Schematics"){

            @Override
            public void run() {
                ViewChanges.convertMultiPageViews();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("_Cross-Library Copy..."){

            @Override
            public void run() {
                CellMenu.crossLibraryCopyCommand();
            }
        }, new EMenu("Merge Li_braries", new EMenuItem("_Add Exports from Library..."){

            @Override
            public void run() {
                ExportChanges.synchronizeLibrary();
            }
        }, new EMenuItem("_Replace Cells from Library..."){

            @Override
            public void run() {
                ExportChanges.replaceFromOtherLibrary();
            }
        }), EMenuItem.SEPARATOR, new EMenu("_Down Hierarchy", new EMenuItem("_Down Hierarchy", 'D'){

            @Override
            public void run() {
                CellMenu.downHierCommand(false, false);
            }
        }, new EMenuItem("Down Hierarchy, Keep _Focus"){

            @Override
            public void run() {
                CellMenu.downHierCommand(true, false);
            }
        }, new EMenuItem("Down Hierarchy, New _Window"){

            @Override
            public void run() {
                CellMenu.downHierCommand(false, true);
            }
        }, new EMenuItem("Down Hierarchy, _Keep Focus, New Window"){

            @Override
            public void run() {
                CellMenu.downHierCommand(true, true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Down Hierarchy In _Place", KeyStroke.getKeyStroke(68, 0)){

            @Override
            public void run() {
                CellMenu.downHierInPlaceCommand();
            }
        }, new EMenuItem("Down Hierarchy In Place To Object", KeyStroke.getKeyStroke(68, 1)){

            @Override
            public void run() {
                CellMenu.downHierInPlaceToObject();
            }
        }), new EMenuItem("_Up Hierarchy", 'U'){

            @Override
            public void run() {
                CellMenu.upHierCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("New _Version of Current Cell"){

            @Override
            public void run() {
                CellMenu.newCellVersionCommand();
            }
        }, new EMenuItem("Duplicate Curre_nt Cell"){

            @Override
            public void run() {
                CellMenu.duplicateCellCommand();
            }
        }, new EMenuItem("Delete Unused _Old Versions"){

            @Override
            public void run() {
                CellMenu.deleteOldCellVersionsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("Cell In_fo", new EMenuItem("_Describe this Cell"){

            @Override
            public void run() {
                CellLists.describeThisCellCommand();
            }
        }, new EMenuItem("_General Cell Lists..."){

            @Override
            public void run() {
                CellLists.generalCellListsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("List _Nodes in this Cell"){

            @Override
            public void run() {
                CellLists.listNodesInCellCommand();
            }
        }, new EMenuItem("List Cell _Instances"){

            @Override
            public void run() {
                CellLists.listCellInstancesCommand();
            }
        }, new EMenuItem("List Cell _Usage"){

            @Override
            public void run() {
                CellLists.listCellUsageCommand();
            }
        }, new EMenuItem("Number of _Transistors"){

            @Override
            public void run() {
                CellLists.numberOfTransistorsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Graphically, _Entire Library"){

            @Override
            public void run() {
                CircuitChanges.graphCellsInLibrary();
            }
        }, new EMenuItem("Graphically, _From Current Cell"){

            @Override
            public void run() {
                CircuitChanges.graphCellsFromCell();
            }
        }), new EMenuItem("Cell Propertie_s..."){

            @Override
            public void run() {
                CellMenu.cellControlCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("E_xpand Cell Instances", ToolBar.expandOneLevelCommand, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(false, Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(false, -1);
            }
        }), new EMenu("Unexpand Cell Ins_tances", ToolBar.unexpandOneLevelCommand, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(true, Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.DoExpandCommands(true, -1);
            }
        }), new EMenuItem("Loo_k Inside Highlighted", 'P'){

            @Override
            public void run() {
                CellMenu.peekCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Packa_ge Into Cell..."){

            @Override
            public void run() {
                CircuitChanges.packageIntoCell();
            }
        }, new EMenu("Extract Cell _Instance", new EMenuItem("_One Level Down"){

            @Override
            public void run() {
                CircuitChanges.extractCells(1);
            }
        }, new EMenuItem("_All the Way"){

            @Override
            public void run() {
                CircuitChanges.extractCells(Integer.MAX_VALUE);
            }
        }, new EMenuItem("_Specified Amount..."){

            @Override
            public void run() {
                CircuitChanges.extractCells(-1);
            }
        }));
    }

    private static void cellControlCommand() {
        CellProperties dialog = new CellProperties((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void newCellCommand() {
        NewCell dialog = new NewCell((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void cellBrowserCommand(CellBrowser.DoAction action) {
        CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), false, action);
        dialog.setVisible(true);
    }

    private static void makeMultiPageCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.SCHEMATIC) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Only Schematic cells can be made multi-page", "Cannot make multipage design", 0);
            return;
        }
        new SetMultiPageJob(cell, 1);
    }

    private static void createNewMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int numPages = cell.getNumMultiPages();
        new SetMultiPageJob(cell, numPages + 1);
        wnd.setMultiPageNumber(numPages);
    }

    private static void deleteThisMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("This is not a multi-page schematic.  To delete this cell, use 'Cell / Delete Cell'");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        new DeleteMultiPageJob(cell, curPage);
        int numPages = cell.getNumMultiPages();
        if (curPage >= numPages) {
            wnd.setMultiPageNumber(numPages - 1);
        }
    }

    private static void editNextMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        int numPages = cell.getNumMultiPages();
        wnd.setMultiPageNumber((curPage + 1) % numPages);
    }

    private static void crossLibraryCopyCommand() {
        CrossLibCopy dialog = new CrossLibCopy((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void downHierCommand(boolean keepFocus, boolean newWindow) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(keepFocus, newWindow, false);
    }

    private static void downHierInPlaceCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(false, false, true);
    }

    private static void downHierInPlaceToObject() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        Cell cell = curEdit.getCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.LAYOUT) {
            System.out.println("Current cell should be layout cell for down hier in place to object");
            return;
        }
        Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
        Point2D mouseDB = curEdit.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
        EPoint point = new EPoint(mouseDB.getX(), mouseDB.getY());
        GeometrySearch search = new GeometrySearch();
        long start = System.currentTimeMillis();
        if (search.searchGeometries(cell, point, true)) {
            VarContext context = search.getContext();
            if (context == VarContext.globalContext) {
                System.out.println(search.describeFoundGeometry() + ", not descending down hierarchy");
                return;
            }
            Geometric geom = search.getGeometricFound();
            System.out.println("Descending to " + geom + " at point (" + point.getX() + "," + point.getY() + ") in cell " + geom.getParent().getName());
            Iterator<Nodable> it = context.getPathIterator();
            while (it.hasNext()) {
                Nodable no = it.next();
                Cell curCell = no.getParent();
                curEdit.getHighlighter().clear();
                curEdit.getHighlighter().addElectricObject(no.getNodeInst(), curCell);
                curEdit.getHighlighter().finished();
                System.out.println("  descended into " + no.getName() + "[" + no.getProto().getName() + "] in cell " + curCell.getName());
                curEdit.downHierarchy(false, false, true);
            }
            curEdit.getHighlighter().clear();
            curEdit.getHighlighter().addElectricObject(geom, geom.getParent());
            curEdit.getHighlighter().finished();
        } else {
            System.out.println("No primitive node or arc found under mouse to descend to.");
        }
        System.out.println("Search took " + TextUtils.getElapsedTime(System.currentTimeMillis() - start));
    }

    private static void upHierCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.upHierarchy();
    }

    private static void newCellVersionCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        CircuitChanges.newVersionOfCell(curCell);
    }

    private static void duplicateCellCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        CellMenu.duplicateCell(curCell, false);
    }

    public static void duplicateCell(Cell cell, boolean allInGroup) {
        int response;
        String newName;
        String prompt = "Name of duplicated cell";
        if (allInGroup) {
            prompt = prompt + " group";
        }
        if ((newName = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), prompt, cell.getName() + "NEW")) == null) {
            return;
        }
        Cell already = cell.getLibrary().findNodeProto(newName);
        if (already != null && already.getView() == cell.getView() && (response = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cell " + newName + " already exists.  Make this a new version?", "Confirm duplication", -1, 2, null, new String[]{"Yes", "Cancel"}, "Yes")) != 0) {
            return;
        }
        new CellChangeJobs.DuplicateCell(cell, newName, allInGroup);
    }

    private static void deleteOldCellVersionsCommand() {
        int oldUnusedCurrent = 0;
        int oldUnusedElsewhere = 0;
        for (Library lib : Library.getVisibleLibraries()) {
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                if (lib == Library.getCurrent()) {
                    ++oldUnusedCurrent;
                    continue;
                }
                ++oldUnusedElsewhere;
            }
        }
        if (oldUnusedCurrent + oldUnusedElsewhere != 0 && oldUnusedElsewhere != 0) {
            String[] options = new String[]{"Current library", "Other libraries", "All libraries", "Cancel"};
            int ret = Job.getUserInterface().askForChoice("There are " + oldUnusedCurrent + " old unused cells in the current library and " + oldUnusedElsewhere + " in other libraries.  Which libraries should have their old unused cells deleted?", "Which Old Unused Cells to Delete", options, "No");
            if (ret == 0) {
                oldUnusedElsewhere = 0;
            }
            if (ret == 1) {
                oldUnusedCurrent = 0;
            }
            if (ret == 3) {
                return;
            }
        }
        if (oldUnusedCurrent == 0 && oldUnusedElsewhere == 0) {
            System.out.println("There are no old unused cells to delete");
            return;
        }
        ArrayList<Cell> cellsToDelete = new ArrayList<Cell>();
        for (Library lib : Library.getVisibleLibraries()) {
            if (lib == Library.getCurrent() ? oldUnusedCurrent == 0 : oldUnusedElsewhere == 0) continue;
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                CircuitChanges.cleanCellRef(cell);
                cellsToDelete.add(cell);
            }
        }
        new CellChangeJobs.DeleteManyCells(cellsToDelete);
    }

    private static void peekCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must define an area in which to display");
            return;
        }
        wnd.repaintContents(bounds, true);
    }

    public static class DeleteMultiPageJob
    extends Job {
        private Cell cell;
        private int page;
        private int numPages;

        public DeleteMultiPageJob(Cell cell, int page) {
            super("Delete Page from Multi-Page Schematic", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.page = page;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            double lY = (double)this.page * 1000.0 - 500.0;
            double hY = lY + 1000.0;
            ArrayList<Geometric> deleteList = new ArrayList<Geometric>();
            Iterator<Geometric> it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!(ni.getAnchorCenterY() > lY) || !(ni.getAnchorCenterY() < hY)) continue;
                deleteList.add(ni);
            }
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                double ctrY = ai.getBounds().getCenterY();
                if (!(ctrY > lY) || !(ctrY < hY)) continue;
                deleteList.add(ai);
            }
            CircuitChangeJobs.eraseObjectsInList(this.cell, deleteList, false);
            this.numPages = this.cell.getNumMultiPages();
            if (this.page + 1 < this.numPages) {
                CircuitChangeJobs.spreadCircuitry(this.cell, null, 'u', -1000.0, 0.0, 0.0, lY, hY);
            }
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)(this.numPages - 1));
            this.fieldVariableChanged("numPages");
            return true;
        }

        @Override
        public void terminateOK() {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                int wndPage;
                EditWindow wnd;
                WindowFrame wf = it.next();
                if (!(wf.getContent() instanceof EditWindow) || (wnd = (EditWindow)wf.getContent()).getCell() != this.cell || (wndPage = wnd.getMultiPageNumber()) + 1 < this.numPages) continue;
                wnd.setMultiPageNumber(wndPage - 1);
            }
        }
    }

    public static class SetMultiPageJob
    extends Job {
        private Cell cell;
        private int numPages;

        public SetMultiPageJob(Cell cell, int numPages) {
            super("Make Cell be Multi-Page", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.numPages = numPages;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Dimension d = new Dimension(0, 0);
            if (Cell.FrameDescription.getCellFrameInfo(this.cell, d) != 0) {
                this.cell.newVar(User.FRAME_SIZE, (Object)"a");
                System.out.println("Multi-page schematics must have cell frames turned on.  Setting this to A-size.");
            }
            boolean wasMulti = this.cell.isMultiPage();
            this.cell.setMultiPage(true);
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)this.numPages);
            if (!wasMulti) {
                System.out.println("Cell " + this.cell.describe(true) + " is now a multi-page schematic");
            }
            return true;
        }
    }
}

