/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import java.util.Iterator;

public class TransistorSearch {
    public static void countNumberOfTransistors(Cell cell) {
        if (!cell.isSchematic()) {
            System.out.println("Counting number of transistors only valid for Schematics cells");
            return;
        }
        new TransistorSearchJob(cell);
    }

    private static class TransistorSearchEnumerator
    extends HierarchyEnumerator.Visitor {
        private int transistorTotalNumber;
        private int transistorRealNumber;

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (ni.isCellInstance()) {
                return true;
            }
            if (ni.getProto().getFunction().isTransistor()) {
                Netlist netlist = info.getNetlist();
                HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo() != null ? info.getParentInfo() : info;
                Global.Set globals = parentInfo.getNetlist().getGlobals();
                boolean found = false;
                int netID = -1;
                Iterator<PortInst> itPi = ni.getPortInsts();
                while (itPi.hasNext()) {
                    PortInst pi = itPi.next();
                    if (pi.getPortProto().getCharacteristic() != PortCharacteristic.BIDIR) continue;
                    Network net = netlist.getNetwork(pi);
                    int key = info.getNetID(net);
                    if (netID == -1) {
                        netID = key;
                        continue;
                    }
                    if (key != netID) continue;
                    for (int j = 0; j < globals.size(); ++j) {
                        Global g = globals.get(j);
                        Network gnet = parentInfo.getNetlist().getNetwork(g);
                        int gnetID = parentInfo.getNetID(gnet);
                        if (gnetID != netID) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                ++this.transistorTotalNumber;
                if (!found) {
                    ++this.transistorRealNumber;
                }
            }
            return true;
        }
    }

    private static class TransistorSearchJob
    extends Job {
        private Cell cell;

        public TransistorSearchJob(Cell cell) {
            super("Searching Transistors in " + cell.getName(), null, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            TransistorSearchEnumerator visitor = new TransistorSearchEnumerator();
            HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
            System.out.println("Number of transistors found from cell " + this.cell.getName() + ": " + visitor.transistorTotalNumber);
            System.out.println("Number of non-cap transistors found from cell " + this.cell.getName() + ": " + visitor.transistorRealNumber);
            System.out.println("(took " + TextUtils.getElapsedTime(System.currentTimeMillis() - startTime) + ")");
            return true;
        }
    }
}

