/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;

public class BenchmarkResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long[] results = new long[BenchIdx.NUMBER_OF_VALUES.ordinal()];
    public HashMap<String, CellInfo> info = new HashMap();

    public void computeFinalStatistics() {
        long maxMatrix = 0L;
        long maxPort = 0L;
        long sum = 0L;
        long count = 0L;
        for (CellInfo ci : this.info.values()) {
            int numPorts = 0;
            int[] matrixSizes = ci.matrixSizes;
            for (int i = 0; i < matrixSizes.length; ++i) {
                if ((long)matrixSizes[i] > maxMatrix) {
                    maxMatrix = matrixSizes[i];
                }
                numPorts += matrixSizes[i];
                ++count;
            }
            if ((long)numPorts > maxPort) {
                maxPort = numPorts;
            }
            sum += (long)numPorts;
        }
        this.results[BenchIdx.MAX_MATRIX_SIZE.ordinal()] = maxMatrix;
        this.results[BenchIdx.MAX_PORT_SIZE.ordinal()] = maxPort;
        this.results[BenchIdx.SUM_OF_MATRIX_SIZES.ordinal()] = sum;
        this.results[BenchIdx.NUMBER_OF_MATRICES.ordinal()] = count;
    }

    public BenchmarkResults() {
    }

    public BenchmarkResults(BenchmarkResults other) {
        this.results = (long[])other.results.clone();
    }

    public void clearResults() {
        Arrays.fill(this.results, 0L);
        this.info = new HashMap();
    }

    public void accumulateResults(BenchmarkResults other) {
        for (int i = 0; i < BenchIdx.NUMBER_OF_VALUES.ordinal(); ++i) {
            int n = i;
            this.results[n] = this.results[n] + other.results[i];
        }
        for (String key : other.info.keySet()) {
            this.info.put(key, other.getInfo(key));
        }
    }

    public void normalizeResults(long div) {
        int i = 0;
        while (i < BenchIdx.NUMBER_OF_VALUES.ordinal()) {
            int n = i++;
            this.results[n] = this.results[n] / div;
        }
    }

    public long get(BenchIdx idx) {
        return idx == BenchIdx.NUMBER_OF_VALUES ? this.results[idx.ordinal()] : 0L;
    }

    public void addInfo(String name, CellInfo newInfo) {
        this.info.put(name, newInfo);
    }

    public CellInfo getInfo(String name) {
        return this.info.get(name);
    }

    public long get(int idx) {
        return idx < BenchIdx.NUMBER_OF_VALUES.ordinal() ? this.results[idx] : -1L;
    }

    public static void main(String[] args) {
    }

    public static class CellInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public int[] matrixSizes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BenchIdx {
        MERGE_TIME,
        LOCAL_PARTITIONING_TIME,
        HASH_CODE_PASS1_TIME,
        HASH_CODE_PASS2_TIME,
        EXPORT_MATCHING_TIME,
        SIZE_MATCHING_TIME,
        SIZE_CHECKING_TIME,
        FORCED_PARTITION_TIME,
        EXPORT_CHECKING_TIME,
        RANDOM_MATCHING_TIME,
        FINAL_SWAP_TIME,
        ABSTRACTION_CONSTRUCTION_TIME,
        BACKTRACK_SPACE,
        BACKTRACK_GUESSES,
        SUB_NCC_TIME,
        SUB_NCC_COUNT,
        SCHREIER_SIMS_TIME,
        SCHREIER_SIMS_COUNT,
        QUICK_INTERCHANGE_TIME,
        QUICK_INTERCHANGE_COUNT,
        NEWBORNS_PROCESSED,
        MAX_MATRIX_SIZE,
        MAX_PORT_SIZE,
        SUM_OF_MATRIX_SIZES,
        NUMBER_OF_MATRICES,
        PASS_RESULT,
        FAIL_RESULT,
        MAYBE_RESULT,
        NUMBER_OF_VALUES;

    }
}

