/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Foundry;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.dialogs.DesignRulesPanel;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DesignRulesTab
extends PreferencePanel {
    DesignRulesPanel rulesPanel;
    private DRCRules drRules;
    private boolean designRulesFactoryReset = false;
    private JPanel designRules;
    private JLabel drResolutionLabel;
    private JTextField drResolutionValue;
    private JLabel drTechName;
    private JButton factoryReset;
    private JLabel jLabel6;

    public DesignRulesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.rulesPanel = new DesignRulesPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.designRules.add((Component)this.rulesPanel, gridBagConstraints);
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DesignRulesTab.this.factoryResetDRCActionPerformed(evt);
            }
        });
    }

    public JPanel getPanel() {
        return this.designRules;
    }

    public String getName() {
        return "Design Rules";
    }

    public void init() {
        DRCRules rules = DRC.getRules(this.curTech);
        if (rules == null) {
            this.drTechName.setText("Technology " + this.curTech.getTechName() + " HAS NO DESIGN RULES");
            this.factoryReset.setEnabled(false);
            return;
        }
        this.drRules = rules;
        Foundry.Type foundry = this.curTech.getSelectedFoundry().getType();
        this.rulesPanel.init(this.curTech, foundry, this.drRules);
        String text = "Design Rules for Technology '" + this.curTech.getTechName() + "'";
        if (foundry != Foundry.Type.NONE) {
            text = text + " with foundry " + foundry.name();
        }
        this.drTechName.setText(text);
        this.drResolutionValue.setText(TextUtils.formatDouble(this.curTech.getResolution()));
    }

    private void factoryResetDRCActionPerformed(ActionEvent evt) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to do a factory reset of these design rules?");
        if (response != 0) {
            return;
        }
        this.designRulesFactoryReset = true;
    }

    public void term() {
        double currentResolution = TextUtils.atof(this.drResolutionValue.getText());
        if (currentResolution != this.curTech.getResolution()) {
            this.curTech.setResolution(currentResolution);
        }
        if (this.designRulesFactoryReset) {
            DRC.resetDRCDates(true);
            this.drRules = this.curTech.getFactoryDesignRules();
        }
        DRC.setRules(this.curTech, this.drRules);
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd != null) {
            wnd.fullRepaint();
        }
    }

    private void initComponents() {
        this.designRules = new JPanel();
        this.drResolutionLabel = new JLabel();
        this.drResolutionValue = new JTextField();
        this.jLabel6 = new JLabel();
        this.factoryReset = new JButton();
        this.drTechName = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DesignRulesTab.this.closeDialog(evt);
            }
        });
        this.designRules.setLayout(new GridBagLayout());
        this.designRules.setBorder(BorderFactory.createTitledBorder(""));
        this.drResolutionLabel.setText("Min. resolution:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.drResolutionLabel, gridBagConstraints);
        this.drResolutionValue.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.drResolutionValue, gridBagConstraints);
        this.jLabel6.setText("(use 0 to ignore resolution check)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.jLabel6, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.designRules.add((Component)this.factoryReset, gridBagConstraints);
        this.drTechName.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.designRules.add((Component)this.drTechName, gridBagConstraints);
        this.getContentPane().add((Component)this.designRules, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

