/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.LayerDrawing;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.redisplay.VectorDrawing;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class AbstractDrawing {
    public final EditWindow wnd;
    public WindowFrame.DisplayAttributes da;

    protected AbstractDrawing(EditWindow wnd) {
        this.wnd = wnd;
    }

    public static AbstractDrawing createDrawing(EditWindow wnd, AbstractDrawing drawing, Cell cell) {
        boolean isLayerDrawing;
        boolean bl = isLayerDrawing = User.getDisplayAlgorithm() == 2 && cell != null && cell.getTechnology().isLayout();
        if (isLayerDrawing && !(drawing instanceof LayerDrawing.Drawing)) {
            drawing = new LayerDrawing.Drawing(wnd);
        } else if (!isLayerDrawing && !(drawing instanceof PixelDrawing.Drawing)) {
            drawing = new PixelDrawing.Drawing(wnd);
        }
        return drawing;
    }

    public abstract boolean paintComponent(Graphics2D var1, Dimension var2);

    public abstract void render(Dimension var1, WindowFrame.DisplayAttributes var2, boolean var3, Rectangle2D var4);

    public void abortRendering() {
    }

    public void opacityChanged() {
    }

    public boolean hasOpacity() {
        return false;
    }

    public void testJogl() {
    }

    public static void clearSubCellCache() {
        PixelDrawing.clearSubCellCache();
        LayerDrawing.clearSubCellCache();
    }

    public static void forceRedraw(Cell cell) {
        PixelDrawing.forceRedraw(cell);
        LayerDrawing.forceRedraw(cell);
    }

    public static void drawShapes(Graphics2D g, int imgX, int imgY, double scale, VectorCache.VectorBase[] shapes, PixelDrawing offscreen, Rectangle entryRect) {
        if (User.getDisplayAlgorithm() < 2 || User.isLegacyComposite()) {
            offscreen.initDrawing(scale);
            VectorDrawing vd = new VectorDrawing();
            vd.render(offscreen, scale, EPoint.ORIGIN, shapes, true);
            Image img = offscreen.composite(null);
            g.drawImage(img, imgX, imgY, null);
        } else {
            LayerDrawing.drawTechPalette(g, imgX, imgY, entryRect, scale, shapes);
        }
    }

    public static class LayerColor {
        public final Layer layer;
        public final float premultipliedRed;
        public final float premultipliedGreen;
        public final float premultipliedBlue;
        public final float inverseAlpha;

        public LayerColor(Layer layer, float premultipliedRed, float premultipliedGreen, float premultipliedBlue, float inverseAlpha) {
            this.layer = layer;
            this.premultipliedRed = premultipliedRed;
            this.premultipliedGreen = premultipliedGreen;
            this.premultipliedBlue = premultipliedBlue;
            this.inverseAlpha = inverseAlpha;
        }
    }
}

