/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GDS
extends TechEditWizardPanel {
    private JPanel gds;
    private JLabel[] metalGDSLabel;
    private JLabel[] viaGDSLabel;
    private JTextField[] metalGDS;
    private JTextField[] viaGDS;
    private JTextField diffGDS;
    private JTextField polyGDS;
    private JTextField nPlusGDS;
    private JTextField pPlusGDS;
    private JTextField nWellGDS;
    private JTextField contactGDS;
    private JTextField markingGDS;

    public GDS(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.setTitle("GDS");
        this.setName("");
        this.gds = new JPanel();
        this.gds.setLayout(new GridBagLayout());
        JLabel heading = new JLabel("GDS Layer Numbers");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.gds.add((Component)heading, gbc);
        JLabel lab1 = new JLabel("Active GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab1, gbc);
        this.diffGDS = new JTextField();
        this.diffGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.diffGDS, gbc);
        JLabel lab2 = new JLabel("Poly GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab2, gbc);
        this.polyGDS = new JTextField();
        this.polyGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.polyGDS, gbc);
        JLabel lab3 = new JLabel("NPlus GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab3, gbc);
        this.nPlusGDS = new JTextField();
        this.nPlusGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.nPlusGDS, gbc);
        JLabel lab4 = new JLabel("PPlus GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab4, gbc);
        this.pPlusGDS = new JTextField();
        this.pPlusGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.pPlusGDS, gbc);
        JLabel lab5 = new JLabel("NWell GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab5, gbc);
        this.nWellGDS = new JTextField();
        this.nWellGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.nWellGDS, gbc);
        JLabel lab6 = new JLabel("Contact GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab6, gbc);
        this.contactGDS = new JTextField();
        this.contactGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.contactGDS, gbc);
        JLabel lab7 = new JLabel("Marking GDS layer:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.gds.add((Component)lab7, gbc);
        this.markingGDS = new JTextField();
        this.markingGDS.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.gds.add((Component)this.markingGDS, gbc);
    }

    public JPanel getPanel() {
        return this.gds;
    }

    public String getName() {
        return "GDS";
    }

    public void init() {
        int i;
        TechEditWizardData data = this.wizard.getTechEditData();
        this.diffGDS.setText(Integer.toString(data.getGDSDiff()));
        this.polyGDS.setText(Integer.toString(data.getGDSPoly()));
        this.nPlusGDS.setText(Integer.toString(data.getGDSNPlus()));
        this.pPlusGDS.setText(Integer.toString(data.getGDSPPlus()));
        this.nWellGDS.setText(Integer.toString(data.getGDSNWell()));
        this.contactGDS.setText(Integer.toString(data.getGDSContact()));
        this.markingGDS.setText(Integer.toString(data.getGDSMarking()));
        if (this.metalGDSLabel != null) {
            for (i = 0; i < this.metalGDSLabel.length; ++i) {
                this.gds.remove(this.metalGDSLabel[i]);
            }
        }
        if (this.metalGDS != null) {
            for (i = 0; i < this.metalGDS.length; ++i) {
                this.gds.remove(this.metalGDS[i]);
            }
        }
        if (this.viaGDSLabel != null) {
            for (i = 0; i < this.viaGDSLabel.length; ++i) {
                this.gds.remove(this.viaGDSLabel[i]);
            }
        }
        if (this.viaGDS != null) {
            for (i = 0; i < this.viaGDS.length; ++i) {
                this.gds.remove(this.viaGDS[i]);
            }
        }
        int numMetals = data.getNumMetalLayers();
        this.metalGDSLabel = new JLabel[numMetals];
        this.metalGDS = new JTextField[numMetals];
        this.viaGDSLabel = new JLabel[numMetals - 1];
        this.viaGDS = new JTextField[numMetals - 1];
        for (int i2 = 0; i2 < numMetals; ++i2) {
            this.metalGDSLabel[i2] = new JLabel("Metal-" + (i2 + 1) + " GDS layer:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 8 + i2 * 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 1, 0);
            this.gds.add((Component)this.metalGDSLabel[i2], gbc);
            this.metalGDS[i2] = new JTextField();
            this.metalGDS[i2].setText(Integer.toString(data.getGDSMetal()[i2]));
            this.metalGDS[i2].setColumns(8);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 8 + i2 * 2;
            gbc.insets = new Insets(4, 0, 1, 2);
            this.gds.add((Component)this.metalGDS[i2], gbc);
            if (i2 >= numMetals - 1) continue;
            this.viaGDSLabel[i2] = new JLabel("Via-" + (i2 + 1) + " GDS layer:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 9 + i2 * 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 10, 1, 0);
            this.gds.add((Component)this.viaGDSLabel[i2], gbc);
            this.viaGDS[i2] = new JTextField();
            this.viaGDS[i2].setText(Integer.toString(data.getGDSVia()[i2]));
            this.viaGDS[i2].setColumns(8);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 9 + i2 * 2;
            gbc.insets = new Insets(4, 0, 1, 2);
            this.gds.add((Component)this.viaGDS[i2], gbc);
        }
    }

    public void term() {
        TechEditWizardData data = this.wizard.getTechEditData();
        int numMetals = data.getNumMetalLayers();
        for (int i = 0; i < numMetals; ++i) {
            data.setGDSMetal(i, TextUtils.atoi(this.metalGDS[i].getText()));
            if (i >= numMetals - 1) continue;
            data.setGDSVia(i, TextUtils.atoi(this.viaGDS[i].getText()));
        }
        data.setGDSDiff(TextUtils.atoi(this.diffGDS.getText()));
        data.setGDSPoly(TextUtils.atoi(this.polyGDS.getText()));
        data.setGDSNPlus(TextUtils.atoi(this.nPlusGDS.getText()));
        data.setGDSPPlus(TextUtils.atoi(this.pPlusGDS.getText()));
        data.setGDSNWell(TextUtils.atoi(this.nWellGDS.getText()));
        data.setGDSContact(TextUtils.atoi(this.contactGDS.getText()));
        data.setGDSMarking(TextUtils.atoi(this.markingGDS.getText()));
    }
}

