/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.PageStorage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FilePageStorage
extends PageStorage {
    private static final int BLOCK_SIZE = 16384;
    private RandomAccessFile raf;
    private int numpages;

    public static FilePageStorage create() {
        return new FilePageStorage();
    }

    public synchronized int getNumPages() {
        return this.numpages;
    }

    private FilePageStorage() {
        super(16384);
        this.raf = null;
        this.numpages = 0;
    }

    private FilePageStorage(RandomAccessFile raf) {
        super(16384);
        try {
            this.raf = raf;
            this.numpages = (int)(raf.length() % (long)this.getPageSize());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized int createPage() {
        if (this.raf == null) {
            try {
                this.raf = new RandomAccessFile(File.createTempFile("pagestorage", ".ebtree"), "rw");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.numpages++;
    }

    public void writePage(int pageid, byte[] buf, int ofs) {
        try {
            this.raf.seek(pageid * this.getPageSize());
            this.raf.write(buf, ofs, this.getPageSize());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readPage(int pageid, byte[] buf, int ofs) {
        try {
            this.raf.seek(pageid * this.getPageSize());
            this.raf.readFully(buf, ofs, this.getPageSize());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void fsync(int pageid) {
        this.fsync();
    }

    public void fsync() {
    }

    public synchronized void close() {
    }
}

