/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.ConsoleWrite;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;

class StdOut
extends Thread {
    private InputStreamReader output;
    private boolean processRunning;
    private ConsoleTextArea cta;
    private StringBuffer data;

    public StdOut(Process process, ConsoleTextArea consoleTextArea) {
        this.setDaemon(true);
        this.output = new InputStreamReader(process.getInputStream());
        this.cta = consoleTextArea;
        this.processRunning = true;
        this.data = new StringBuffer();
    }

    public void run() {
        try {
            while (this.output.ready() || this.processRunning) {
                char[] cArray;
                int n;
                if (!this.output.ready() || (n = this.output.read(cArray = new char[255])) == -1) continue;
                String string = new String(cArray, 0, n);
                this.data.append(string);
                SwingUtilities.invokeAndWait(new ConsoleWrite(this.cta, string));
            }
        }
        catch (Exception exception) {
            System.err.println("Problem writing to standard output.");
            System.err.println(exception);
        }
    }

    public void done() {
        this.processRunning = false;
    }

    public String getData() {
        return this.data.toString();
    }
}

