"======================================================================
|
|   SUnit testing framework scripting system
|   I don't know why you'd use this; anyway it is here...
|
|   This file is in the public domain.
|
 ======================================================================"

Object subclass: #TestSuitesScripter
	instanceVariableNames: 'script stream'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnit'
!

!TestSuitesScripter class methodsFor: 'Example'!

exampleScripting
        ^(TestSuitesScripter script: ' "scratch suite 3" ExampleSetTest SUnitTest* ') value

    "Modified: / 21.6.2000 / 10:18:08 / Sames"
! !

!TestSuitesScripter class methodsFor: 'Init / Release'!

run: aString
	^self new run: aString!

script: aString
	^self new setScript: aString! !

!TestSuitesScripter methodsFor: 'Printing'!

printOn: aStream
        aStream nextPutAll: (script isNil 
                ifFalse: [script] 
                ifTrue: ['N/A'])

    "Created: / 21.6.2000 / 10:15:29 / Sames"
! !

!TestSuitesScripter methodsFor: 'Private'!

executeSingleSuiteScript: aString 
        | useHierarchy realName testCase |
        aString last = $*
                ifTrue: 
                        [realName := aString copyFrom: 1 to: aString size - 1.
                        useHierarchy := true]
                ifFalse: 
                        [realName := aString.
                        useHierarchy := false].
        realName isEmpty ifTrue: [^nil].
        testCase := SUnitNameResolver classNamed: realName sunitAsSymbol.
        testCase isNil ifTrue: [^nil].
        ^useHierarchy
                ifTrue: [self hierarchyOfTestSuitesFrom: testCase]
                ifFalse: [testCase suite]

    "Modified: / 21.6.2000 / 10:16:02 / Sames"
!

getNextToken
        [stream atEnd not and: [stream peek first = $"]] whileTrue: [self skipComment].
        ^stream atEnd not
                ifTrue: [stream next]
                ifFalse: [nil]

    "Modified: / 21.6.2000 / 10:16:16 / Sames"
!

hierarchyOfTestSuitesFrom: aTestCase 
        | subSuite |
        subSuite := TestSuite new.
        subSuite addTest: aTestCase suite.
        aTestCase allSubclasses do: [:each | subSuite addTest: each sunitName sunitAsSymbol sunitAsClass suite].
        ^subSuite

    "Modified: / 21.6.2000 / 10:16:29 / Sames"
!

setScript: aString
	script := aString!

skipComment
        | token inComment |
        token := stream next.
        token size > 1 & (token last = $") ifTrue: [^nil].
        inComment := true.
        [inComment & stream atEnd not]
                whileTrue: 
                        [token := stream next.
                        token last = $" ifTrue: [inComment := false]]

    "Modified: / 21.6.2000 / 10:16:47 / Sames"
! !

!TestSuitesScripter methodsFor: 'Scripting'!

run: aString
        | suite subSuite token |
        suite := TestSuite new.
        stream := ReadStream on: aString sunitSubStrings. 
        [stream atEnd] whileFalse: 
                [token := self getNextToken.
                token notNil ifTrue: [
                        subSuite := self executeSingleSuiteScript: token.
                        subSuite notNil ifTrue:[suite addTest: subSuite]]].
        ^suite

    "Modified: / 21.6.2000 / 10:17:11 / Sames"
!

value
	^self run: script! !

SUnitTest subclass: #TestSuitesHierarchyScriptTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'
!

!TestSuitesHierarchyScriptTest methodsFor: 'Testing'!

testRan
        self setRun

    "Modified: / 21.6.2000 / 10:25:38 / Sames"
! !


TestSuitesHierarchyScriptTest subclass: #TestSuitesCompoundScriptTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'
!

!TestSuitesCompoundScriptTest methodsFor: 'Testing'!

testRan
	super testRan! !


TestCase subclass: #TestSuitesScriptTest
	instanceVariableNames: 'scripter suite'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SUnitTests'
!

!TestSuitesScriptTest methodsFor: 'Running'!

setUp
	scripter := TestSuitesScripter new.! !

!TestSuitesScriptTest methodsFor: 'Testing'!

testCompoundScript
        | allTestCaseClasses superCase subCase |
        allTestCaseClasses := (scripter run: 'TestSuitesHierarchyScriptTest TestSuitesCompoundScriptTest') tests. 
        self assert: allTestCaseClasses size = 2.
        superCase := (allTestCaseClasses at: 1) tests first.
        self assert: superCase class sunitName sunitAsSymbol = #TestSuitesHierarchyScriptTest.
        subCase := (allTestCaseClasses at: 2) tests first.
        self assert: subCase class sunitName sunitAsSymbol = #TestSuitesCompoundScriptTest.

    "Modified: / 21.6.2000 / 10:26:48 / Sames"
!

testEmbeddedNameCommentScript
        suite := scripter run: ' "This comment contains the name of a SUnitTest Case"  TestSuitesScriptTest'.
        self assert: suite tests size = 1

    "Modified: / 21.6.2000 / 10:27:02 / Sames"
!

testEmptyCommentScript
        suite := scripter run: ' " " TestSuitesScriptTest'.
        self assert: suite tests size = 1

    "Modified: / 21.6.2000 / 10:27:14 / Sames"
!

testEmptyHierarchyScript
        suite := scripter run: '*'.
        self assert: suite tests isEmpty

    "Modified: / 21.6.2000 / 10:27:24 / Sames"
!

testEmptyScript
        suite := scripter run: ''.
        self assert: suite tests isEmpty

    "Modified: / 21.6.2000 / 10:27:39 / Sames"
!

testHierarchyScript
        | allTestCaseClasses superCase subCase |
        suite := scripter run: 'TestSuitesHierarchyScriptTest*'.
        allTestCaseClasses := suite tests. 
        self assert: allTestCaseClasses size = 1.
        superCase := (allTestCaseClasses first tests at: 1) tests first.
        self assert: superCase class sunitName sunitAsSymbol = #TestSuitesHierarchyScriptTest.
        subCase := (allTestCaseClasses first tests at: 2) tests first.
        self assert: subCase class sunitName sunitAsSymbol = #TestSuitesCompoundScriptTest.

    "Modified: / 21.6.2000 / 10:28:02 / Sames"
!

testOpenCommentScript
        suite := scripter run: ' "SUnitTest'.
        self assert: suite tests isEmpty

    "Modified: / 21.6.2000 / 10:28:18 / Sames"
!

testSimpleScript
        | allTestCaseClasses case |
        suite := scripter run: 'TestSuitesHierarchyScriptTest'.
        allTestCaseClasses := suite tests.
        self assert: allTestCaseClasses size = 1.
        case := (allTestCaseClasses at: 1) tests at: 1.
        self assert: case class sunitName sunitAsSymbol = #TestSuitesHierarchyScriptTest.

    "Modified: / 21.6.2000 / 10:28:35 / Sames"
!

testSingleWordCommentScript
        suite := scripter run: ' "SUnitTest" TestSuitesScriptTest'.
        self assert: suite tests size = 1

    "Modified: / 21.6.2000 / 10:28:47 / Sames"
!

testTwoCommentsScript
        suite := scripter run: ' " SUnitTest "  " SUnitTest " TestSuitesScriptTest'.
        self assert: suite tests size = 1

    "Modified: / 21.6.2000 / 10:28:59 / Sames"
! !

