var __abCancelled;
var __abWarn;
var console = Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService);

// Checks if a filter is already a regular expression. if warn is true,
// the user is warned.
function adblockIsRegExp(filter, warn) {	
	if (filter.charAt(0) == "/" &&
		filter.charAt( filter.length - 1) == "/") {
		return true;	
	} else {
		return false;
	}
}

// Warns the user that he has entered a regular expression. 
// Returns true if the user is ok with this, false if he wants to change the filter.
function adblockWarnRegExp()
{
	var Branch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("adblock.");
	var warnregexp = Branch.getBoolPref("warnregexp");
	
	if (!warnregexp)
		return true;
	
	var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
	var check = {value: false};
	var result = prompts.confirmCheck(window, "Warning",
		"The filter you entered will be interpreted as a regular expression.\
		If you did not mean for this to happen, or don't know what a regular expression is,\
		press cancel and remove / from the edges of the filter.",
		"I know what I'm doing. Don't warn me in the future.", check);
	
	Branch.setBoolPref("warnregexp", !check.value);
	return result;
}
