/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.FVDCodeBaseDelegate;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.Message;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected Connection conn;
    protected Message msg;

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public IIOPInputStream() {
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super(oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super(oRB, byArray, n, bl);
        this.msg = message;
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        this(connection.getORB(), connection);
        ORB oRB = connection.getORB();
        if (oRB.transportDebugFlag) {
            this.dprint("Constructing IIOPInputStream object");
        }
        this.buf = byArray;
        this.msg = message;
        this.index = 12;
        this.littleEndian = this.msg.isLittleEndian();
        this.size = this.msg.getSize();
        if (this.size > this.buf.length) {
            byte[] byArray2 = this.buf;
            this.buf = new byte[this.size];
            System.arraycopy(byArray2, 0, this.buf, 0, byArray2.length);
        }
        if (oRB.transportDebugFlag) {
            this.dprint("Reading the fully message");
        }
        Message.readFully(connection.getInputStream(), this.buf, this.index, this.size - this.index);
        if (oRB.transportDebugFlag) {
            this.dprint("Unmarshalling the GIOP message");
        }
        this.msg.read(this);
        if (oRB.transportDebugFlag) {
            this.dprint("Setting the time stamp");
        }
        connection.stampTime();
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        if (connection != null) {
            this.orb = connection.getORB();
        }
    }

    public final Message getMessage() {
        return this.msg;
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL(1398079496, CompletionStatus.COMPLETED_MAYBE);
    }

    final CodeBase getCodeBase() {
        if (this.conn == null) {
            return FVDCodeBaseDelegate.singleton;
        }
        return ((IIOPConnection)this.conn).getCodeBaseReference();
    }
}

