/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.RDN;

public class X500Name
implements Principal,
GeneralNameInterface {
    private String dn = null;
    private RDN[] names;
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] SURNAME_DATA = new int[]{2, 5, 4, 4};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] GIVENNAME_DATA = new int[]{2, 5, 4, 42};
    private static final int[] INITIALS_DATA = new int[]{2, 5, 4, 43};
    private static final int[] GENERATIONQUALIFIER_DATA = new int[]{2, 5, 4, 44};
    private static final int[] DNQUALIFIER_DATA = new int[]{2, 5, 4, 46};
    public static final ObjectIdentifier commonName_oid = new ObjectIdentifier(commonName_data);
    public static final ObjectIdentifier countryName_oid = new ObjectIdentifier(countryName_data);
    public static final ObjectIdentifier localityName_oid = new ObjectIdentifier(localityName_data);
    public static final ObjectIdentifier orgName_oid = new ObjectIdentifier(orgName_data);
    public static final ObjectIdentifier orgUnitName_oid = new ObjectIdentifier(orgUnitName_data);
    public static final ObjectIdentifier stateName_oid = new ObjectIdentifier(stateName_data);
    public static final ObjectIdentifier streetAddress_oid = new ObjectIdentifier(streetAddress_data);
    public static final ObjectIdentifier title_oid = new ObjectIdentifier(title_data);
    public static final ObjectIdentifier DNQUALIFIER_OID = new ObjectIdentifier(DNQUALIFIER_DATA);
    public static final ObjectIdentifier SURNAME_OID = new ObjectIdentifier(SURNAME_DATA);
    public static final ObjectIdentifier GIVENNAME_OID = new ObjectIdentifier(GIVENNAME_DATA);
    public static final ObjectIdentifier INITIALS_OID = new ObjectIdentifier(INITIALS_DATA);
    public static final ObjectIdentifier GENERATIONQUALIFIER_OID = new ObjectIdentifier(GENERATIONQUALIFIER_DATA);
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static final ObjectIdentifier ipAddress_oid = new ObjectIdentifier(ipAddress_data);
    private static final int[] DOMAIN_COMPONENT_DATA = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    public static final ObjectIdentifier DOMAIN_COMPONENT_OID = new ObjectIdentifier(DOMAIN_COMPONENT_DATA);

    public X500Name(String string) throws IOException {
        this.parseDN(string);
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string6));
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public X500Name(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof X500Name) {
            return this.equals((X500Name)object);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.names.length) {
            n += this.names[n3].hashCode() * n2++;
            ++n3;
        }
        return n;
    }

    public synchronized boolean equals(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (this.names.length != x500Name.names.length) {
            return false;
        }
        int n = 0;
        while (n < this.names.length) {
            if (!this.names[n].equals(x500Name.names[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String getDomain() throws IOException {
        DerValue derValue = this.findAttribute(DOMAIN_COMPONENT_OID);
        return this.getString(derValue);
    }

    public String getDNQualifier() throws IOException {
        DerValue derValue = this.findAttribute(DNQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getSurname() throws IOException {
        DerValue derValue = this.findAttribute(SURNAME_OID);
        return this.getString(derValue);
    }

    public String getGivenName() throws IOException {
        DerValue derValue = this.findAttribute(GIVENNAME_OID);
        return this.getString(derValue);
    }

    public String getInitials() throws IOException {
        DerValue derValue = this.findAttribute(INITIALS_OID);
        return this.getString(derValue);
    }

    public String getGeneration() throws IOException {
        DerValue derValue = this.findAttribute(GENERATIONQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getIP() throws IOException {
        DerValue derValue = this.findAttribute(ipAddress_oid);
        return this.getString(derValue);
    }

    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        DerValue derValue = null;
        int n = 0;
        while (n < this.names.length) {
            derValue = this.names[n].findAttribute(objectIdentifier);
            if (derValue != null) break;
            ++n;
        }
        return derValue;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = null;
        byte[] byArray = derInputStream.toByteArray();
        try {
            derValueArray = derInputStream.getSequence(5);
        }
        catch (IOException iOException) {
            DerValue derValue = new DerValue(48, byArray);
            byArray = derValue.toByteArray();
            derValueArray = new DerInputStream(byArray).getSequence(5);
        }
        this.names = new RDN[derValueArray.length];
        int n = 0;
        while (n < derValueArray.length) {
            this.names[n] = new RDN(derValueArray[n]);
            ++n;
        }
    }

    public void emit(DerOutputStream derOutputStream) throws IOException {
        this.encode(derOutputStream);
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.names != null) {
            int n = 0;
            while (n < this.names.length) {
                this.names[n].encode(derOutputStream2);
                ++n;
            }
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.names != null) {
            int n = 0;
            while (n < this.names.length) {
                this.names[n].encode(derOutputStream2);
                ++n;
            }
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private void parseDN(String string) throws IOException {
        RDN rDN;
        String string2;
        int n;
        if (string == null || string.equals("")) {
            this.names = new RDN[0];
            return;
        }
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        String string3 = string.trim();
        int n4 = 0;
        while ((n = string3.indexOf(44, n4)) >= 0) {
            if (n > 0 && string3.charAt(n - 1) != '\\' && (n3 += this.countQuotes(string3, n4, n)) != 1) {
                string2 = string3.substring(n2, n).trim();
                rDN = new RDN(string2);
                vector.addElement(rDN);
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        string2 = string3.substring(n2).trim();
        rDN = new RDN(string2);
        vector.addElement(rDN);
        int n5 = vector.size();
        this.names = new RDN[n5];
        Enumeration enumeration = vector.elements();
        int n6 = n5 - 1;
        while (enumeration.hasMoreElements()) {
            this.names[n6--] = (RDN)enumeration.nextElement();
        }
    }

    private int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (string.charAt(n4) == '\"') {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    private void generateDN() {
        String string = null;
        int n = this.names.length - 1;
        while (n >= 0) {
            string = string == null ? this.names[n].toString() : string + ", " + this.names[n].toString();
            --n;
        }
        this.dn = string;
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.equals(commonName_oid)) {
            return commonName_oid;
        }
        if (objectIdentifier.equals(countryName_oid)) {
            return countryName_oid;
        }
        if (objectIdentifier.equals(localityName_oid)) {
            return localityName_oid;
        }
        if (objectIdentifier.equals(stateName_oid)) {
            return stateName_oid;
        }
        if (objectIdentifier.equals(streetAddress_oid)) {
            return streetAddress_oid;
        }
        if (objectIdentifier.equals(orgName_oid)) {
            return orgName_oid;
        }
        if (objectIdentifier.equals(orgUnitName_oid)) {
            return orgUnitName_oid;
        }
        if (objectIdentifier.equals(title_oid)) {
            return title_oid;
        }
        if (objectIdentifier.equals(ipAddress_oid)) {
            return ipAddress_oid;
        }
        if (objectIdentifier.equals(PKCS9Attribute.EMAIL_ADDRESS_OID)) {
            return PKCS9Attribute.EMAIL_ADDRESS_OID;
        }
        if (objectIdentifier.equals(DOMAIN_COMPONENT_OID)) {
            return DOMAIN_COMPONENT_OID;
        }
        if (objectIdentifier.equals(DNQUALIFIER_OID)) {
            return DNQUALIFIER_OID;
        }
        if (objectIdentifier.equals(SURNAME_OID)) {
            return SURNAME_OID;
        }
        if (objectIdentifier.equals(GIVENNAME_OID)) {
            return GIVENNAME_OID;
        }
        if (objectIdentifier.equals(INITIALS_OID)) {
            return INITIALS_OID;
        }
        if (objectIdentifier.equals(GENERATIONQUALIFIER_OID)) {
            return GENERATIONQUALIFIER_OID;
        }
        return objectIdentifier;
    }
}

