(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Bridge.
 *
 * The Initial Developer of the Original Code is
 * Sterling Bates.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Theo Lustenberger <theo@theo.ch>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)

(*
 *  Please send comments for enhancements, fixes, etc, to whoelse@sterlingbates.com
 *
 *  Contents: Some quick samples on how to use the javascript engine.
 *
 *   Revision history:
 *    July 15, 2003 - Initial release
 *   August 5, 2003 - Updated file notes
 * October 30, 2003 - Added TJSBridge sample
 *                  - Modified my_def flag from JSCLASS_NEW_RESOLVE to JSCLASS_HAS_PRIVATE
 *      Nov 7, 2003 - CreateFunction's |myfuncs| changed to TJSFunctionSpecArray type...
 *                    this permits the TJSEngine to do some fiddling with the array
 *     Nov 11, 2003 - Moved |engine| instance to the jsintf.pas file for more global access
 *     Nov 20, 2003 - Moved |engine| back into each function's declaration
 *     Nov 24, 2003 - CallString's |name| variable is now a jsval
 *     Nov 26, 2003 - Most of these samples are now out of date.  They need an update badly.
 *      Dec 7, 2003 - These samples now work properly, and added an enumeration sample
 *)

unit jssamples;

{$J+}

interface

uses
  SysUtils,  jsintf, js15decl, jssamples_natives, jsbridge, jssamples_bridge;

(* A generic class definition named "my". Use this as a template for your own generic objects. *)
const
  my_def: JSClass = (name: 'my'; flags: JSCLASS_HAS_PRIVATE; addProperty: JS_PropertyStub;
                     delProperty: JS_PropertyStub; getProperty: JS_PropertyStub; setProperty: JS_PropertyStub;
                     enumerate: JS_EnumerateStub; resolve: JS_ResolveStub; convert: JS_ConvertStub;
                     finalize: JS_FinalizeStub);

procedure CallString;
procedure CallInteger;
procedure CreateObject;
procedure CreateFunction;
procedure CreateBridge;
procedure Enumeration;

var
  engine: TJSEngine;

implementation

procedure CallString;
var
  name: TJSString;
  res: TBridgeString;
  engine: TJSEngine;
  global: TJSObject;
begin
  engine := TJSEngine.Create(40000);
  try
    global := engine.Global;
    name := engine.Declare('User');
    global.Evaluate('function hiName(name) { return "Hello, " +name; }');
    global.Call('hiName', [name], res);
  finally
    engine.Free;
  end;
end;

procedure CallInteger;
var
  param: TJSInteger;
  res: Integer;
  engine: TJSEngine;
  global: TJSObject;
begin
  engine := TJSEngine.Create(40000);
  try
    global := engine.Global;
    param := engine.Declare(3);
    global.Evaluate('function doMath(param) { return 6 * param; }');
    global.Call('doMath', [param], res);
  finally
    engine.Free;
  end;
end;

procedure CreateObject;
var
  my: TJSObject;
  prop: TJSInteger;
  num: Integer;
  engine: TJSEngine;
  global: TJSObject;
begin
  engine := TJSEngine.Create(40000);
  try
    global := engine.Global;
    my := global.AddObject(my_def, 'createObjectSample');

    prop := global.Declare(6);
    my.SetProperty('myprop',prop);
    my.GetProperty('myprop',num);
  finally
    engine.Free;
  end;
end;

(* Functions "GetNumber" & "GetString" available in jssamples_natives.pas *)

procedure CreateFunction;
var
  my: TJSObject;
  numfunc: TJSFunction;
  strfunc: TJSFunction;
  res: TBridgeString;
  str: TBridgeString;
  engine: TJSEngine;
  global: TJSObject;
begin
  engine := TJSEngine.Create(40000);
  try
    global := engine.Global;
    my := global.AddObject(my_def, 'createFunctionSample');

    numfunc := my.AddMethod('GetNumber',GetNumber,0);
    strfunc := my.AddMethod('GetString',GetString,0);

    (* Change res to whatever var type you want the result in *)
    numfunc.Call(res);
    strfunc.Call(str);
  finally
    engine.Free;
  end;
end;

procedure CreateBridge;
var
  bridge: TMyJSBridge;
  engine: TJSEngine;
begin
  engine := TJSEngine.Create(40000);
  try
    bridge := TMyJSBridge.Create(engine, 'createBridgeSample');
    (*
     * Or, you can create the bridge without connecting it to a
     * running engine, and connect it later:
     *
     * bridge := TMyJSBridge.Create;
     *  [...]
     * bridge.Connect(engine, 'createBridgeSample');
     *)
    try
      (*
       * The following lines call the bridge object's methods.
       *)
      engine.Global.Evaluate('createBridgeSample.Alert("An alert TBridgeString")');
      engine.Global.Evaluate('createBridgeSample.SetValue("new value")');
    finally
      bridge.Free;
    end;
  finally
    engine.Free;
  end;
end;

procedure Enumeration;
var
  list: TStringArray;
  i: Integer;
  typ: TBridgeString;
  engine: TJSEngine;
  global: TJSObject;
begin
  engine := TJSEngine.Create(80000);
  try
    global := engine.Global;
    global.Declare('Test','myname');// declare a string property
    global.Declare(16,'newint');    // declare an integer property
    global.Declare(true,'newbool');
    engine.NewJSObject('myobj');    // declare an object property called myobj

    list := global.Enumerate;
    for i := 0 to Length(list)-1 do
    begin
      case global.TypeOf(list[i]) of
        JSTYPE_NUMBER: typ := 'Number';
        JSTYPE_STRING: typ := 'String';
        JSTYPE_BOOLEAN: typ := 'Boolean';
        JSTYPE_OBJECT: typ := 'Object';
        JSTYPE_FUNCTION: typ := 'Function';
        else
          typ := 'Unknown';
      end;
      (*
       * When TypeOf(list[i]) is JSVAL_OBJECT, you can then write
       *
       *    global.GetProperty(list[i],obj);
       *
       * where |obj| is an instance of TJSObject.  This allows you to enumerate
       * as deep as you need to.
       *)
    end;
  finally
    engine.Free;
  end;
end;

end.

