/* 
	FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
	Author: Duong Thanh An - dgthanhan@gmail.com (core)
	Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)

	Copyright (C) 2004 Anisolution.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Anisolution.com
	http://www.anisolution.com
	HCMC Vietnam
	Duong Thanh An
	dgthanhan@gmail.com


	$Id: ext-text-edit.js,v 1.1 2004/11/27 11:58:08 thanh.an Exp $

*/

installExtension(new TextEditExt());

function TextEditExt() {

	this.acceptExts = "(txt)|([ja]sp)|(php[s3]?)|(inc)|(aspx)|(asa)|(cfm)|(ini)|(html?)|(css)|(xml)|(dtd)|(xul)|(js)|(java)|(pl)|(cpp)|(vb[s]?)";
	this.getDisplayInfo = function() {
		var sel = getListSelectionModel();
		if(!sel) return null;
		if(!isFileOfType(sel, this.acceptExts)) return null;
		var menuItem = new ExtensionMenuItem();
		menuItem.caption = "Edit with Text Editor";
		menuItem.iconImage = "images/ext/text-editor.png";
		menuItem.action = function () {
			//calling the editor
			var list = document.getElementById("contentList");
			var index = list.view.selection.currentIndex;
			if(index < 0) return;
			var item = list.view.getItemAtIndex(index);
			if(item.fsData.fstype != "file") return;
			window.open(CLIENT_EDIT_CONTENT_WINDOW_PATH + "?path=" + escape(item.fsData.absolutePath), "", "chrome,resizable=yes,statusbar=no,width=700,height=550");
		};
		return menuItem;
	};

	this.getAboutInfo = function() {
		return "Text Editor by Duong Thanh An. Email: dgthanhan@yahoo.com";
	};
}

