

var _elementIDs = ["moveSystemCaret", "hideTabBar",
                    "loadInBackground", "useAutoScrolling",
                    "useSmoothScrolling", "enableAutoImageResizing",
                    "useSSL2", "useSSL3", "useTLS1", "useTypeAheadFind",
                    "linksOnlyTypeAheadFind",
                    "certSelection", "securityOCSPEnabled", "serviceURL", "signingCA",
                    "enableSoftwareInstall", "enableSmartUpdate", 
                    "enableExtensionUpdate", "enableAutoInstall"];

const nsIX509CertDB = Components.interfaces.nsIX509CertDB;
const nsX509CertDB = "@mozilla.org/security/x509certdb;1";
const nsIOCSPResponder = Components.interfaces.nsIOCSPResponder;
const nsISupportsArray = Components.interfaces.nsISupportsArray;

var certdb;
var ocspResponders;
function Startup() {
  updatePrefs();
  var ocspEntry;
  var i;

  certdb = Components.classes[nsX509CertDB].getService(nsIX509CertDB);
  ocspResponders = certdb.getOCSPResponders();

  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  for (i=0; i<ocspResponders.length; i++) {
    ocspEntry = ocspResponders.queryElementAt(i, nsIOCSPResponder);
    var menuItemNode = document.createElement("menuitem");
    menuItemNode.setAttribute("value", ocspEntry.responseSigner);
    menuItemNode.setAttribute("label", ocspEntry.responseSigner);
    signersMenu.firstChild.appendChild(menuItemNode);
  }

  doSecurityEnabling();
  
  // XXXben menulists suck, see explanation in pref-privacy.js
  // style resolution problem inside scrollable areas. 
  var scb = document.getElementById("signingCABox");
  var sca = document.getElementById("signingCA");
  sca.removeAttribute("hidden");
  sca.parentNode.removeChild(sca);
  scb.appendChild(sca);
}

function updatePrefs() {
  var enabled = document.getElementById("useTypeAheadFind").checked;
  var linksOnly = document.getElementById("linksOnlyTypeAheadFind");
  linksOnly.disabled = !enabled;
}

function doSecurityEnabling()
{
  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  var radiogroup = document.getElementById("securityOCSPEnabled");
  
  switch ( radiogroup.value ) {
  case "0":
  case "1":
    signersMenu.setAttribute("disabled", true);
    signersURL.setAttribute("disabled", true);
    break;
  case "2":
  default:
    signersMenu.removeAttribute("disabled");
    signersURL.removeAttribute("disabled");
  }
}

function changeURL()
{
  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  var CA = signersMenu.getAttribute("value");
  var i;
  var ocspEntry;

  for (i=0; i < ocspResponders.length; i++) {
    ocspEntry = ocspResponders.queryElementAt(i, nsIOCSPResponder);
    if (CA == ocspEntry.responseSigner) {
      signersURL.setAttribute("value", ocspEntry.serviceURL);
      break;
    }
  }
}

function openCrlManager()
{
    window.open('chrome://pippki/content/crlManager.xul',  "",
                'chrome,width=500,height=400,resizable=1');
}

function openCertManager()
{
  //check for an existing certManager window and focus it; it's not application modal
  const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
  const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
  const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
  var lastCertManager = kWindowMediator.getMostRecentWindow("mozilla:certmanager");
  if (lastCertManager)
    lastCertManager.focus();
  else {
    window.open('chrome://pippki/content/certManager.xul',  "",
                'chrome,centerscreen,resizable=yes,dialog=no');
  }
}

function openDeviceManager()
{
  //check for an existing deviceManger window and focus it; it's not application modal
  const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
  const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
  const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
  var lastCertManager = kWindowMediator.getMostRecentWindow("mozilla:devicemanager");
  if (lastCertManager)
    lastCertManager.focus();
  else {
    window.open('chrome://pippki/content/device_manager.xul',  "devmgr",
                'chrome,centerscreen,resizable=yes,dialog=no');
  }
}

function checkForUpdates()
{
  var updates = Components.classes["@mozilla.org/updates/update-service;1"]
                          .getService(Components.interfaces.nsIUpdateService);
  updates.checkForUpdates([], 0, Components.interfaces.nsIUpdateItem.TYPE_ANY, 
                          Components.interfaces.nsIUpdateService.SOURCE_EVENT_USER,
                          window);
}

