/*
 * Decompiled with CFR 0.152.
 */
package org.l10nZilla.reader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.l10nZilla.SourcePhraseSingleton;
import org.l10nZilla.TranslationFile;
import org.l10nZilla.reader.translationsReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class mozJarReader
extends translationsReader {
    private JarEntry je;
    private FileInputStream fis;
    private JarInputStream jis;
    private BufferedInputStream bis;
    private String sourceJarFileName;
    private File tempFile;
    private String currentFileName;
    private int fileType;
    private static final int FILETYPE_PROPERTIES = 1;
    private static final int FILETYPE_DTD = 7;
    private static final int FILETYPE_UNKNOWN = 8;
    private static final int FILETYPE_UNSUPPORTED = 9;
    private static final int STATUS_COMMENT_WAITING = 1;
    private static final int STATUS_COMMENT_BEGUN = 2;
    private static final int STATUS_COMMENT_JUMP = 3;
    private static final int STATUS_COMMENT_SCOPE = 4;
    private static final int STATUS_COMMENT_NOTE = 5;
    private static final int STATUS_ENTITY_KEY = 6;
    private static final int STATUS_ENTITY_TEXT = 7;
    private static final int SCOPE_FILE = 1;
    private static final int SCOPE_BLOCK = 2;
    private static final int SCOPE_KEY = 3;
    private static final String TOKEN_ENTITY = "!ENTITY";
    private static final String TOKEN_COMMENT = "!--";
    private static final String TOKEN_LOCNOTE = "LOCALIZATION";
    private static final String TOKEN_BEGINBLOCK = "BEGIN";
    private static final String TOKEN_ENDBLOCK = "END";
    private Properties prop = null;
    private Enumeration enum = null;
    InputStreamReader isr = null;
    BufferedReader br = null;
    StringBuffer rawBuffer = null;
    private String strSourceLanguageCode = "";

    public mozJarReader(String install, String source) throws IOException, FileNotFoundException {
        super(install, source);
        this.sourceJarFileName = source;
        this.fis = new FileInputStream(source);
        this.jis = new JarInputStream(this.fis);
        this.bis = new BufferedInputStream(this.jis);
    }

    public TranslationFile getNextFile() throws IOException {
        TranslationFile result = null;
        this.je = this.jis.getNextJarEntry();
        if (this.je != null) {
            this.currentFileName = this.je.getName();
            System.out.println("Next File : ".concat(String.valueOf(String.valueOf(this.currentFileName))));
            result = new TranslationFile(this.currentFileName);
            this.resetFile();
            if (this.currentFileName.endsWith(".properties")) {
                this.tempFile = this.copyToTemp(this.je, this.bis);
                this.fis = new FileInputStream(this.tempFile);
                this.setupReadPropertiesFile(this.fis);
            } else if (this.currentFileName.endsWith(".dtd")) {
                this.tempFile = this.copyToTemp(this.je, this.bis);
                this.fis = new FileInputStream(this.tempFile);
                this.setupReadDTDFile(this.fis);
            } else if (this.currentFileName.endsWith(".gif")) {
                this.tempFile = this.copyToTemp(this.je, this.bis);
                result.handleBinaryFile(this.tempFile);
            } else {
                this.tempFile = this.copyToTemp(this.je, this.bis);
                this.fis = new FileInputStream(this.tempFile);
                String rawBuffer = this.readUnsupportedFileType(this.tempFile);
                result.addRawContent(rawBuffer);
            }
        } else {
            result = null;
        }
        return result;
    }

    public String getSourceLanguageCode() {
        return this.strSourceLanguageCode;
    }

    public void setSourceLanguageCode(String srcLangCode) {
        this.strSourceLanguageCode = srcLangCode;
    }

    private void resetFile() {
        this.fileType = 8;
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public void getNextPhrase() throws IOException {
        SourcePhraseSingleton.instance().reset();
        if (this.fileType == 1) {
            this.getNextPropertiesPhrase();
        } else if (this.fileType == 7) {
            this.getNextDTDPhrase();
        } else if (this.fileType == 9) {
            SourcePhraseSingleton.instance().phrase().makeEmpty();
        }
        if (!SourcePhraseSingleton.instance().phrase().isEmpty()) {
            System.out.println("Read: ".concat(String.valueOf(String.valueOf(SourcePhraseSingleton.instance().phrase().getKey()))));
        } else {
            System.out.println("MozJarReader::getNextPhrase = null");
        }
    }

    private void setupReadPropertiesFile(FileInputStream fis) throws IOException {
        this.fileType = 1;
        this.prop = new Properties();
        this.prop.load(fis);
        fis.close();
        this.enum = this.prop.propertyNames();
    }

    private void getNextPropertiesPhrase() {
        String key = "";
        String text = "";
        if (this.enum.hasMoreElements()) {
            key = (String)this.enum.nextElement();
            text = this.prop.getProperty(key);
            SourcePhraseSingleton.instance().phrase().setKey(key);
            SourcePhraseSingleton.instance().phrase().setText(text);
            if (!this.strSourceLanguageCode.equalsIgnoreCase("en")) {
                SourcePhraseSingleton.instance().phrase().setTranslation(text);
            }
        } else {
            SourcePhraseSingleton.instance().phrase().makeEmpty();
        }
    }

    private void setupReadDTDFile(FileInputStream fis) throws UnsupportedEncodingException {
        this.fileType = 7;
        this.isr = new InputStreamReader((InputStream)fis, "UTF-8");
        this.br = new BufferedReader(this.isr);
    }

    private void getNextDTDPhrase() throws IOException {
        this.readNextDTDEntry();
    }

    private void readNextDTDEntry() throws IOException {
        boolean entryDone = false;
        StringBuffer segmentBuffer = null;
        boolean entityBegun = false;
        while (!entryDone) {
            int number = this.readNextDTDChar();
            if (number != -1) {
                char letter = (char)number;
                if (entityBegun) {
                    segmentBuffer.append(letter);
                    if (segmentBuffer.toString().equalsIgnoreCase(TOKEN_COMMENT)) {
                        entityBegun = false;
                        continue;
                    }
                    if (segmentBuffer.toString().equalsIgnoreCase(TOKEN_ENTITY)) {
                        this.readDTDEntity();
                        if (!this.strSourceLanguageCode.equalsIgnoreCase("en") && !SourcePhraseSingleton.instance().phrase().isEmpty()) {
                            SourcePhraseSingleton.instance().phrase().setTranslation(SourcePhraseSingleton.instance().phrase().getText());
                        }
                        entryDone = true;
                        continue;
                    }
                    if (letter != '>') continue;
                    entityBegun = false;
                    continue;
                }
                if (letter != '<') continue;
                entityBegun = true;
                segmentBuffer = new StringBuffer();
                continue;
            }
            entryDone = true;
        }
    }

    public void readDTDEntity() throws IOException {
        block10: {
            String key = "";
            String text = "";
            StringBuffer entityBuffer = null;
            int status = 6;
            boolean keyBegun = false;
            boolean textBegun = false;
            boolean more = true;
            char endChar = 'z';
            while (more) {
                int number = this.readNextDTDChar();
                if (number != -1) {
                    char letter = (char)number;
                    switch (status) {
                        case 6: {
                            if (keyBegun) {
                                if (letter == ' ' || letter == '\t') {
                                    key = entityBuffer.toString();
                                    status = 7;
                                    textBegun = false;
                                    break;
                                }
                                entityBuffer.append(letter);
                                break;
                            }
                            if (letter == ' ' || letter == '\t') break;
                            keyBegun = true;
                            entityBuffer = new StringBuffer();
                            entityBuffer.append(letter);
                            break;
                        }
                        case 7: {
                            if (textBegun) {
                                if (letter == endChar) {
                                    text = entityBuffer.toString();
                                    this.readDTDSkip();
                                    more = false;
                                    break;
                                }
                                entityBuffer.append(letter);
                                break;
                            }
                            if (letter != '\"' && letter != '\'') break;
                            textBegun = true;
                            entityBuffer = new StringBuffer();
                            endChar = letter;
                        }
                    }
                    continue;
                }
                more = false;
            }
            if (key == "" || text == "") break block10;
            SourcePhraseSingleton.instance().phrase().setKey(key);
            SourcePhraseSingleton.instance().phrase().setText(text);
        }
    }

    private int readNextDTDChar() throws IOException {
        int number = this.br.read();
        return number;
    }

    private void readDTDSkip() throws IOException {
        boolean more = true;
        while (more) {
            int number = this.readNextDTDChar();
            if (number != -1) {
                char letter = (char)number;
                if (letter != '>') continue;
                more = false;
                continue;
            }
            more = false;
        }
    }

    private File copyToTemp(JarEntry e, BufferedInputStream bis) throws IOException {
        File temp = File.createTempFile("MTT_", null);
        temp.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(temp);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        boolean theEnd = false;
        while (!theEnd) {
            int trans = bis.read();
            if (trans == -1) {
                theEnd = true;
                continue;
            }
            bos.write(trans);
        }
        bos.close();
        return temp;
    }

    private String readUnsupportedFileType(File tempFile) throws IOException {
        StringBuffer rawBuffer = null;
        this.fileType = 9;
        long fileSize = tempFile.length();
        rawBuffer = new StringBuffer((int)fileSize);
        InputStreamReader isr = new InputStreamReader(this.fis);
        BufferedReader br = new BufferedReader(isr);
        boolean theEnd = false;
        while (!theEnd) {
            int number = br.read();
            if (number == -1) {
                theEnd = true;
                continue;
            }
            char letter = (char)number;
            rawBuffer.append(letter);
        }
        return rawBuffer.toString();
    }

    static {
        FILETYPE_PROPERTIES = 1;
        FILETYPE_DTD = 7;
        FILETYPE_UNKNOWN = 8;
        FILETYPE_UNSUPPORTED = 9;
        STATUS_COMMENT_WAITING = 1;
        STATUS_COMMENT_BEGUN = 2;
        STATUS_COMMENT_JUMP = 3;
        STATUS_COMMENT_SCOPE = 4;
        STATUS_COMMENT_NOTE = 5;
        STATUS_ENTITY_KEY = 6;
        STATUS_ENTITY_TEXT = 7;
        SCOPE_FILE = 1;
        SCOPE_BLOCK = 2;
        SCOPE_KEY = 3;
        TOKEN_ENTITY = TOKEN_ENTITY;
        TOKEN_COMMENT = TOKEN_COMMENT;
        TOKEN_LOCNOTE = TOKEN_LOCNOTE;
        TOKEN_BEGINBLOCK = TOKEN_BEGINBLOCK;
        TOKEN_ENDBLOCK = TOKEN_ENDBLOCK;
    }
}

