/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2001.
   -
   - The Initial Developer of the Original Code is Henk-Johan van Rantwijk.
   - Portions created by Henk-Johan van Rantwijk are Copyright (C) 2001
   - Henk-Johan van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Henk-Johan van Rantwijk <bugs4hj@netscape.net> (Original Author)
   -
   - Alternatively, the contents of this file may be used under the
   - terms of the GNU General Public License Version 2 or later (the
   - "GPL"), in which case the provisions of the GPL are applicable
   - instead of those above.  If you wish to allow use of your
   - version of this file only under the terms of the GPL and not to
   - allow others to use your version of this file under the MPL,
   - indicate your decision by deleting the provisions above and
   - replace them with the notice and other provisions required by
   - the GPL.  If you do not delete the provisions above, a recipient
   - may use your version of this file under either the MPL or the
   - GPL.
   -
*/

//////////////////////////////////////////////////////////////////////////
//  this is a changed mozilla function
////////////////////////////////////////////////////////////////////////// 
function OpenBookmarkURL(node, datasources, event)
{
  if (node.getAttribute("group") == "true" && node.getAttribute("container") == "false")
    OpenBookmarkGroup(node, datasources);
  if (node.getAttribute("container") == "true" || (node.nodeName == "menuitem" && event.button == 1))
    return;
  var url = node.getAttribute("id");
  if (!url) // if empty url (most likely a normal menu item like "Manage Bookmarks",
    return; // don't bother loading it
  try {
    // add support for IE favorites under Win32, and NetPositive URLs under BeOS
    if (datasources) {
      var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                          .getService(Components.interfaces.nsIRDFService);
      var src = rdf.GetResource(url, true);
      var prop = rdf.GetResource("http://home.netscape.com/NC-rdf#URL", true);
      var target = datasources.GetTarget(src, prop, true);
      if (target) {
        target = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        if (target)
          url = target;
      }
    }
  } catch (ex) {
    return;
  }
  // Ignore "NC:" urls.
  if (url.substring(0, 3) == "NC:" )
    return;

  // Check if we have a browser window
  if (_content) {
    var aTab = null
    if (preventDupeTab(url))
      return;
    while (node.nodeName != "toolbarbutton" && node.nodeName != "menubar")
      node = node.parentNode;
    if ((node.nodeName == "menubar" && pref && pref.getBoolPref("multizilla.newtabfor.bookmarks") && !event.shiftKey) ||
        (node.nodeName == "toolbarbutton" && pref && pref.getBoolPref("multizilla.newtabfor.personal-toolbar") && !event.shiftKey) || 
        event.ctrlKey || event.button == 1) {
      if (url.substring(0,10) == "javascript")
        setTimeout(function() { loadURI(url) }, 0, getBrowser().selectedTab = getBrowser().addTab());
      else
        aTab = getBrowser().addTab(getShortcutOrURI(url));
      if (pref && !pref.getBoolPref("browser.tabs.loadInBackground"))
        getBrowser().selectedTab = aTab;
    }
    else
      loadURI(url);
    _content.focus();
  }
  else
    openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no", url);
}
//////////////////////////////////////////////////////////////////////////
//  this is a changed mozilla function
//////////////////////////////////////////////////////////////////////////
function handleURLBarRevert()
{
  var url = getWebNavigation().currentURI.spec;
  var throbberElement = document.getElementById("navigator-throbber");

  var isScrolling = gURLBar.userAction == "scrolling";
  
  // don't revert to last valid url unless page is NOT loading
  // and user is NOT key-scrolling through autocomplete list
  if (!throbberElement.hasAttribute("busy") && !isScrolling) {
    if (url != "about:blank") { 
      gURLBar.value = url;
      gURLBar.select();
      SetPageProxyState("valid", null); // XXX Build a URI and pass it in here.
      gBrowser = getBrowser();
      gBrowser.mCurrentBrowser.urlbarTyped = false;
      url = gProxyFavIcon.getAttribute("linked-icon");

      if (gBrowser.mTabbedMode)
        gBrowser.updateCurrentBrowser();
      else if (url) {
        gProxyFavIcon.setAttribute("src", url);
        gProxyDeck.selectedIndex = 1;
      }
    } else { //if about:blank, urlbar becomes ""
      gURLBar.value = "";
    }
  }

  // tell widget to revert to last typed text only if the user
  // was scrolling when they hit escape
  return isScrolling; 
}
//////////////////////////////////////////////////////////////////////////
// this is a changed mozilla (navigator.js) function 
//////////////////////////////////////////////////////////////////////////
function SetPageProxyState(aState, aURI)
{
  if (!gProxyButton)
    gProxyButton = document.getElementById("page-proxy-button");
  if (!gProxyFavIcon)
    gProxyFavIcon = document.getElementById("page-proxy-favicon");
  if (!gProxyDeck)
    gProxyDeck = document.getElementById("page-proxy-deck");

  if (aState == "valid") {
    gProxyButton.setAttribute("pageproxystate", aState);
    gLastValidURLStr = gURLBar.value;
    gURLBar.addEventListener("input", UpdatePageProxyState, false);
    if (gBrowser.shouldLoadFavIcon(aURI)) {
      var favStr = gBrowser.buildFavIconString(aURI);
      if (favStr != gProxyFavIcon.src) {
        gBrowser.loadFavIcon(aURI, "src", gProxyFavIcon);
        gProxyDeck.selectedIndex = 0;
      }
      else gProxyDeck.selectedIndex = 1;
    }
    else {
      gProxyDeck.selectedIndex = 0;
      gProxyFavIcon.removeAttribute("src");
    }
  } else if (aState == "invalid") {
    gProxyButton.setAttribute("pageproxystate", aState);
    gURLBar.removeEventListener("input", UpdatePageProxyState, false);
    gProxyDeck.selectedIndex = 0;
  } else if (aState == "disabled") {
    gURLBar.removeEventListener("input", UpdatePageProxyState, false);
    gProxyDeck.selectedIndex = 2;
  }
}
//////////////////////////////////////////////////////////////////////////
// this is a changed function (navigator.js) 
//////////////////////////////////////////////////////////////////////////
function BrowserLoadURL(aTriggeringEvent)
{
  var url = gURLBar.value;
  if (url.match(/^view-source:/)) {
    BrowserViewSourceOfURL(url.replace(/^view-source:/, ""), null, null);
  } 
  else {
    if (pref && pref.getBoolPref("browser.tabs.opentabfor.urlbar") &&
        getBrowser().localName == "tabbrowser" &&
        aTriggeringEvent && 'ctrlKey' in aTriggeringEvent &&
        aTriggeringEvent.ctrlKey) {
      var t = getBrowser().addTab(getShortcutOrURI(url)); // open link in new tab
      getBrowser().selectedTab = t;
    }
    else if (pref && pref.getBoolPref("multizilla.newtabfor.locationbar") && 
        getBrowser().localName == "tabbrowser") {
      var aTab = getBrowser().addTab(getShortcutOrURI(url)); // open link in new tab
      getBrowser().selectedTab = aTab;
    }
    else  
      loadURI(getShortcutOrURI(url));
    _content.focus();
  }
}
//////////////////////////////////////////////////////////////////////////
// this is a changed function (contentAreaUtils.js) to make spoofing work
//////////////////////////////////////////////////////////////////////////
function getReferrer(doc)
{
  var spoofing = readMyPref("multizilla.refspoof.spoofing", "int", 3);
  if (spoofing == 1)
    return(getDocumentReferrer(doc));
  var focusedWindow = doc.commandDispatcher.focusedWindow;
  var sourceURL = isDocumentFrame(focusedWindow) ? focusedWindow.location.href : focusedWindow._content.location.href;
  return(spoofReferrer(sourceURL, getDocumentReferrer(document)));
}
//////////////////////////////////////////////////////////////////////////
// this is a changed function (navigator.js) to make spoofing work
//////////////////////////////////////////////////////////////////////////
function loadURI(url, referrer)
{
  dump('\nurl = '+url);
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
  referrer = spoofReferrer(url, null)
  try {
    getWebNavigation().loadURI(url, nsIWebNavigation.LOAD_FLAGS_NONE, referrer, null, null);
  } catch (ex) {
    dump('\nerror: loadURI("'+url+'") failed');
  }
}
//////////////////////////////////////////////////////////////////////////
// modified function (navigator.js) to make groupsmarks load at startup
//////////////////////////////////////////////////////////////////////////
function LoadBookmarksCallback()
{
  try {
    if (!gBookmarksService)
      gBookmarksService = Components.classes["@mozilla.org/browser/bookmarks-service;1"]
                                    .getService(Components.interfaces.nsIBookmarksService);
    gBookmarksService.ReadBookmarks();
    // tickle personal toolbar to load personal toolbar items
    var personalToolbar = document.getElementById("NC:PersonalToolbarFolder");
    personalToolbar.builder.rebuild();
  } catch (e) {
  }
  // check if we need to load a groupmark at startup
  if (pref && pref.getIntPref("browser.startup.page") == 3 && 
      !document.documentElement.hasAttribute("chromehidden"))
    OpenBookmarkGroup(null, document.getElementById('BookmarksMenu').database);
}
//////////////////////////////////////////////////////////////////////////
// modified function (navigator.js) to make groupsmarks load at startup
//////////////////////////////////////////////////////////////////////////
function OpenBookmarkGroup(element, datasource, id)
{
  if (!datasource)
    return;
  if (element)
    id = element.getAttribute("id");
  else {
    id = pref.getComplexValue("multizilla.tabs.groupmark", 
                              Components.interfaces.nsISupportsWString).data;
    if (!id)
      return;
  }
  var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                          .getService(Components.interfaces.nsIRDFService);
  var resource = rdf.GetResource(id, true);
  OpenBookmarkGroupFromResource(resource, datasource, rdf);
}

