/****** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Initial Developer of the Original Code is Eelco van Kuik.
   -
   - Contributor(s):
   - Several developers
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK *****/
   
   
   var properties = {
	list 		: null,
	dsChecked 	: null,
	ds			: null,
	sc			: false,
	fields		: new Array('label', 'shortlabel', 'searchstring', 'encoding', 'context', 'method', 'defaultselected'),
	init : function () {
		
		//Load libraries
		const Include=new Components.Constructor('@mozilla.org/moz/jssubscript-loader;1','mozIJSSubScriptLoader');
		const gInc = new Include();
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfds.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsRdfLocator.js");
		gInc.loadSubScript("chrome://needlesearch/content/jslib/nsSniffer.js");
			
		//Make a reference to the list
		properties.list = opener.document.getElementById("needlesearch-editor-list");
		
		//And make it the datasource
		var aUri = 'file:///' + nsRdfLocator.getUri(true)
		properties.ds = new nsRdfds.RDFDataSource(aUri)
		
		properties.populate()
	},
	
		//Function to populate properties
	populate : function () {
		var checked, currentCatID, context, tmp
		
		if (properties.list.selectedItem.getAttribute("type") == 'item') {
			currentCatID = properties.list.selectedItem.getAttribute("id");
			document.getElementById("searchstring").value = properties.list.selectedItem.getAttribute("searchstring")
			document.getElementById("label").value = properties.list.selectedItem.getAttribute("label")
			document.getElementById("shortlabel").value = properties.list.selectedItem.getAttribute("shortlabel")
			document.getElementById("encoding").value = properties.list.selectedItem.getAttribute("encoding")
			document.getElementById("context").setAttribute("checked", (properties.list.selectedItem.getAttribute("context") == 'true'))
			document.getElementById("method").selectedIndex = (properties.list.selectedItem.getAttribute("method") == 'post')?1:0
			tmp = (properties.list.selectedItem.getAttribute("defaultselected") == 'true') ? true : false
			document.getElementById("defaultselected").setAttribute("checked", tmp)
		} 
	  
	  return false;
	  
	},
	
		//Save the properties
	save : function () {
		var currentNode, property, removevalue
	    //A node can only be removed when it is selected
	    aID = properties.list.selectedItem.getAttribute("id")
	    currentNode = properties.ds.getNode(aID);
		for (var i = 0; i < properties.fields.length; i++) {
			aElmnt = document.getElementById(properties.fields[i])
			if (aElmnt.nodeName == 'checkbox') {
				//Remove all other items with defaultselected
				aNewValue = (document.getElementById(properties.fields[i]).checked) ? 'true' : 'false'
				aOldValue = properties.list.selectedItem.getAttribute(properties.fields[i])
				
				if (properties.fields[i] == 'defaultselected') {
					
					var aRootNode	=	properties.ds.getNode(nsRdfds.baseURI) ;
					var children	=	aRootNode.getChildren()
					var child
					
					if (aOldValue != aNewValue && aNewValue == 'true') {
						
						//Then remove all the others
						while (children.hasMoreElements()) {
							child = children.getNext()
							
							child.removeTarget(nsRdfds.aXMLPath + "defaultselected", "true")
							child.removeTarget(nsRdfds.aXMLPath + "defaultselected", "false")
							
						}
						
						currentNode.addTarget(nsRdfds.aXMLPath + "defaultselected", "true")
						
					}
										
					
					properties.ds.save()
				} else {
					//For normal checkboxes
					currentNode.modifyTarget ( nsRdfds.aXMLPath + properties.fields[i] , aOldValue, aNewValue )
				}
				
			} else {
				currentNode.modifyTarget ( nsRdfds.aXMLPath + properties.fields[i] , properties.list.selectedItem.getAttribute(properties.fields[i]), document.getElementById(properties.fields[i]).value )
			}
			
		}
		
		properties.ds.save()
		properties.close()
	},
	
	close : function () {
		self.close()
	}
	
	

}