var weather_prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("weather.");

function initWeatherOptions() {

  if (weather_prefs.getPrefType("zipcode") != 0) {
    document.getElementById("zipcodeInput").setAttribute("value", weather_prefs.getCharPref("zipcode"));
  } else {
  document.getElementById("zipcodeInput").setAttribute("value", "");
  }

  if (weather_prefs.getPrefType("interval") != 0) {
  document.getElementById("refreshMinutes").setAttribute("value", weather_prefs.getCharPref("interval"));
  } else {
  document.getElementById("refreshMinutes").setAttribute("value", "15");
  }

  if (weather_prefs.getPrefType("refresh") != 0) {
    if (weather_prefs.getBoolPref("refresh")) {
      document.getElementById("refreshGroup").selectedItem = document.getElementById("refreshYes");
    } else {
      document.getElementById("refreshGroup").selectedItem = document.getElementById("refreshNo");
    }
  } else {
    document.getElementById("refreshGroup").selectedItem = document.getElementById("refreshYes");
  }

  setTimeout("window.sizeToContent()", 5);
}

function saveWeatherOptions() {
  weather_prefs.setCharPref("zipcode", document.getElementById("zipcodeInput").value);

  weather_prefs.setCharPref("interval", document.getElementById("refreshMinutes").value);

  if (document.getElementById("refreshGroup").selectedItem == document.getElementById("refreshYes")) {
    weather_prefs.setBoolPref("refresh", true);
  } else {
    weather_prefs.setBoolPref("refresh", false);
  }

  window.opener.setTimeout("initiateWeather()", 5);
}