#!/bin/bash 
# Nov 11 2015

. /etc/init.d/tc-functions
checknotroot

cd /tmp

exit_red() 
{
   echo "${RED}Error:$1  Exiting.${NORMAL}"
   sleep 5
   exit 1
}

SCE=flash11
TCEDIR="/etc/sysconfig/tcedir"
SCEDIR="$TCEDIR/sce"
EXTDIR="$TCEDIR/import/flash11"
IMPORTDIR="/etc/sysconfig/tcedir/import"
SRCNAME="install_flash_player_11_linux.i386.tar.gz"

[ -d "$TCEDIR"/import/flash11 ] && sudo rm -r "$TCEDIR"/import/flash11
if sudo busybox mount | grep "/tmp/sceflashtest" > /dev/null 2>&1; then
     sudo busybox umount /tmp/sceflashtest
fi
sudo mkdir -p "$EXTDIR"/usr/lib/mozilla/plugins
sudo mkdir -p "$EXTDIR"/usr/lib/opera/plugins
sudo mkdir -p "$EXTDIR"/usr/local/share/flash11
sudo mkdir -p /tmp/sceflashtest

DOWNLOAD=$(curl -s 'https://get.adobe.com/flashplayer/download/?installer=FP_11.2_for_other_Linux_32-bit_(.tar.gz)_-_NPAPI&standalone=1'  | grep -o 'https://fpdownload.adobe.com/get/flashplayer/pdc/11.2.*/install_flash_player_11_linux.i386.tar.gz')

if [ -f "$SCEDIR"/update/"$SCE".sce ]; then
	sudo busybox mount "$SCEDIR"/update/"$SCE".sce /tmp/sceflashtest
	VERFILE=/tmp/sceflashtest/usr/local/share/flash11/VERSION
elif sudo busybox mount | grep "/tmp/tcloop/$SCE " > /dev/null 2>&1; then
	VERFILE=/tmp/tcloop/"$SCE"/usr/local/share/flash11/VERSION
elif [ -f "$SCEDIR"/"$SCE".sce ]; then
	sudo busybox mount "$SCEDIR"/"$SCE".sce /tmp/sceflashtest
	VERFILE=/tmp/sceflashtest/usr/local/share/flash11/VERSION
fi

if [ -f "$VERFILE" ]; then
	VERNEW="$DOWNLOAD"
	VEROLD=`cat "$VERFILE"`
	if [ "$VERNEW" == "$VEROLD" ]; then
		echo "Your flash player is up to date.  Exiting."
		sleep 5
		exit 0
	fi
else 
	echo "flash11.sce is missing or needs to be updated.  Proceeding with update.."
	sleep 5
fi

[ -d "$EXTDIR"/usr/local/share/flash11 ] || sudo mkdir -p "$EXTDIR"/usr/local/share/flash11
echo "$DOWNLOAD" | sudo tee "$EXTDIR"/usr/local/share/flash11/VERSION

echo "${BLUE}Downloading Adobe Flash...${NORMAL}"

wget "$DOWNLOAD" > /dev/null 2>&1
[ -e $SRCNAME ] || exit_red "Downloading source."
echo "${GREEN}Done.${NORMAL}"
echo "${BLUE}Copying files and setting permissions...${NORMAL}"

busybox tar -zxf $SRCNAME libflashplayer.so || exit_red "Unpack source."

sudo cp libflashplayer.so "$EXTDIR"/usr/lib/mozilla/plugins/
cd "$EXTDIR"/usr/lib/opera/plugins
sudo ln -s /usr/lib/mozilla/plugins/libflashplayer.so libflashplayer.so
cd "$IMPORTDIR"
if [ -f "$TCEDIR"/sce/"$SCE".sce ] && busybox mount | grep " /tmp/tcloop/"$SCE" " > /dev/null 2>&1; then
	echo "${BLUE}Creating flash11.sce extension in "$SCEDIR"...${NORMAL}"
	sudo mksquashfs "$SCE" "$TCEDIR"/sce/update/"$SCE".sce -noappend > /dev/null 2>&1 || exit_red "Creating extension."
	cd "$SCEDIR"/update/
	sudo md5sum "$SCE".sce > "$SCE".sce.md5.txt
	cd "$IMPORTDIR"
	echo "${GREEN}Done.${NORMAL}"
else
	echo "${BLUE}Creating flash11.sce extension in "$SCEDIR"...${NORMAL}"
	sudo mksquashfs "$SCE" "$TCEDIR"/sce/"$SCE".sce -noappend > /dev/null 2>&1 || exit_red "Creating extension."
	cd "$SCEDIR"
	sudo md5sum "$SCE".sce > "$SCE".sce.md5.txt
	cd "$IMPORTDIR"
	echo "${BLUE}Loading flash11.sce extension...${NORMAL}"
	sce-load flash11
	echo "${GREEN}Done.${NORMAL}"
fi

if ! grep -wq "^$SCE$" "$TCEDIR"/sceboot.lst
then
	echo "$SCE" >> "$TCEDIR"/sceboot.lst
fi

cd /tmp

[ -f libflashplayer.so ] && sudo rm libflashplayer.so
[ -f install_flash_player_11_linux.i386.tar.gz ] && sudo rm install_flash_player_11_linux.i386.tar.gz
[ -d /tmp/sceflashtest ] && sudo rmdir /tmp/sceflashtest
if sudo busybox mount | grep "/tmp/sceflashtest" > /dev/null 2>&1; then
     sudo busybox umount /tmp/sceflashtest
fi


