/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, Composite.checkStyle(style));
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        this.drawBackground(gc, x, y, width, height, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    long gtk_button_press_event(long widget, long event) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_button_press_event(widget, event)) != 0L) {
            return result;
        }
        return super.gtk_button_press_event(widget, event);
    }

    long gtk_commit(long imcontext, long text) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_commit(imcontext, text)) != 0L) {
            return result;
        }
        return super.gtk_commit(imcontext, text);
    }

    long gtk_draw(long widget, long cairo) {
        boolean isFocus;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        long result = super.gtk_draw(widget, cairo);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    long gtk_expose_event(long widget, long event) {
        boolean isFocus;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        long result = super.gtk_expose_event(widget, event);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    long gtk_preedit_changed(long imcontext) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_preedit_changed(imcontext)) != 0L) {
            return result;
        }
        return super.gtk_preedit_changed(imcontext);
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, redrawAll, all, trim);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            int clientWidth = this.getClientWidth();
            x = clientWidth - width - x;
            destX = clientWidth - width - destX;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        long window = this.paintWindow();
        long visibleRegion = OS.GTK3 ? OS.gdk_window_get_visible_region(window) : OS.gdk_drawable_get_visible_region(window);
        GdkRectangle srcRect = new GdkRectangle();
        srcRect.x = x;
        srcRect.y = y;
        srcRect.width = width;
        srcRect.height = height;
        long copyRegion = OS.gdk_region_rectangle(srcRect);
        OS.gdk_region_intersect(copyRegion, visibleRegion);
        long invalidateRegion = OS.gdk_region_rectangle(srcRect);
        OS.gdk_region_subtract(invalidateRegion, visibleRegion);
        OS.gdk_region_offset(invalidateRegion, deltaX, deltaY);
        GdkRectangle copyRect = new GdkRectangle();
        OS.gdk_region_get_clipbox(copyRegion, copyRect);
        if (copyRect.width != 0 && copyRect.height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(x, y, width, height, false, false, false);
            this.redrawWidget(destX, destY, width, height, false, false, false);
        } else {
            GdkRectangle rect;
            boolean disjoint;
            if (OS.GTK3) {
                long cairo = OS.gdk_cairo_create(window);
                if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                    OS.gdk_cairo_set_source_window(cairo, window, 0, 0);
                } else {
                    Cairo.cairo_push_group(cairo);
                    OS.gdk_cairo_set_source_window(cairo, window, 0, 0);
                    Cairo.cairo_paint(cairo);
                    Cairo.cairo_pop_group_to_source(cairo);
                }
                double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, -deltaX, -deltaY};
                Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(cairo), matrix);
                Cairo.cairo_rectangle(cairo, copyRect.x + deltaX, copyRect.y + deltaY, copyRect.width, copyRect.height);
                Cairo.cairo_clip(cairo);
                Cairo.cairo_paint(cairo);
                Cairo.cairo_destroy(cairo);
            } else {
                long gdkGC = OS.gdk_gc_new(window);
                OS.gdk_gc_set_exposures(gdkGC, true);
                OS.gdk_draw_drawable(window, gdkGC, window, copyRect.x, copyRect.y, copyRect.x + deltaX, copyRect.y + deltaY, copyRect.width, copyRect.height);
                OS.g_object_unref(gdkGC);
            }
            boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                rect = new GdkRectangle();
                rect.x = x;
                rect.y = y;
                rect.width = width;
                rect.height = height;
                OS.gdk_region_union_with_rect(invalidateRegion, rect);
            } else {
                rect = new GdkRectangle();
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    rect.x = newX;
                    rect.y = y;
                    rect.width = Math.abs(deltaX);
                    rect.height = height;
                    OS.gdk_region_union_with_rect(invalidateRegion, rect);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    rect.x = x;
                    rect.y = newY;
                    rect.width = width;
                    rect.height = Math.abs(deltaY);
                    OS.gdk_region_union_with_rect(invalidateRegion, rect);
                }
            }
            OS.gdk_window_invalidate_region(window, invalidateRegion, all);
        }
        OS.gdk_region_destroy(visibleRegion);
        OS.gdk_region_destroy(copyRegion);
        OS.gdk_region_destroy(invalidateRegion);
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }

    void updateCaret() {
        long imHandle = this.imHandle();
        if (imHandle == 0L) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = this.caret.x;
        rect.y = this.caret.y;
        rect.width = this.caret.width;
        rect.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(imHandle, rect);
    }
}

