/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.update.util;

import it.sogei.rcp.update.Activator;
import it.sogei.rcp.update.properties.Messages;
import it.sogei.rcp.update.util.AccumulatingProgressMonitor;
import it.sogei.utilities.log4j.LogUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class P2Util {
    public static void checkForUpdates() {
        LogUtil.log((String)"P2Util", (int)2, (String)"Ricerca aggiornamenti...");
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(null);
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    P2Util.doCheckForUpdates((IProgressMonitor)new AccumulatingProgressMonitor(monitor, Display.getDefault()));
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    private static void doCheckForUpdates(IProgressMonitor monitor) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            Activator.log((IStatus)new Status(4, "it.sogei.rcp.update", "No provisioning agent found.  This application is not set up for updates."));
            return;
        }
        IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(reference);
        try {
            IStatus updateStatus = P2Util.checkForUpdates(agent, monitor);
            Activator.log(updateStatus);
            if (updateStatus.getCode() == 10000) {
                return;
            }
            if (updateStatus.getSeverity() != 4) {
                LogUtil.log((String)"P2Util", (int)2, (String)"Aggiornamenti installati. Riavvio in corso...");
                try {
                    Activator.needsStartup = true;
                }
                catch (Exception exception) {
                    LogUtil.log((String)"P2Util", (int)1, (String)"info non visualizata");
                }
            }
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.P2Util_CheckForUpdate, (int)200);
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 4) {
            ProvisioningJob job = operation.getProvisioningJob(monitor);
            if (job == null) {
                return new Status(4, "it.sogei.rcp.update", "ProvisioningJob could not be created - does this application support p2 software installation?");
            }
            status = job.runModal((IProgressMonitor)sub.newChild(100));
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
        }
        return status;
    }
}

