/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.InvocationDelegate;
import com.sun.java.browser.plugin2.liveconnect.v1.JavaNameSpace;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import sun.net.www.ParseUtil;
import sun.plugin.liveconnect.JavaScriptProtectionDomain;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.ArgumentHelper;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.JavaClass;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.client.MessagePassingJSObject;
import sun.plugin2.main.client.MessagePassingOneWayJSObject;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaReplyMessage;
import sun.plugin2.message.JavaScriptReleaseObjectMessage;
import sun.plugin2.message.Pipe;
import sun.plugin2.util.SystemUtil;

public class LiveConnectSupport {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static Pipe pipe;
    private static int jvmID;
    private static ReferenceQueue queue;
    private static volatile boolean shouldStop;
    private static Thread cleanupThread;
    private static Map refCounts;
    private static Vector bsoRefs;
    private static Map exportedObjectMap;
    private static Map objectIDMap;
    private static int nextObjectID;
    private static Map appletInfoMap;
    static /* synthetic */ Class class$netscape$javascript$JSObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    private LiveConnectSupport() {
    }

    public static void initialize(Pipe pipe, int n) {
        LiveConnectSupport.pipe = pipe;
        jvmID = n;
        cleanupThread = new BrowserSideObjectCleanupThread();
        cleanupThread.start();
    }

    public static void shutdown() {
        shouldStop = true;
        cleanupThread.interrupt();
    }

    public static synchronized void appletStarted(int n, Plugin2Manager plugin2Manager) {
        appletInfoMap.put(new Integer(n), new PerAppletInfo(n, plugin2Manager));
    }

    public static synchronized void appletStopped(int n) {
        PerAppletInfo perAppletInfo = (PerAppletInfo)appletInfoMap.remove(new Integer(n));
        if (perAppletInfo != null) {
            perAppletInfo.stop();
        }
    }

    public static Object exportObject(Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object) && !bl) {
            return object;
        }
        if (object instanceof MessagePassingJSObject) {
            return ((MessagePassingJSObject)object).getBrowserSideObject();
        }
        return LiveConnectSupport.exportRemoteObject(object, n, bl2);
    }

    public static Object importObject(Object object, int n) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof BrowserSideObject) {
            BrowserSideObject browserSideObject = (BrowserSideObject)object;
            MessagePassingJSObject messagePassingJSObject = new MessagePassingJSObject(browserSideObject, n, pipe);
            LiveConnectSupport.ref(browserSideObject, n);
            LiveConnectSupport.track(messagePassingJSObject);
            return messagePassingJSObject;
        }
        if (object instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)object);
        }
        throw new IllegalArgumentException("Unsupported argument type " + object.getClass().getName());
    }

    public static Object importOneWayJSObject(Object object, int n, Plugin2Manager plugin2Manager) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof BrowserSideObject) {
            BrowserSideObject browserSideObject = (BrowserSideObject)object;
            MessagePassingJSObject messagePassingJSObject = new MessagePassingJSObject(browserSideObject, n, pipe, plugin2Manager);
            MessagePassingOneWayJSObject messagePassingOneWayJSObject = new MessagePassingOneWayJSObject(messagePassingJSObject);
            LiveConnectSupport.ref(browserSideObject, n);
            LiveConnectSupport.track2(messagePassingOneWayJSObject);
            return messagePassingOneWayJSObject;
        }
        if (object instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)object);
        }
        throw new IllegalArgumentException("Unsupported argument type " + object.getClass().getName());
    }

    public static void doObjectOp(JavaObjectOpMessage javaObjectOpMessage) throws IOException {
        RemoteJavaObject remoteJavaObject = javaObjectOpMessage.getObject();
        PerAppletInfo perAppletInfo = LiveConnectSupport.getInfo(remoteJavaObject.getAppletID());
        if (perAppletInfo != null) {
            if (javaObjectOpMessage.getConversation() == null) {
                perAppletInfo.enqueue(javaObjectOpMessage);
            } else {
                perAppletInfo.doObjectOp(javaObjectOpMessage);
            }
        } else {
            pipe.send(new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, "Applet ID " + remoteJavaObject.getAppletID() + " is not registered in this JVM instance"));
        }
    }

    public static synchronized void releaseRemoteObject(RemoteJavaObject remoteJavaObject) {
        Integer n = new Integer(remoteJavaObject.getObjectID());
        Object v = objectIDMap.remove(n);
        if (v != null) {
            exportedObjectMap.remove(v);
        }
    }

    private static synchronized void ref(BrowserSideObject browserSideObject, int n) {
        BrowserSideObjectKey browserSideObjectKey = new BrowserSideObjectKey(browserSideObject, n);
        ReferenceCount referenceCount = (ReferenceCount)refCounts.get(browserSideObjectKey);
        if (referenceCount == null) {
            referenceCount = new ReferenceCount();
            refCounts.put(browserSideObjectKey, referenceCount);
        }
        referenceCount.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unref(BrowserSideObjectKey browserSideObjectKey) throws IOException {
        boolean bl = false;
        Class clazz = LiveConnectSupport.class;
        synchronized (clazz) {
            ReferenceCount referenceCount = (ReferenceCount)refCounts.get(browserSideObjectKey);
            if (referenceCount == null) {
                return;
            }
            if (referenceCount.unref() == 0) {
                refCounts.remove(browserSideObjectKey);
                bl = true;
            }
        }
        if (bl) {
            pipe.send(new JavaScriptReleaseObjectMessage(null, browserSideObjectKey.getObject(), browserSideObjectKey.getAppletID()));
        }
    }

    private static void track(MessagePassingJSObject messagePassingJSObject) {
        bsoRefs.add(new BrowserSideObjectReference(messagePassingJSObject, queue, new BrowserSideObjectKey(messagePassingJSObject.getBrowserSideObject(), messagePassingJSObject.getAppletID())));
    }

    private static void track2(MessagePassingOneWayJSObject messagePassingOneWayJSObject) {
        bsoRefs.add(new BrowserSideObjectReference(messagePassingOneWayJSObject, queue, new BrowserSideObjectKey(messagePassingOneWayJSObject.getBrowserSideObject(), messagePassingOneWayJSObject.getAppletID())));
    }

    private static synchronized RemoteJavaObject exportRemoteObject(Object object, int n, boolean bl) {
        RemoteJavaObject remoteJavaObject = (RemoteJavaObject)exportedObjectMap.get(object);
        if (remoteJavaObject != null && !LiveConnectSupport.isAppletRunning(remoteJavaObject.getAppletID())) {
            LiveConnectSupport.releaseRemoteObject(remoteJavaObject);
            remoteJavaObject = null;
        }
        if (remoteJavaObject == null) {
            int n2 = ++nextObjectID;
            remoteJavaObject = new RemoteJavaObject(jvmID, n, n2, bl);
            exportedObjectMap.put(object, remoteJavaObject);
            objectIDMap.put(new Integer(n2), object);
        }
        return remoteJavaObject;
    }

    private static synchronized Object importRemoteObject(RemoteJavaObject remoteJavaObject) {
        return objectIDMap.get(new Integer(remoteJavaObject.getObjectID()));
    }

    private static synchronized void releaseRemoteObjects(int n) {
        ArrayList<RemoteJavaObject> arrayList = new ArrayList<RemoteJavaObject>();
        Iterator<Object> iterator = exportedObjectMap.values().iterator();
        while (iterator.hasNext()) {
            RemoteJavaObject remoteJavaObject = (RemoteJavaObject)iterator.next();
            if (remoteJavaObject.getAppletID() != n) continue;
            arrayList.add(remoteJavaObject);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            LiveConnectSupport.releaseRemoteObject((RemoteJavaObject)iterator.next());
        }
    }

    private static synchronized PerAppletInfo getInfo(int n) {
        return (PerAppletInfo)appletInfoMap.get(new Integer(n));
    }

    private static boolean isAppletRunning(int n) {
        return LiveConnectSupport.getInfo(n) != null;
    }

    public static synchronized Bridge getBridge(Object object) {
        Iterator iterator = appletInfoMap.values().iterator();
        while (iterator.hasNext()) {
            PerAppletInfo perAppletInfo = (PerAppletInfo)iterator.next();
            if (!perAppletInfo.hostsApplet(object)) continue;
            return perAppletInfo.getBridge();
        }
        return null;
    }

    private static AccessControlContext createContext(URL uRL) {
        try {
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{LiveConnectSupport.getJSProtectionDomain(uRL)};
            return new AccessControlContext(protectionDomainArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ProtectionDomain getJSProtectionDomain(URL uRL) throws MalformedURLException {
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        Plugin2ClassLoader.addDefaultPermissions(permissionCollection);
        if (uRL != null) {
            Permission permission;
            String string = null;
            try {
                permission = uRL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                permission = null;
            }
            if (permission instanceof FilePermission) {
                string = permission.getName();
            } else if (permission == null && uRL.getProtocol().equals("file")) {
                string = uRL.getFile().replace('/', File.separatorChar);
                string = ParseUtil.decode(string);
            } else if (permission instanceof SocketPermission) {
                String string2 = uRL.getHost();
                if (string2 == null || string2.equals("")) {
                    try {
                        string2 = new URL(uRL.getFile()).getHost();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (string2 != null && !string2.equals("")) {
                    permissionCollection.add(new SocketPermission(string2, "connect,accept"));
                }
            }
            if (string != null) {
                if (string.endsWith(File.separator)) {
                    string = string + "-";
                } else {
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        string = string.substring(0, n + 1) + "-";
                    }
                }
                permissionCollection.add(new FilePermission(string, "read"));
            }
            if ("chrome".equals(uRL.getProtocol())) {
                CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
            }
        }
        return new JavaScriptProtectionDomain(permissionCollection);
    }

    private static String getOpName(int n) {
        switch (n) {
            case 1: {
                return "CALL_METHOD";
            }
            case 2: {
                return "GET_FIELD";
            }
            case 3: {
                return "SET_FIELD";
            }
            case 4: {
                return "HAS_FIELD";
            }
            case 5: {
                return "HAS_METHOD";
            }
            case 6: {
                return "HAS_FIELD_OR_METHOD";
            }
        }
        throw new IllegalArgumentException("Invalid operation kind " + n);
    }

    static {
        queue = new ReferenceQueue();
        refCounts = new HashMap();
        bsoRefs = new Vector();
        exportedObjectMap = new IdentityHashMap();
        objectIDMap = new HashMap();
        appletInfoMap = new HashMap();
    }

    private static class PerAppletInfo {
        private int appletID;
        private Plugin2Manager manager;
        private LiveConnectWorker worker;
        private BridgeImpl bridge;
        private boolean fetchedDocumentBase;
        private URL documentBase;
        private AccessControlContext context;
        private volatile boolean notifiedOfStart;
        private boolean liveconnectChecked = false;
        private boolean liveconnectPermissionGranted = false;
        private List invocationDelegates = Collections.synchronizedList(new ArrayList());
        private List conversionDelegates = Collections.synchronizedList(new ArrayList());
        private Map classes = new HashMap();
        private Set notJavaClasses = new HashSet();
        private static Map appletLiveconnectAllowedMap = Collections.synchronizedMap(new HashMap());

        public PerAppletInfo(int n, Plugin2Manager plugin2Manager) {
            this.appletID = n;
            this.manager = plugin2Manager;
            this.bridge = new BridgeImpl(this);
            this.register(new DefaultInvocationDelegate());
            this.register(new DefaultConversionDelegate());
            this.worker = new LiveConnectWorker();
            plugin2Manager.startWorkerThread("Applet " + n + " LiveConnect Worker Thread", this.worker);
        }

        public boolean hostsApplet(Object object) {
            return this.manager != null && this.manager.getApplet2Adapter().getApplet() == object;
        }

        public Bridge getBridge() {
            return this.bridge;
        }

        public void register(InvocationDelegate invocationDelegate) {
            this.invocationDelegates.add(0, invocationDelegate);
        }

        public void unregister(InvocationDelegate invocationDelegate) {
            this.invocationDelegates.remove(invocationDelegate);
        }

        public void register(ConversionDelegate conversionDelegate) {
            this.conversionDelegates.add(0, conversionDelegate);
        }

        public void unregister(ConversionDelegate conversionDelegate) {
            this.conversionDelegates.remove(conversionDelegate);
        }

        public int conversionCost(final Object object, final Object object2) {
            final int[] nArray = new int[1];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Iterator iterator = PerAppletInfo.this.conversionDelegates.iterator();
                    while (iterator.hasNext()) {
                        ConversionDelegate conversionDelegate = (ConversionDelegate)iterator.next();
                        int n = conversionDelegate.conversionCost(object, object2);
                        if (n < 0) continue;
                        nArray[0] = n;
                        return null;
                    }
                    nArray[0] = -1;
                    return null;
                }
            }, this.getContext());
            return nArray[0];
        }

        public Object convert(final Object object, final Object object2) throws Exception {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object[] objectArray = new Object[1];
                    Iterator iterator = PerAppletInfo.this.conversionDelegates.iterator();
                    while (iterator.hasNext()) {
                        ConversionDelegate conversionDelegate = (ConversionDelegate)iterator.next();
                        if (!conversionDelegate.convert(object, object2, objectArray)) continue;
                        return objectArray[0];
                    }
                    throw PerAppletInfo.inconvertible(object, object2);
                }
            }, this.getContext());
        }

        public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
            this.worker.enqueue(javaObjectOpMessage);
        }

        public void stop() {
            this.bridge.stop();
            this.worker.stop();
            LiveConnectSupport.releaseRemoteObjects(this.appletID);
        }

        public void doObjectOp(final JavaObjectOpMessage javaObjectOpMessage) throws IOException {
            JavaReplyMessage javaReplyMessage = null;
            if (DEBUG) {
                System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\"");
            }
            if (!this.isLiveconnectCallAllowed(javaObjectOpMessage)) {
                RemoteJavaObject remoteJavaObject = javaObjectOpMessage.getObject();
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, "Liveconnect call for Applet ID " + remoteJavaObject.getAppletID() + " is not allowed in this JVM instance");
                pipe.send(javaReplyMessage);
                return;
            }
            try {
                this.waitForAppletStartOrError();
                if (this.manager.hasErrorOccurred()) {
                    if (this.manager.getErrorMessage() != null) {
                        throw new RuntimeException(this.manager.getErrorMessage());
                    }
                    if (this.manager.getErrorException() != null) {
                        throw (IOException)new IOException().initCause(this.manager.getErrorException());
                    }
                }
                final Object object = LiveConnectSupport.importObject(javaObjectOpMessage.getObject(), this.appletID);
                final Object[] objectArray = javaObjectOpMessage.getArguments();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = LiveConnectSupport.importObject(objectArray[i], this.appletID);
                    }
                }
                Result result = null;
                final boolean bl = javaObjectOpMessage.getObject().isApplet();
                boolean bl2 = false;
                switch (javaObjectOpMessage.getOperationKind()) {
                    case 1: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                Result[] resultArray = new Result[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).invoke(javaObjectOpMessage.getMemberName(), object, objectArray, false, bl, resultArray)) {
                                }
                                return resultArray[0];
                            }
                        }, this.getContext());
                        if (result.value() != Void.TYPE) break;
                        bl2 = true;
                        result = null;
                        break;
                    }
                    case 2: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Result[] resultArray = new Result[1];
                                if (bl && "Packages".equals(javaObjectOpMessage.getMemberName())) {
                                    resultArray[0] = new Result(new JavaNameSpace(""), false);
                                } else {
                                    InvocationDelegate invocationDelegate;
                                    Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                    while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).getField(javaObjectOpMessage.getMemberName(), object, false, bl, resultArray)) {
                                    }
                                }
                                return resultArray[0];
                            }
                        }, this.getContext());
                        break;
                    }
                    case 3: {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).setField(javaObjectOpMessage.getMemberName(), object, objectArray[0], false, bl)) {
                                }
                                return null;
                            }
                        }, this.getContext());
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                boolean[] blArray;
                                block4: {
                                    InvocationDelegate invocationDelegate;
                                    Object object2;
                                    blArray = new boolean[1];
                                    boolean bl2 = false;
                                    if (bl) {
                                        if ("Packages".equals(javaObjectOpMessage.getMemberName())) {
                                            blArray[0] = true;
                                            bl2 = true;
                                        }
                                        if (((String)(object2 = javaObjectOpMessage.getMemberName().toLowerCase())).equals("width") || ((String)object2).equals("height")) {
                                            blArray[0] = false;
                                            bl2 = true;
                                        }
                                    }
                                    if (bl2) break block4;
                                    object2 = PerAppletInfo.this.invocationDelegates.iterator();
                                    while (object2.hasNext() && !(invocationDelegate = (InvocationDelegate)object2.next()).hasField(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                    }
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 5: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                InvocationDelegate invocationDelegate;
                                boolean[] blArray = new boolean[1];
                                Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).hasMethod(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 6: {
                        result = (Result)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                boolean[] blArray;
                                block2: {
                                    InvocationDelegate invocationDelegate;
                                    blArray = new boolean[1];
                                    boolean bl2 = false;
                                    if (bl && "Packages".equals(javaObjectOpMessage.getMemberName())) {
                                        blArray[0] = true;
                                        bl2 = true;
                                    }
                                    if (bl2) break block2;
                                    Iterator iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                    while (iterator.hasNext() && !(invocationDelegate = (InvocationDelegate)iterator.next()).hasFieldOrMethod(javaObjectOpMessage.getMemberName(), object, false, bl, blArray)) {
                                    }
                                }
                                return blArray[0] ? new Result(Boolean.TRUE, false) : new Result(Boolean.FALSE, false);
                            }
                        }, this.getContext());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error: unknown Java object operation " + javaObjectOpMessage.getOperationKind());
                    }
                }
                Object object2 = null;
                boolean bl3 = false;
                if (result != null) {
                    object2 = result.value();
                    bl3 = result.skipUnboxing();
                }
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), LiveConnectSupport.exportObject(object2, this.appletID, bl3, false), bl2, null);
                if (DEBUG) {
                    System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\": returning result " + object2);
                }
            }
            catch (Throwable throwable) {
                Object object;
                Exception exception;
                if (DEBUG) {
                    System.out.println("Exception occurred during " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " " + javaObjectOpMessage.getMemberName() + ":");
                    throwable.printStackTrace();
                }
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (exception instanceof InvocationTargetException && (object = ((InvocationTargetException)exception).getTargetException()) instanceof Exception) {
                    exception = (Exception)object;
                }
                object = exception.toString();
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, (String)object);
            }
            pipe.send(javaReplyMessage);
        }

        private boolean isLiveconnectCallAllowed(JavaObjectOpMessage javaObjectOpMessage) {
            Plugin2Manager plugin2Manager = this.manager;
            boolean bl = false;
            if (plugin2Manager != null) {
                boolean bl2 = plugin2Manager.isVMSecure();
                if (!bl2) {
                    Boolean bl3 = null;
                    if (this.liveconnectChecked) {
                        bl3 = new Boolean(this.liveconnectPermissionGranted);
                    } else {
                        String string = plugin2Manager.getAppletUniqueKey();
                        bl3 = (Boolean)appletLiveconnectAllowedMap.get(string);
                        if (bl3 == null) {
                            bl3 = new Boolean(this.getUserPermissionForLiveconnectCall(javaObjectOpMessage));
                            appletLiveconnectAllowedMap.put(string, bl3);
                            this.liveconnectChecked = true;
                            this.liveconnectPermissionGranted = bl3;
                        }
                    }
                    bl = bl3;
                } else {
                    bl = true;
                }
            }
            return bl;
        }

        private boolean getUserPermissionForLiveconnectCall(JavaObjectOpMessage javaObjectOpMessage) {
            String string = ResourceManager.getString((String)"javaws.ssv.title");
            String string2 = ResourceManager.getString((String)"liveconnect.insecurejvm.warning");
            String string3 = ResourceManager.getString((String)"common.continue_btn");
            String string4 = ResourceManager.getString((String)"common.cancel_btn");
            URL uRL = this.getDocumentBase();
            String string5 = this.manager.getName();
            AppInfo appInfo = new AppInfo();
            appInfo.setTitle(string5);
            appInfo.setFrom(uRL);
            ToolkitStore.getUI();
            int n = -1;
            UIFactory uIFactory = ToolkitStore.getUI();
            ToolkitStore.getUI();
            n = uIFactory.showMessageDialog(null, appInfo, 3, string, null, string2, null, string3, string4, null);
            ToolkitStore.getUI();
            return n == 0;
        }

        private AccessControlContext getContext() {
            if (this.context == null) {
                this.context = LiveConnectSupport.createContext(this.getDocumentBase());
            }
            return this.context;
        }

        private URL getDocumentBase() {
            if (!this.fetchedDocumentBase) {
                this.documentBase = this.manager.getDocumentBase();
                this.fetchedDocumentBase = true;
            }
            return this.documentBase;
        }

        private InvocationDelegate getDelegate(Object object, boolean bl) {
            if (object instanceof JavaNameSpace) {
                return new JavaNameSpaceDelegate();
            }
            if (bl) {
                return this.getJavaClass((Class)object);
            }
            return this.getJavaClass(object.getClass());
        }

        private synchronized JavaClass getJavaClass(Class clazz) {
            JavaClass javaClass = (JavaClass)this.classes.get(clazz);
            if (javaClass == null) {
                javaClass = new JavaClass(clazz, this.getBridge());
                this.classes.put(clazz, javaClass);
            }
            return javaClass;
        }

        private void waitForAppletStartOrError() throws IOException {
            if (this.manager.isForDummyApplet()) {
                return;
            }
            if (this.manager.getApplet2Adapter().isInstantiated() || this.manager.hasErrorOccurred()) {
                this.manager.waitUntilAppletStartDone();
                return;
            }
            throw new IOException("LiveConnect operation without existing applet");
        }

        private static IllegalArgumentException inconvertible(Object object, Object object2) {
            return new IllegalArgumentException("Object " + object + " can not be converted to " + object2);
        }

        private static IllegalArgumentException inconvertible(Class clazz, Class clazz2) {
            return PerAppletInfo.inconvertible(clazz, clazz2, null);
        }

        private static IllegalArgumentException inconvertible(Class clazz, Class clazz2, Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Class " + clazz.getName() + " can not be converted to " + clazz2.getName());
            if (exception != null) {
                illegalArgumentException.initCause(exception);
            }
            return illegalArgumentException;
        }

        private class LiveConnectWorker
        implements Runnable {
            private volatile boolean shouldStop;
            private Object lock = new Object();
            private LinkedList workQueue = new LinkedList();

            private LiveConnectWorker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
                Object object = this.lock;
                synchronized (object) {
                    this.workQueue.add(javaObjectOpMessage);
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                this.shouldStop = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Plugin2Manager.setCurrentManagerThreadLocal(PerAppletInfo.this.manager);
                try {
                    while (!this.shouldStop) {
                        Object object = this.lock;
                        synchronized (object) {
                            while (!this.shouldStop && this.workQueue.isEmpty()) {
                                try {
                                    this.lock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                        while (!this.shouldStop && !this.workQueue.isEmpty()) {
                            object = null;
                            Object object2 = this.lock;
                            synchronized (object2) {
                                object = (JavaObjectOpMessage)this.workQueue.removeFirst();
                            }
                            PerAppletInfo.this.doObjectOp((JavaObjectOpMessage)object);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        class JavaNameSpaceDelegate
        implements InvocationDelegate {
            JavaNameSpaceDelegate() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private FindClassResult findClassFromDelegates(String string) {
                FindClassResult findClassResult;
                block11: {
                    InvocationDelegate invocationDelegate;
                    Object object;
                    block9: {
                        Iterator iterator;
                        block10: {
                            if (string == null || string.equals("")) {
                                return null;
                            }
                            if (PerAppletInfo.this.notJavaClasses.contains(string)) {
                                return null;
                            }
                            findClassResult = null;
                            try {
                                object = null;
                                invocationDelegate = null;
                                iterator = PerAppletInfo.this.invocationDelegates.iterator();
                                while (iterator.hasNext()) {
                                    InvocationDelegate invocationDelegate2 = (InvocationDelegate)iterator.next();
                                    try {
                                        object = invocationDelegate2.findClass(string);
                                        if (object == null) continue;
                                        invocationDelegate = invocationDelegate2;
                                        break;
                                    }
                                    catch (Exception exception) {
                                    }
                                }
                                if (object != null) break block9;
                                iterator = null;
                                Object var9_8 = null;
                                if (findClassResult != null) break block10;
                                PerAppletInfo.this.notJavaClasses.add(string);
                            }
                            catch (Throwable throwable) {
                                Object var9_10 = null;
                                if (findClassResult == null) {
                                    PerAppletInfo.this.notJavaClasses.add(string);
                                }
                                throw throwable;
                            }
                        }
                        return iterator;
                    }
                    findClassResult = new FindClassResult(object, invocationDelegate);
                    Object var9_9 = null;
                    if (findClassResult != null) break block11;
                    PerAppletInfo.this.notJavaClasses.add(string);
                    {
                    }
                }
                return findClassResult;
            }

            private RuntimeException fail(String string, String string2) {
                return new RuntimeException("Delegate for \"" + string + "\" did not handle " + string2);
            }

            public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                FindClassResult findClassResult = this.findClassFromDelegates(string2);
                if (findClassResult == null) {
                    if ("toString".equalsIgnoreCase(string)) {
                        resultArray[0] = new Result("[Java Package \"" + string2 + "\"]", false);
                        return true;
                    }
                    throw new ClassNotFoundException(string2);
                }
                if (string.equals("<init>")) {
                    Object object2 = findClassResult.delegate.newInstance(findClassResult.clazz, objectArray);
                    if (object2 == null) {
                        throw this.fail(string2, "invocation of constructor");
                    }
                    resultArray[0] = new Result(object2, true);
                } else if (!findClassResult.delegate.invoke(string, findClassResult.clazz, objectArray, true, bl2, resultArray)) {
                    throw this.fail(string2, "invocation of static method \"" + string + "\"");
                }
                return true;
            }

            public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                FindClassResult findClassResult = this.findClassFromDelegates(string2);
                if (findClassResult != null) {
                    if (!findClassResult.delegate.getField(string, findClassResult.clazz, true, bl2, resultArray)) {
                        throw this.fail(string2, "fetch of static field \"" + string + "\"");
                    }
                } else {
                    JavaNameSpace javaNameSpace2 = null;
                    javaNameSpace2 = string2 == null || string2.equals("") ? new JavaNameSpace(string) : new JavaNameSpace(string2 + "." + string);
                    resultArray[0] = new Result(javaNameSpace2, false);
                }
                return true;
            }

            public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                FindClassResult findClassResult = this.findClassFromDelegates(string2);
                if (findClassResult != null) {
                    if (!findClassResult.delegate.setField(string, findClassResult.clazz, object2, true, bl2)) {
                        throw this.fail(string2, "fetch of static field \"" + string + "\"");
                    }
                } else {
                    throw new UnsupportedOperationException("Can not perform a setField operation on a JavaNameSpace");
                }
                return true;
            }

            public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                try {
                    FindClassResult findClassResult = this.findClassFromDelegates(string2);
                    if (findClassResult != null) {
                        if (!findClassResult.delegate.hasField(string, findClassResult.clazz, true, bl2, blArray)) {
                            throw this.fail(string2, "hasField query for static field \"" + string + "\"");
                        }
                    } else {
                        blArray[0] = !"toString".equalsIgnoreCase(string);
                    }
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Exception occurred during JavaNameSpace hasField operation:");
                        exception.printStackTrace();
                    }
                    blArray[0] = true;
                }
                return true;
            }

            public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                try {
                    FindClassResult findClassResult = this.findClassFromDelegates(string2);
                    if (findClassResult != null) {
                        if (!findClassResult.delegate.hasMethod(string, findClassResult.clazz, true, bl2, blArray)) {
                            throw this.fail(string2, "hasMethod query for static method \"" + string + "\"");
                        }
                    } else {
                        blArray[0] = "toString".equalsIgnoreCase(string);
                    }
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Exception occurred during JavaNameSpace hasMethod operation:");
                        exception.printStackTrace();
                    }
                    blArray[0] = false;
                }
                return true;
            }

            public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                this.hasField(string, object, bl, bl2, blArray);
                if (!blArray[0]) {
                    this.hasMethod(string, object, bl, bl2, blArray);
                }
                return true;
            }

            public Object findClass(String string) {
                throw new UnsupportedOperationException("Should not call this");
            }

            public Object newInstance(Object object, Object[] objectArray) throws Exception {
                throw new UnsupportedOperationException("Should not call this");
            }

            class FindClassResult {
                Object clazz;
                InvocationDelegate delegate;

                FindClassResult(Object object, InvocationDelegate invocationDelegate) {
                    this.clazz = object;
                    this.delegate = invocationDelegate;
                }
            }
        }

        class DefaultConversionDelegate
        implements ConversionDelegate {
            private Class jsObjectClass = class$netscape$javascript$JSObject == null ? (class$netscape$javascript$JSObject = LiveConnectSupport.class$("netscape.javascript.JSObject")) : class$netscape$javascript$JSObject;
            private static final int TOSTRING_CONVERSION_PENALTY = 50;
            private static final int JSOBJECT_CONVERSION_PENALTY = 2500;

            DefaultConversionDelegate() {
            }

            public int conversionCost(Object object, Object object2) {
                if (!(object2 instanceof Class)) {
                    return -1;
                }
                Class clazz = (Class)object2;
                if (object == null) {
                    if (clazz.isPrimitive()) {
                        return -1;
                    }
                    return 0;
                }
                Class<?> clazz2 = object.getClass();
                if (clazz2 == clazz || clazz == this.jsObjectClass && clazz.isAssignableFrom(clazz2)) {
                    return 0;
                }
                if (clazz.isAssignableFrom(clazz2)) {
                    return this.conversionDistance(clazz2, clazz);
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) && this.canConvert((JSObject)object, clazz)) {
                    return 2500;
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) || this.jsObjectClass.isAssignableFrom(clazz)) {
                    return -1;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = LiveConnectSupport.class$("java.lang.String")) : class$java$lang$String)) {
                    return 50;
                }
                if (clazz.isPrimitive()) {
                    clazz = this.getBoxingClass(clazz);
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = LiveConnectSupport.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    if (clazz == clazz2) {
                        return 0;
                    }
                    if (clazz2 == (class$java$lang$String == null ? (class$java$lang$String = LiveConnectSupport.class$("java.lang.String")) : class$java$lang$String) || (class$java$lang$Number == null ? (class$java$lang$Number = LiveConnectSupport.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz2) || clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        return 1;
                    }
                }
                return -1;
            }

            public boolean convert(Object object, Object object2, Object[] objectArray) throws Exception {
                if (object == null) {
                    return true;
                }
                if (!(object2 instanceof Class)) {
                    throw PerAppletInfo.inconvertible(object, object2);
                }
                Class clazz = (Class)object2;
                Class<?> clazz2 = object.getClass();
                if (clazz.isAssignableFrom(clazz2)) {
                    objectArray[0] = object;
                    return true;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = LiveConnectSupport.class$("java.lang.String")) : class$java$lang$String)) {
                    if (object instanceof Number) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance();
                        try {
                            objectArray[0] = numberFormat.parse(object.toString()).toString();
                            return true;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    objectArray[0] = object.toString();
                    return true;
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) && clazz.isArray()) {
                    try {
                        JSObject jSObject = (JSObject)object;
                        Class<?> clazz3 = clazz.getComponentType();
                        int n = ((Number)jSObject.getMember("length")).intValue();
                        Object object3 = Array.newInstance(clazz3, n);
                        Object[] objectArray2 = new Object[1];
                        for (int i = 0; i < n; ++i) {
                            Object object4 = null;
                            try {
                                object4 = jSObject.getSlot(i);
                            }
                            catch (JSException jSException) {
                                // empty catch block
                            }
                            if (object4 == null) continue;
                            this.convert(object4, clazz3, objectArray2);
                            Array.set(object3, i, objectArray2[0]);
                        }
                        objectArray[0] = object3;
                        return true;
                    }
                    catch (Exception exception) {
                        throw PerAppletInfo.inconvertible(clazz2, clazz, exception);
                    }
                }
                if (this.jsObjectClass.isAssignableFrom(clazz2) || this.jsObjectClass.isAssignableFrom(clazz)) {
                    throw PerAppletInfo.inconvertible(clazz2, clazz);
                }
                if (clazz.isPrimitive() || (class$java$lang$Number == null ? (class$java$lang$Number = LiveConnectSupport.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    boolean bl = object instanceof Number;
                    if (!(bl || object instanceof String || object instanceof Character || object instanceof Boolean)) {
                        throw PerAppletInfo.inconvertible(clazz2, clazz);
                    }
                    if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        if (clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                            objectArray[0] = object;
                            return true;
                        }
                        if (bl) {
                            double d = ((Number)object).doubleValue();
                            objectArray[0] = Double.isNaN(d) || d == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                            return true;
                        }
                        objectArray[0] = ((String)object).length() == 0 ? Boolean.FALSE : Boolean.TRUE;
                        return true;
                    }
                    if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                        if (clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Byte(((Number)object).byteValue()) : Byte.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short)) {
                        if (clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Short(((Number)object).shortValue()) : Short.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        if (clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Integer(((Number)object).intValue()) : Integer.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = LiveConnectSupport.class$("java.lang.Long")) : class$java$lang$Long)) {
                        if (clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = LiveConnectSupport.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Long(((Number)object).longValue()) : Long.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = LiveConnectSupport.class$("java.lang.Float")) : class$java$lang$Float)) {
                        if (clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = LiveConnectSupport.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = LiveConnectSupport.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Float(((Number)object).floatValue()) : Float.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = LiveConnectSupport.class$("java.lang.Double")) : class$java$lang$Double)) {
                        if (clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = LiveConnectSupport.class$("java.lang.Double")) : class$java$lang$Double) || clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = LiveConnectSupport.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = LiveConnectSupport.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            objectArray[0] = object;
                            return true;
                        }
                        objectArray[0] = bl ? new Double(((Number)object).doubleValue()) : Double.valueOf((String)object);
                        return true;
                    }
                    if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character)) {
                        objectArray[0] = bl ? new Character((char)((Number)object).shortValue()) : new Character((char)Short.decode((String)object).shortValue());
                        return true;
                    }
                }
                throw PerAppletInfo.inconvertible(clazz2, clazz);
            }

            private boolean canConvert(JSObject jSObject, Class clazz) {
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = LiveConnectSupport.class$("java.lang.String")) : class$java$lang$String)) {
                    return true;
                }
                if (clazz.isArray()) {
                    try {
                        jSObject.getMember("length");
                        return true;
                    }
                    catch (JSException jSException) {
                        // empty catch block
                    }
                }
                return false;
            }

            private int conversionDistance(Class clazz, Class clazz2) {
                if (clazz2.isInterface() || clazz2.isArray()) {
                    return 1;
                }
                int n = 0;
                while (clazz != null && clazz != clazz2) {
                    ++n;
                    clazz = clazz.getSuperclass();
                }
                if (clazz != clazz2) {
                    return 1;
                }
                return n;
            }

            private Class getBoxingClass(Class clazz) {
                if (clazz == Boolean.TYPE) {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = LiveConnectSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                if (clazz == Byte.TYPE) {
                    return class$java$lang$Byte == null ? (class$java$lang$Byte = LiveConnectSupport.class$("java.lang.Byte")) : class$java$lang$Byte;
                }
                if (clazz == Short.TYPE) {
                    return class$java$lang$Short == null ? (class$java$lang$Short = LiveConnectSupport.class$("java.lang.Short")) : class$java$lang$Short;
                }
                if (clazz == Character.TYPE) {
                    return class$java$lang$Character == null ? (class$java$lang$Character = LiveConnectSupport.class$("java.lang.Character")) : class$java$lang$Character;
                }
                if (clazz == Integer.TYPE) {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = LiveConnectSupport.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                if (clazz == Long.TYPE) {
                    return class$java$lang$Long == null ? (class$java$lang$Long = LiveConnectSupport.class$("java.lang.Long")) : class$java$lang$Long;
                }
                if (clazz == Float.TYPE) {
                    return class$java$lang$Float == null ? (class$java$lang$Float = LiveConnectSupport.class$("java.lang.Float")) : class$java$lang$Float;
                }
                if (clazz == Double.TYPE) {
                    return class$java$lang$Double == null ? (class$java$lang$Double = LiveConnectSupport.class$("java.lang.Double")) : class$java$lang$Double;
                }
                throw new IllegalArgumentException("Not a primitive type class");
            }
        }

        class DefaultInvocationDelegate
        implements InvocationDelegate {
            DefaultInvocationDelegate() {
            }

            public boolean invoke(String string, Object object, Object[] objectArray, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.invoke(string, bl ? null : object, objectArray, false, bl2, resultArray);
            }

            public boolean getField(String string, Object object, boolean bl, boolean bl2, Result[] resultArray) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.getField(string, bl ? null : object, false, bl2, resultArray);
            }

            public boolean setField(String string, Object object, Object object2, boolean bl, boolean bl2) throws Exception {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.setField(string, bl ? null : object, object2, false, bl2);
            }

            public boolean hasField(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasField(string, bl ? null : object, false, bl2, blArray);
            }

            public boolean hasMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasMethod(string, bl ? null : object, false, bl2, blArray);
            }

            public boolean hasFieldOrMethod(String string, Object object, boolean bl, boolean bl2, boolean[] blArray) {
                InvocationDelegate invocationDelegate = PerAppletInfo.this.getDelegate(object, bl);
                return invocationDelegate.hasFieldOrMethod(string, bl ? null : object, false, bl2, blArray);
            }

            public Object findClass(String string) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(string, false, classLoader);
                }
                catch (ClassFormatError classFormatError) {
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
            }

            public Object newInstance(Object object, Object[] objectArray) throws Exception {
                JavaClass javaClass = PerAppletInfo.this.getJavaClass((Class)object);
                return javaClass.newInstance(null, objectArray);
            }
        }
    }

    private static class BridgeImpl
    implements Bridge {
        private volatile PerAppletInfo info;

        private BridgeImpl(PerAppletInfo perAppletInfo) {
            this.info = perAppletInfo;
        }

        public void register(InvocationDelegate invocationDelegate) {
            this.getInfo().register(invocationDelegate);
        }

        public void unregister(InvocationDelegate invocationDelegate) {
            this.getInfo().unregister(invocationDelegate);
        }

        public void register(ConversionDelegate conversionDelegate) {
            this.getInfo().register(conversionDelegate);
        }

        public void unregister(ConversionDelegate conversionDelegate) {
            this.getInfo().unregister(conversionDelegate);
        }

        public int conversionCost(Object object, Object object2) {
            return this.getInfo().conversionCost(object, object2);
        }

        public Object convert(Object object, Object object2) throws Exception {
            return this.getInfo().convert(object, object2);
        }

        public void stop() {
            this.info = null;
        }

        private PerAppletInfo getInfo() {
            PerAppletInfo perAppletInfo = this.info;
            if (perAppletInfo == null) {
                throw new IllegalStateException("Applet has already terminated");
            }
            return perAppletInfo;
        }
    }

    private static class ReferenceCount {
        private int count = 0;

        ReferenceCount() {
        }

        public void ref() {
            ++this.count;
        }

        public int unref() {
            --this.count;
            return this.count;
        }
    }

    private static class BrowserSideObjectReference
    extends PhantomReference {
        private BrowserSideObjectKey objectKey;

        public BrowserSideObjectReference(Object object, ReferenceQueue referenceQueue, BrowserSideObjectKey browserSideObjectKey) {
            super(object, referenceQueue);
            this.objectKey = browserSideObjectKey;
        }

        public BrowserSideObjectKey getObjectKey() {
            return this.objectKey;
        }
    }

    private static class BrowserSideObjectCleanupThread
    extends Thread {
        public BrowserSideObjectCleanupThread() {
            super("Browser Side Object Cleanup Thread");
        }

        public void run() {
            while (!shouldStop) {
                try {
                    if (DEBUG) {
                        Trace.println((String)"Waiting to GC browser side object ...", (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    BrowserSideObjectReference browserSideObjectReference = (BrowserSideObjectReference)queue.remove();
                    if (DEBUG) {
                        Trace.println((String)("About to GC browser side object " + browserSideObjectReference.getObjectKey().getObject().getNativeObjectReference()), (TraceLevel)TraceLevel.LIVECONNECT);
                    }
                    bsoRefs.remove(browserSideObjectReference);
                    LiveConnectSupport.unref(browserSideObjectReference.getObjectKey());
                }
                catch (IOException iOException) {
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static class BrowserSideObjectKey {
        private BrowserSideObject object;
        private int appletID;

        public BrowserSideObjectKey(BrowserSideObject browserSideObject, int n) {
            this.object = browserSideObject;
            this.appletID = n;
        }

        public BrowserSideObject getObject() {
            return this.object;
        }

        public int getAppletID() {
            return this.appletID;
        }

        public int hashCode() {
            return this.object.hashCode() ^ this.appletID;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            BrowserSideObjectKey browserSideObjectKey = (BrowserSideObjectKey)object;
            return this.object.equals(browserSideObjectKey.object) && this.appletID == browserSideObjectKey.appletID;
        }
    }
}

