/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringQuoteUtil {
    private static final boolean DEBUG = false;

    private static boolean isEscape(char c) {
        return c == '\\';
    }

    private static boolean isQuote(char c) {
        return c == '\"';
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    private static boolean needsQuote(String string) {
        return string.indexOf(32) != -1 || string.indexOf(9) != -1 || string.indexOf(34) != -1;
    }

    private static boolean needsQuote(StringBuffer stringBuffer) {
        return StringQuoteUtil.needsQuote(stringBuffer.toString());
    }

    public static final String quote(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.quote(new StringBuffer(string)).toString();
    }

    public static final StringBuffer quote(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = stringBuffer.length();
        stringBuffer2.append("\"");
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (i == n - 1 && c == '\\') continue;
            if (c == '\"') {
                stringBuffer2.append('\\');
            }
            stringBuffer2.append(c);
        }
        stringBuffer2.append("\"");
        return stringBuffer2;
    }

    private static int digestNextQuote(StringBuffer stringBuffer, int n, StringBuffer stringBuffer2, boolean bl, boolean bl2) {
        int n2;
        if (stringBuffer == null) {
            return -1;
        }
        int n3 = stringBuffer.length();
        if (n > n3 - 1) {
            return -1;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (n2 = n; n2 < n3; ++n2) {
            char c = stringBuffer.charAt(n2);
            if (n4 < 0) {
                if (StringQuoteUtil.isQuote(c)) {
                    n4 = n2;
                    if (null == stringBuffer2 || bl) continue;
                    stringBuffer2.append(c);
                    continue;
                }
                if (null == stringBuffer2 || n2 == n3 - 1 && c == '\\') continue;
                stringBuffer2.append(c);
                continue;
            }
            if (StringQuoteUtil.isEscape(c)) {
                if (n5 >= 0) {
                    n5 = -1;
                    if (null == stringBuffer2) continue;
                    if (!bl) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append('\\');
                    continue;
                }
                n5 = n2;
                continue;
            }
            if (StringQuoteUtil.isQuote(c)) {
                if (n5 >= 0) {
                    n5 = -1;
                    int n7 = n6 = n6 >= 0 ? -1 : n2;
                    if (null == stringBuffer2) continue;
                    if (!bl) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append('\"');
                    continue;
                }
                if (null != stringBuffer2 && !bl) {
                    stringBuffer2.append(c);
                }
                if (bl2) {
                    stringBuffer.delete(n4, n2 + 1);
                    return n4;
                }
                return n2 + 1;
            }
            if (n5 >= 0) {
                n5 = -1;
                if (null != stringBuffer2) {
                    stringBuffer2.append('\\');
                }
            }
            if (null == stringBuffer2) continue;
            stringBuffer2.append(c);
        }
        if (n6 >= 0) {
            if (n4 >= 0) {
                if (null != stringBuffer2) {
                    if (!bl) {
                        stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                    }
                    stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
                }
                return n3;
            }
            throw new IllegalArgumentException("unclosed inner quote: <" + stringBuffer.substring(n6, n3).toString() + ">\n\t(innerQuoteStart: " + n6 + ", scanPos: " + n2 + ", len: " + n3 + ")\n\tres: " + (stringBuffer2 != null ? stringBuffer2.toString() : null));
        }
        if (n4 >= 0) {
            throw new IllegalArgumentException("unclosed string literal: <" + stringBuffer.substring(n4, n3).toString() + ">\n\t(quoteStart: " + n4 + ", scanPos: " + n2 + ", len: " + n3 + ")\n\tres: " + (stringBuffer2 != null ? stringBuffer2.toString() : null));
        }
        return -1;
    }

    public static String unquoteIfEnclosedInQuotes(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.unquoteIfEnclosedInQuotes(new StringBuffer(string)).toString();
    }

    public static StringBuffer unquoteIfEnclosedInQuotes(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        int n = stringBuffer.length();
        if (n < 2) {
            return stringBuffer;
        }
        if (StringQuoteUtil.isQuote(stringBuffer.charAt(0)) && StringQuoteUtil.isQuote(stringBuffer.charAt(n - 1))) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            while ((n2 = StringQuoteUtil.digestNextQuote(stringBuffer, n2, stringBuffer2, true, false)) >= 0) {
                ++n3;
            }
            if (n3 == 1) {
                return stringBuffer2;
            }
        }
        return stringBuffer;
    }

    public static String unquote(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.unquote(new StringBuffer(string)).toString();
    }

    public static StringBuffer unquote(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while ((n = StringQuoteUtil.digestNextQuote(stringBuffer, n, stringBuffer2, true, false)) >= 0) {
        }
        return stringBuffer2;
    }

    private static String removeQuotedPart(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.removeQuotedPart(new StringBuffer(string)).toString();
    }

    private static StringBuffer removeQuotedPart(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while ((n = StringQuoteUtil.digestNextQuote(stringBuffer, n, null, false, true)) >= 0) {
        }
        return stringBuffer;
    }

    public static String quoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        return StringQuoteUtil.quoteIfNeeded(new StringBuffer(string)).toString();
    }

    public static final StringBuffer quoteIfNeeded(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        if (!StringQuoteUtil.needsQuote(stringBuffer)) {
            return stringBuffer;
        }
        int n = stringBuffer.length();
        if (n < 2) {
            return StringQuoteUtil.quote(stringBuffer);
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        int n2 = 0;
        boolean bl = false;
        while ((n2 = StringQuoteUtil.digestNextQuote(stringBuffer2, n2, null, false, true)) >= 0) {
        }
        if (StringQuoteUtil.needsQuote(stringBuffer2)) {
            return StringQuoteUtil.quote(stringBuffer);
        }
        return stringBuffer;
    }

    public static List getCommandLineArgs(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = stringBuffer.charAt(n);
            if (!bl) {
                if (stringBuffer2 != null) {
                    throw new IllegalArgumentException("ooops");
                }
                if (StringQuoteUtil.isWhiteSpace(c)) continue;
                bl = true;
                stringBuffer2 = new StringBuffer();
                --n;
                continue;
            }
            if (stringBuffer2 == null) {
                throw new IllegalArgumentException("ooops");
            }
            if (StringQuoteUtil.isWhiteSpace(c)) {
                bl = false;
            } else if (StringQuoteUtil.isQuote(c)) {
                int n3 = StringQuoteUtil.digestNextQuote(stringBuffer, n, stringBuffer2, true, false);
                if (n < 0) {
                    throw new IllegalArgumentException("Quote Error: " + n + ".." + n3 + ", size: " + n2 + ",\n\t input: " + stringBuffer + ",\n\tincomplete argument: " + stringBuffer2);
                }
                n = n3 - 1;
            } else {
                stringBuffer2.append(c);
            }
            if (bl && n != n2 - 1) continue;
            arrayList.add(stringBuffer2.toString());
            bl = false;
            stringBuffer2 = null;
        }
        if (stringBuffer2 != null) {
            throw new IllegalArgumentException("Quote Error: at end: " + n + ", size: " + n2 + ",\n\t input: " + stringBuffer + ",\n\t incomplete argument: " + stringBuffer2);
        }
        return arrayList;
    }

    public static String getStringByCommandList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            String string = (String)iterator.next();
            stringBuffer.append(StringQuoteUtil.quoteIfNeeded(string));
        }
        return stringBuffer.toString();
    }
}

