/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import sun.awt.geom.Curve;

public abstract class CubicCurve2D
implements Shape,
Cloneable {
    protected CubicCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX1();

    public abstract double getCtrlY1();

    public abstract Point2D getCtrlP1();

    public abstract double getCtrlX2();

    public abstract double getCtrlY2();

    public abstract Point2D getCtrlP2();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public void setCurve(double[] dArray, int n) {
        this.setCurve(dArray[n + 0], dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5], dArray[n + 6], dArray[n + 7]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n) {
        this.setCurve(point2DArray[n + 0].getX(), point2DArray[n + 0].getY(), point2DArray[n + 1].getX(), point2DArray[n + 1].getY(), point2DArray[n + 2].getX(), point2DArray[n + 2].getY(), point2DArray[n + 3].getX(), point2DArray[n + 3].getY());
    }

    public void setCurve(CubicCurve2D cubicCurve2D) {
        this.setCurve(cubicCurve2D.getX1(), cubicCurve2D.getY1(), cubicCurve2D.getCtrlX1(), cubicCurve2D.getCtrlY1(), cubicCurve2D.getCtrlX2(), cubicCurve2D.getCtrlY2(), cubicCurve2D.getX2(), cubicCurve2D.getY2());
    }

    public static double getFlatnessSq(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.max(Line2D.ptSegDistSq(d, d2, d7, d8, d3, d4), Line2D.ptSegDistSq(d, d2, d7, d8, d5, d6));
    }

    public static double getFlatness(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.sqrt(CubicCurve2D.getFlatnessSq(d, d2, d3, d4, d5, d6, d7, d8));
    }

    public static double getFlatnessSq(double[] dArray, int n) {
        return CubicCurve2D.getFlatnessSq(dArray[n + 0], dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5], dArray[n + 6], dArray[n + 7]);
    }

    public static double getFlatness(double[] dArray, int n) {
        return CubicCurve2D.getFlatness(dArray[n + 0], dArray[n + 1], dArray[n + 2], dArray[n + 3], dArray[n + 4], dArray[n + 5], dArray[n + 6], dArray[n + 7]);
    }

    public double getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return CubicCurve2D.getFlatness(this.getX1(), this.getY1(), this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
    }

    public void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2) {
        CubicCurve2D.subdivide(this, cubicCurve2D, cubicCurve2D2);
    }

    public static void subdivide(CubicCurve2D cubicCurve2D, CubicCurve2D cubicCurve2D2, CubicCurve2D cubicCurve2D3) {
        double d = cubicCurve2D.getX1();
        double d2 = cubicCurve2D.getY1();
        double d3 = cubicCurve2D.getCtrlX1();
        double d4 = cubicCurve2D.getCtrlY1();
        double d5 = cubicCurve2D.getCtrlX2();
        double d6 = cubicCurve2D.getCtrlY2();
        double d7 = cubicCurve2D.getX2();
        double d8 = cubicCurve2D.getY2();
        double d9 = (d3 + d5) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        d3 = (d + d3) / 2.0;
        d4 = (d2 + d4) / 2.0;
        d5 = (d7 + d5) / 2.0;
        d6 = (d8 + d6) / 2.0;
        double d11 = (d3 + d9) / 2.0;
        double d12 = (d4 + d10) / 2.0;
        double d13 = (d5 + d9) / 2.0;
        double d14 = (d6 + d10) / 2.0;
        d9 = (d11 + d13) / 2.0;
        d10 = (d12 + d14) / 2.0;
        if (cubicCurve2D2 != null) {
            cubicCurve2D2.setCurve(d, d2, d3, d4, d11, d12, d9, d10);
        }
        if (cubicCurve2D3 != null) {
            cubicCurve2D3.setCurve(d9, d10, d13, d14, d5, d6, d7, d8);
        }
    }

    public static void subdivide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d = dArray[n + 0];
        double d2 = dArray[n + 1];
        double d3 = dArray[n + 2];
        double d4 = dArray[n + 3];
        double d5 = dArray[n + 4];
        double d6 = dArray[n + 5];
        double d7 = dArray[n + 6];
        double d8 = dArray[n + 7];
        if (dArray2 != null) {
            dArray2[n2 + 0] = d;
            dArray2[n2 + 1] = d2;
        }
        if (dArray3 != null) {
            dArray3[n3 + 6] = d7;
            dArray3[n3 + 7] = d8;
        }
        d = (d + d3) / 2.0;
        d2 = (d2 + d4) / 2.0;
        d7 = (d7 + d5) / 2.0;
        d8 = (d8 + d6) / 2.0;
        double d9 = (d3 + d5) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        d3 = (d + d9) / 2.0;
        d4 = (d2 + d10) / 2.0;
        d5 = (d7 + d9) / 2.0;
        d6 = (d8 + d10) / 2.0;
        d9 = (d3 + d5) / 2.0;
        d10 = (d4 + d6) / 2.0;
        if (dArray2 != null) {
            dArray2[n2 + 2] = d;
            dArray2[n2 + 3] = d2;
            dArray2[n2 + 4] = d3;
            dArray2[n2 + 5] = d4;
            dArray2[n2 + 6] = d9;
            dArray2[n2 + 7] = d10;
        }
        if (dArray3 != null) {
            dArray3[n3 + 0] = d9;
            dArray3[n3 + 1] = d10;
            dArray3[n3 + 2] = d5;
            dArray3[n3 + 3] = d6;
            dArray3[n3 + 4] = d7;
            dArray3[n3 + 5] = d8;
        }
    }

    public static int solveCubic(double[] dArray) {
        return CubicCurve2D.solveCubic(dArray, dArray);
    }

    public static int solveCubic(double[] dArray, double[] dArray2) {
        int n;
        double d = dArray[3];
        if (d == 0.0) {
            return QuadCurve2D.solveQuadratic(dArray, dArray2);
        }
        double d2 = dArray[2] / d;
        double d3 = dArray[1] / d;
        double d4 = dArray[0] / d;
        double d5 = d2 * d2;
        double d6 = 0.3333333333333333 * (-0.3333333333333333 * d5 + d3);
        double d7 = 0.5 * (0.07407407407407407 * d2 * d5 - 0.3333333333333333 * d2 * d3 + d4);
        double d8 = d6 * d6 * d6;
        double d9 = d7 * d7 + d8;
        double d10 = 0.3333333333333333 * d2;
        if (d9 < 0.0) {
            double d11 = 0.3333333333333333 * Math.acos(-d7 / Math.sqrt(-d8));
            double d12 = 2.0 * Math.sqrt(-d6);
            if (dArray2 == dArray) {
                dArray = Arrays.copyOf(dArray, 4);
            }
            dArray2[0] = d12 * Math.cos(d11);
            dArray2[1] = -d12 * Math.cos(d11 + 1.0471975511965976);
            dArray2[2] = -d12 * Math.cos(d11 - 1.0471975511965976);
            n = 3;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] - d10;
            }
        } else {
            double d13 = Math.sqrt(d9);
            double d14 = Math.cbrt(d13 - d7);
            double d15 = -Math.cbrt(d13 + d7);
            double d16 = d14 + d15;
            n = 1;
            double d17 = 1.2E9 * Math.ulp(Math.abs(d16) + Math.abs(d10));
            if (CubicCurve2D.iszero(d9, d17) || CubicCurve2D.within(d14, d15, d17)) {
                if (dArray2 == dArray) {
                    dArray = Arrays.copyOf(dArray, 4);
                }
                dArray2[1] = -(d16 / 2.0) - d10;
                n = 2;
            }
            dArray2[0] = d16 - d10;
        }
        if (n > 1) {
            n = CubicCurve2D.fixRoots(dArray, dArray2, n);
        }
        if (n > 2 && (dArray2[2] == dArray2[1] || dArray2[2] == dArray2[0])) {
            --n;
        }
        if (n > 1 && dArray2[1] == dArray2[0]) {
            dArray2[1] = dArray2[--n];
        }
        return n;
    }

    private static int fixRoots(double[] dArray, double[] dArray2, int n) {
        double d;
        double[] dArray3 = new double[]{dArray[1], 2.0 * dArray[2], 3.0 * dArray[3]};
        int n2 = QuadCurve2D.solveQuadratic(dArray3, dArray3);
        if (n2 == 2 && dArray3[0] == dArray3[1]) {
            --n2;
        }
        if (n2 == 2 && dArray3[0] > dArray3[1]) {
            d = dArray3[0];
            dArray3[0] = dArray3[1];
            dArray3[1] = d;
        }
        if (n == 3) {
            d = CubicCurve2D.getRootUpperBound(dArray);
            double d2 = -d;
            Arrays.sort(dArray2, 0, n);
            if (n2 == 2) {
                dArray2[0] = CubicCurve2D.refineRootWithHint(dArray, d2, dArray3[0], dArray2[0]);
                dArray2[1] = CubicCurve2D.refineRootWithHint(dArray, dArray3[0], dArray3[1], dArray2[1]);
                dArray2[2] = CubicCurve2D.refineRootWithHint(dArray, dArray3[1], d, dArray2[2]);
                return 3;
            }
            if (n2 == 1) {
                double d3 = dArray[3];
                double d4 = -d3;
                double d5 = dArray3[0];
                double d6 = CubicCurve2D.solveEqn(dArray, 3, d5);
                dArray2[0] = CubicCurve2D.oppositeSigns(d4, d6) ? CubicCurve2D.bisectRootWithHint(dArray, d2, d5, dArray2[0]) : (CubicCurve2D.oppositeSigns(d6, d3) ? CubicCurve2D.bisectRootWithHint(dArray, d5, d, dArray2[2]) : d5);
            } else if (n2 == 0) {
                dArray2[0] = CubicCurve2D.bisectRootWithHint(dArray, d2, d, dArray2[1]);
            }
        } else if (n == 2 && n2 == 2) {
            d = dArray2[0];
            double d7 = dArray2[1];
            double d8 = dArray3[0];
            double d9 = dArray3[1];
            double d10 = Math.abs(d8 - d) > Math.abs(d9 - d) ? d8 : d9;
            double d11 = CubicCurve2D.solveEqn(dArray, 3, d10);
            if (CubicCurve2D.iszero(d11, 1.0E7 * Math.ulp(d10))) {
                double d12 = CubicCurve2D.solveEqn(dArray, 3, d7);
                dArray2[1] = Math.abs(d12) < Math.abs(d11) ? d7 : d10;
                return 2;
            }
        }
        return 1;
    }

    private static double refineRootWithHint(double[] dArray, double d, double d2, double d3) {
        if (!CubicCurve2D.inInterval(d3, d, d2)) {
            return d3;
        }
        double[] dArray2 = new double[]{dArray[1], 2.0 * dArray[2], 3.0 * dArray[3]};
        double d4 = d3;
        for (int i = 0; i < 3; ++i) {
            double d5 = CubicCurve2D.solveEqn(dArray2, 2, d3);
            double d6 = CubicCurve2D.solveEqn(dArray, 3, d3);
            double d7 = -(d6 / d5);
            double d8 = d3 + d7;
            if (d5 == 0.0 || d6 == 0.0 || d3 == d8) break;
            d3 = d8;
        }
        if (CubicCurve2D.within(d3, d4, 1000.0 * Math.ulp(d4)) && CubicCurve2D.inInterval(d3, d, d2)) {
            return d3;
        }
        return d4;
    }

    private static double bisectRootWithHint(double[] dArray, double d, double d2, double d3) {
        double d4 = Math.min(Math.abs(d3 - d) / 64.0, 0.0625);
        double d5 = Math.min(Math.abs(d3 - d2) / 64.0, 0.0625);
        double d6 = d3 - d4;
        double d7 = d3 + d5;
        double d8 = CubicCurve2D.solveEqn(dArray, 3, d6);
        double d9 = CubicCurve2D.solveEqn(dArray, 3, d7);
        while (CubicCurve2D.oppositeSigns(d8, d9)) {
            if (d6 >= d7) {
                return d6;
            }
            d = d6;
            d2 = d7;
            d6 = d3 - (d4 /= 64.0);
            d7 = d3 + (d5 /= 64.0);
            d8 = CubicCurve2D.solveEqn(dArray, 3, d6);
            d9 = CubicCurve2D.solveEqn(dArray, 3, d7);
        }
        if (d8 == 0.0) {
            return d6;
        }
        if (d9 == 0.0) {
            return d7;
        }
        return CubicCurve2D.bisectRoot(dArray, d, d2);
    }

    private static double bisectRoot(double[] dArray, double d, double d2) {
        double d3 = CubicCurve2D.solveEqn(dArray, 3, d);
        double d4 = d + (d2 - d) / 2.0;
        while (d4 != d && d4 != d2) {
            double d5 = CubicCurve2D.solveEqn(dArray, 3, d4);
            if (d5 == 0.0) {
                return d4;
            }
            if (CubicCurve2D.oppositeSigns(d3, d5)) {
                d2 = d4;
            } else {
                d3 = d5;
                d = d4;
            }
            d4 = d + (d2 - d) / 2.0;
        }
        return d4;
    }

    private static boolean inInterval(double d, double d2, double d3) {
        return d2 <= d && d <= d3;
    }

    private static boolean within(double d, double d2, double d3) {
        double d4 = d2 - d;
        return d4 <= d3 && d4 >= -d3;
    }

    private static boolean iszero(double d, double d2) {
        return CubicCurve2D.within(d, 0.0, d2);
    }

    private static boolean oppositeSigns(double d, double d2) {
        return d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0;
    }

    private static double solveEqn(double[] dArray, int n, double d) {
        double d2 = dArray[n];
        while (--n >= 0) {
            d2 = d2 * d + dArray[n];
        }
        return d2;
    }

    private static double getRootUpperBound(double[] dArray) {
        double d = dArray[3];
        double d2 = dArray[2];
        double d3 = dArray[1];
        double d4 = dArray[0];
        double d5 = 1.0 + Math.max(Math.max(Math.abs(d2), Math.abs(d3)), Math.abs(d4)) / Math.abs(d);
        d5 += Math.ulp(d5) + 1.0;
        return d5;
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (d * 0.0 + d2 * 0.0 != 0.0) {
            return false;
        }
        double d6 = this.getX1();
        int n = Curve.pointCrossingsForLine(d, d2, d6, d5 = this.getY1(), d4 = this.getX2(), d3 = this.getY2()) + Curve.pointCrossingsForCubic(d, d2, d6, d5, this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), d4, d3, 0);
        return (n & 1) == 1;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = this.rectCrossings(d, d2, d3, d4);
        return n != 0;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        int n = this.rectCrossings(d, d2, d3, d4);
        return n != 0 && n != Integer.MIN_VALUE;
    }

    private int rectCrossings(double d, double d2, double d3, double d4) {
        int n = 0;
        if ((this.getX1() != this.getX2() || this.getY1() != this.getY2()) && (n = Curve.rectCrossingsForLine(n, d, d2, d + d3, d2 + d4, this.getX1(), this.getY1(), this.getX2(), this.getY2())) == Integer.MIN_VALUE) {
            return n;
        }
        return Curve.rectCrossingsForCubic(n, d, d2, d + d3, d2 + d4, this.getX2(), this.getY2(), this.getCtrlX2(), this.getCtrlY2(), this.getCtrlX1(), this.getCtrlY1(), this.getX1(), this.getY1(), 0);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new CubicIterator(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static class Double
    extends CubicCurve2D
    implements Serializable {
        public double x1;
        public double y1;
        public double ctrlx1;
        public double ctrly1;
        public double ctrlx2;
        public double ctrly2;
        public double x2;
        public double y2;
        private static final long serialVersionUID = -4202960122839707295L;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.setCurve(d, d2, d3, d4, d5, d6, d7, d8);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getCtrlX1() {
            return this.ctrlx1;
        }

        @Override
        public double getCtrlY1() {
            return this.ctrly1;
        }

        @Override
        public Point2D getCtrlP1() {
            return new Point2D.Double(this.ctrlx1, this.ctrly1);
        }

        @Override
        public double getCtrlX2() {
            return this.ctrlx2;
        }

        @Override
        public double getCtrlY2() {
            return this.ctrly2;
        }

        @Override
        public Point2D getCtrlP2() {
            return new Point2D.Double(this.ctrlx2, this.ctrly2);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx1 = d3;
            this.ctrly1 = d4;
            this.ctrlx2 = d5;
            this.ctrly2 = d6;
            this.x2 = d7;
            this.y2 = d8;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            double d2 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            double d3 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            double d4 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
    }

    public static class Float
    extends CubicCurve2D
    implements Serializable {
        public float x1;
        public float y1;
        public float ctrlx1;
        public float ctrly1;
        public float ctrlx2;
        public float ctrly2;
        public float x2;
        public float y2;
        private static final long serialVersionUID = -1272015596714244385L;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.setCurve(f, f2, f3, f4, f5, f6, f7, f8);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getCtrlX1() {
            return this.ctrlx1;
        }

        @Override
        public double getCtrlY1() {
            return this.ctrly1;
        }

        @Override
        public Point2D getCtrlP1() {
            return new Point2D.Float(this.ctrlx1, this.ctrly1);
        }

        @Override
        public double getCtrlX2() {
            return this.ctrlx2;
        }

        @Override
        public double getCtrlY2() {
            return this.ctrly2;
        }

        @Override
        public Point2D getCtrlP2() {
            return new Point2D.Float(this.ctrlx2, this.ctrly2);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.ctrlx1 = (float)d3;
            this.ctrly1 = (float)d4;
            this.ctrlx2 = (float)d5;
            this.ctrly2 = (float)d6;
            this.x2 = (float)d7;
            this.y2 = (float)d8;
        }

        public void setCurve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx1 = f3;
            this.ctrly1 = f4;
            this.ctrlx2 = f5;
            this.ctrly2 = f6;
            this.x2 = f7;
            this.y2 = f8;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float f = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
            float f2 = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
            float f3 = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
            float f4 = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }
    }
}

