/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.OtherCertificate;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public class CertificateSet {
    private Vector a = new Vector();
    private static boolean b = DebugCMS.getDebugMode() && b;

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificates: " + this.a.size());
        stringBuffer.append(" -- " + this.a() + " attribute certificate(s), ");
        stringBuffer.append(String.valueOf(this.c()) + " other certificate(s)\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SET sET = new SET();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            Certificate certificate = (Certificate)enumeration.nextElement();
            if (certificate instanceof X509Certificate) {
                sET.addComponent(((X509Certificate)certificate).toASN1Object());
                continue;
            }
            if (certificate instanceof AttributeCertificate) {
                n2 = 2;
                if (((AttributeCertificate)certificate).getVersion() == 1) {
                    n2 = 1;
                }
                sET.addComponent((ASN1Object)new CON_SPEC(n2, ((AttributeCertificate)certificate).toASN1Object(), true));
                continue;
            }
            if (certificate instanceof OtherCertificate) {
                n2 = 3;
                OtherCertificate otherCertificate = (OtherCertificate)certificate;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)otherCertificate.getOtherCertFormat());
                sEQUENCE.addComponent(otherCertificate.toASN1Object());
                sET.addComponent((ASN1Object)new CON_SPEC(n2, (ASN1Object)sEQUENCE, true));
                continue;
            }
            throw new CodingException("Unknown certificate type: " + certificate.getType() + "!");
        }
        return sET;
    }

    public void setCertificates(Certificate[] certificateArray) {
        this.a.removeAllElements();
        this.addCertificates(certificateArray);
    }

    public void removeAllCertificates() {
        this.a.removeAllElements();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public X509Certificate[] getX509Certificates() {
        Object object;
        Vector vector = new Vector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof X509Certificate)) continue;
            vector.addElement(object);
        }
        object = new X509Certificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public X509Certificate getX509Certificate(CertificateIdentifier certificateIdentifier) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Certificate certificate = (Certificate)enumeration.nextElement();
            if (!certificate.getType().equalsIgnoreCase("X.509") || !certificateIdentifier.identifiesCert((X509Certificate)certificate)) continue;
            return (X509Certificate)certificate;
        }
        return null;
    }

    public OtherCertificate[] getOtherCertificates() {
        Object object;
        Vector vector = new Vector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof OtherCertificate)) continue;
            vector.addElement(object);
        }
        object = new OtherCertificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Certificate[] getCertificates() {
        int n2 = this.a.size();
        Object[] objectArray = new Certificate[n2];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public AttributeCertificate[] getAttributeCertificates() {
        Object object;
        Vector vector = new Vector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof AttributeCertificate)) continue;
            vector.addElement(object);
        }
        object = new AttributeCertificate[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public int getAttributeCertificateType() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            var3_3 = enumeration.nextElement();
            if (!(var3_3 instanceof AttributeCertificate)) continue;
            if (((AttributeCertificate)var3_3).getVersion() == 2) {
                n2 = 2;
                break;
            }
            n2 = 1;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = (DerInputStream)inputStream;
        DerInputStream derInputStream2 = derInputStream.readSet();
        try {
            block9: while (true) {
                if (derInputStream2.nextTag() <= -1) {
                    return;
                }
                if (derInputStream2.nextIsContextSpecific()) {
                    int n2 = derInputStream2.readContextSpecific(16);
                    switch (n2) {
                        case 0: {
                            throw new CMSParsingException("PKCS#6 extended certificates are obsolete and therefore not supported!");
                        }
                        case 1: 
                        case 2: {
                            this.a.addElement(new AttributeCertificate((InputStream)derInputStream2));
                            continue block9;
                        }
                        case 3: {
                            DerInputStream derInputStream3 = derInputStream2.readSequence();
                            ObjectID objectID = derInputStream3.readObjectID();
                            try {
                                this.a.addElement(new OtherCertificate(objectID, (InputStream)derInputStream3));
                                continue block9;
                            }
                            catch (CodingException codingException) {
                                throw new CMSParsingException("Error parsing other cert: " + codingException.getMessage());
                            }
                        }
                    }
                    throw new CMSParsingException("Invalid implicit tag " + n2 + " for CertificateChoices!");
                }
                this.a.addElement(new X509Certificate((InputStream)derInputStream2));
            }
        }
        catch (CertificateException certificateException) {
            throw new CMSParsingException(certificateException.getMessage());
        }
    }

    private int b() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof X509Certificate)) continue;
            ++n2;
        }
        return n2;
    }

    private int c() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof OtherCertificate)) continue;
            ++n2;
        }
        return n2;
    }

    private int a() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof AttributeCertificate)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean containsX509Certificates() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof X509Certificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOtherCertificates() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof OtherCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeCertificates() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            if (!(enumeration.nextElement() instanceof AttributeCertificate)) continue;
            return true;
        }
        return false;
    }

    public void addCertificates(Certificate[] certificateArray) {
        int n2 = 0;
        while (n2 < certificateArray.length) {
            this.addCertificate(certificateArray[n2]);
            ++n2;
        }
    }

    public void addCertificate(Certificate certificate) {
        if (!(certificate instanceof X509Certificate || certificate instanceof AttributeCertificate || certificate instanceof OtherCertificate)) {
            throw new IllegalArgumentException("Only iaik.x509.X509Certificates or iaik.x509.attr.AttributeCertificates or iaik.cms.OtherCertificates are allowed!");
        }
        this.a.addElement(certificate);
    }

    public CertificateSet(InputStream inputStream) throws IOException, CMSParsingException {
        this();
        this.decode(inputStream);
    }

    public CertificateSet() {
    }
}

