/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleTranslationProvider
extends TranslationService {
    private static final String PLATFORM_SCHEMA = "platform";
    private static final String PLUGIN_SEGMENT = "/plugin/";
    private static final String FRAGMENT_SEGMENT = "/fragment/";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";

    public String translate(String key, String contributorURI) {
        Bundle bundle = this.getBundle(contributorURI);
        if (bundle == null) {
            return key;
        }
        BundleLocalization localizationService = ServicesActivator.getDefault().getLocalizationService();
        if (localizationService == null) {
            return key;
        }
        ResourceBundle resourceBundle = localizationService.getLocalization(bundle, this.locale);
        return this.getResourceString(key, resourceBundle);
    }

    private Bundle getBundle(String contributorURI) {
        URI uri;
        if (contributorURI == null) {
            return null;
        }
        try {
            uri = new URI(contributorURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            LogService logService = ServicesActivator.getDefault().getLogService();
            if (logService != null) {
                logService.log(1, "Invalid contributor URI: " + contributorURI);
            }
            return null;
        }
        if (!PLATFORM_SCHEMA.equals(uri.getScheme())) {
            return null;
        }
        String bundleName = uri.getPath();
        if (bundleName.startsWith(PLUGIN_SEGMENT)) {
            bundleName = bundleName.substring(PLUGIN_SEGMENT.length());
        } else if (bundleName.startsWith(FRAGMENT_SEGMENT)) {
            bundleName = bundleName.substring(FRAGMENT_SEGMENT.length());
        }
        PackageAdmin packageAdmin = ServicesActivator.getDefault().getPackageAdmin();
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public String getResourceString(String value, ResourceBundle resourceBundle) {
        String dflt;
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX, 0)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX, 0)) {
            return s.substring(1);
        }
        int ix = s.indexOf(32);
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (resourceBundle == null) {
            return dflt;
        }
        try {
            return resourceBundle.getString(key.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return dflt;
        }
    }
}

