
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#ifndef  __GD_POLYMER_DRIVER_H 
#define  __GD_POLYMER_DRIVER_H 1 
 
class GdPolymerDriver{  
  /* MD driver for polymer objects */  
	  
public:  
/* Constructor & Destructor: The driver contructor grabs a reference   
* to the polymer it is supposed to drive. I decided to implement the  
* driver this way because I can preserve changes to the driver for   
* every polymer independently.  
  */  
  GdPolymerDriver(GdPolymer &);  
  ~GdPolymerDriver();  
	  
  /* Initialization of callback functions: interaction potentials */  
  void initRepelFunc(GDfunc1D, int resolution, double rmin, double rmax);  
  void initAttrcFunc(GDfunc1D, int resolution, double rmin, double rmax);  
	  
  /* Set & get driver state variables */  
  void setCutoff(double rc, double rl);                /* Potential cut off */  
  void setTemperature(double T);                       /* Set temperature   */  
  void setFriction(double G);                          /* Solution friction */  
  void setTimeStep(double dt);                         /* integration step  */  
	  
  /* Driver interface */   
  void propagate(int nr_steps = 1);    /* Temp propagator                    */  
	  
protected:  
static unsigned long seed;            /* Seed for random generator   
                                      * It is the static so that  
                                      * two monomers don't follow  
                                      * the same history  
*/  
/* Polymer system */  
int polymerSize;                      /* Number of monomers               */  
GdPolymer *polymer;                   /* Reference to polymer             */  
double     timeStep;                  /* Integration time step            */  
double     rCutoff;                   /* Potential cutoff^2               */  
double     rLimit;                    /* Neighbour list cutoff^2          */  
double     temperature;               /* Solution temperature             */  
double     friction;                  /* Solution friction                */  
 
/* Callback functions: bead to bead forces */  
bool is_force;                        /* Are forces initialized?          */  
bool is_force_a;                      /* Are forces initialized?          */  
bool is_force_r;                      /* Are forces initialized?          */  
GdTableFunc1D  *repulsion;            /* Repulsive force                  */  
GdTableFunc1D  *attraction;           /* Repulsive force                  */  
 
/* Brownian driver parameters: Used in Stochastic Verlet Algorithm */  
double sigma_v;                       /*  Noise: Dispersion in v          */   
double sigma_r;                       /*         Dispersion in r          */  
double c0, c1, c2;                    /*  expansion coefficients          */  
double r1, r2;                        /* Intermediate  positions          */  
double v1, v2, v3;                    /* Intermediate  velocities         */  
double n1, n2, n1Half, n2Half;        /* noise expansion coefficients     */  
 
private:  
  /* helper functions */  
  void  updateParameters();  
  void  updateForces();  
};  
 
 
 
 
 
 
 
 
 
 
#endif 
 
