
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include <GL/glut.h>  
#include "Gd_definitions.h" 
#include "Gd_monomer.h"  
#include "Gd_polymer.h" 
#include "Gd_opengl.h"  
 
 
// Elemental Geometrical Objects 
#define SPHERE	 1  
#define MONOMER  2  
#define CYLINDER 3  
#define XLINK    4  
 
 
// Lights and Materials 
GLfloat link_diffuse[] ={1.0F, 0.0F, 0.2F, 1.0F};  
GLfloat polymer_diffuse[] ={0.0F, 0.75F, 0.90F, 1.0F};  
GLfloat polymer_specular[] ={0.5F, 0.5F, 0.5F, 1.0F};  
GLfloat polymer_shininess[] = {80.0};  
 
 
void GdRenderer::initialize(void) {  
  int i; 
   
  // SPHERE ITEM  
  glNewList(SPHERE, GL_COMPILE);	 
  glPushMatrix(); 
  glRotatef(90.0, 1.0, 0.0, 0.0);    
  glutSolidSphere(0.1, 20,20);   
  glPopMatrix(); 
  glEndList();    
   
  // MONOMER ITEM  
  glNewList(MONOMER, GL_COMPILE);  
  glPushMatrix(); 
  glRotatef(90.0, 1.0, 0.0, 0.0);    
  glMaterialfv(GL_FRONT, GL_DIFFUSE, polymer_diffuse);  
  glMaterialfv(GL_FRONT, GL_SPECULAR, polymer_specular);  
  glMaterialfv(GL_FRONT, GL_SHININESS, polymer_shininess);  
  glutSolidSphere(0.40F, 10,10);	  
  glPopMatrix(); 
  glEndList();    
   
  // CYLINDER ITEM  
  float dTheta = 6.2831853F / 20;    
  float Theta = dTheta;	 
  glNewList(CYLINDER, GL_COMPILE);    
  glPushMatrix(); 
  glPushAttrib(GL_CURRENT_BIT);	 
  glMaterialfv(GL_FRONT, GL_DIFFUSE, polymer_diffuse);  
  glMaterialfv(GL_FRONT, GL_SPECULAR, polymer_specular);  
  glMaterialfv(GL_FRONT, GL_SHININESS, polymer_shininess);  
  glBegin(GL_QUAD_STRIP);    
  glNormal3f(0.0, 0.0, 1.0);	  
  glVertex3f(0.0F, 1.0F, 0.40F);	  
  glVertex3f(0.0F, 0.0F, 0.40F);	  
  for (i = 1; i < 20; i++, Theta += dTheta) {    
    float cs = cos(Theta);	  
    float sn = sin(Theta);	  
    float x = 0.40 * sn;    
    float z = 0.40 * cs;    
    glNormal3f(sn, 0.0, cs);    
    glVertex3f(x, 1.0F, z);    
    glVertex3f(x, 0.0F, z);    
  };	  
  glNormal3f(0.0, 0.0, 1.0);	  
  glVertex3f(0.0F, 1.0F, 0.40F);	  
  glVertex3f(0.0F, 0.0F, 0.40F);	  
  glEnd();    
  glPopAttrib();	  
  glPopMatrix(); 
  glEndList();    
 
};  
 
 
void GdRenderer::draw(GdMonomer &m){  
  double x, y, z;  
  m.getPosition(x, y, z);  
  glPushMatrix();  
  glTranslatef(x, y, z);  
  glCallList(MONOMER);  
  glPopMatrix();  
};  
 
 
 
void GdRenderer::draw(GdPolymer &p){  
   
  // Loop over monomers  
  for (int i = 0; i < p.getSize(); i++){  
    // Get monomer coordinates  
    double x, y, z;  
    GdMonomer &current = p[i];  
    current.getPosition(x, y, z);  
     
    // Draw monomer  
    glPushMatrix();  
    glTranslatef(x, y, z);  
    glCallList(MONOMER);  
     
    // Draw Bonds  
    for (int j = 0; j < current.getNrBonds(); j++){  
       
      // Get bond length  
      double x0, y0, z0;  
      GdMonomer &next = current.getBond(j);  
      next.getPosition(x0, y0, z0);  
       
      // Get orientation  
      float vx, vy, vz;  
      vx = x0 -x;  
      vy = y0 -y;  
      vz = z0 -z;  
      float norm = vx * vx + vy * vy + vz * vz;  
      norm = sqrt(norm);  
      vx /= norm;  
      vy /= norm;  
      vz /= norm;  
       
      // Scaling and rotation  
      double Angle = 57.29578 * acos(vy);  
      glRotatef(Angle, vz, 0.0, -vx);  
      glScalef(1.0F, norm, 1.0F);  
      glCallList(CYLINDER);  
    };  
    glPopMatrix();  
  };  
};  
 
 
 
 
 
 

