
#include "macros.inc"

#define src_hi r25
#define src_lo r24
; #define val_hi r23
#define val_lo r22
#define len_hi r21
#define len_lo r20

#define ret_hi r25
#define ret_lo r24

; void *memchr(const void *src, int val, size_t len)

	.text
	.global	_U(memchr)
	.type	_U(memchr), @function
_U(memchr):
	LOAD_Z(src_lo, src_hi)
.memchr_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcs	.memchr_notfound
	ld	__tmp_reg__, Z+
	cp	__tmp_reg__, val_lo
	brne	.memchr_loop
	sbiw	ZL, 1		; undo post-increment
	mov	ret_lo, ZL	; XXX use movw if available
	mov	ret_hi, ZH
	ret
.memchr_notfound:
	clr	ret_lo
	clr	ret_hi
	ret
.memchr_end:
	.size	_U(memchr), .memchr_end - _U(memchr)

