
#include "macros.inc"

#define dest_hi r25
#define dest_lo r24
#define src_hi r23
#define src_lo r22
#define len_hi r21
#define len_lo r20

; void *memmove(void *dest, const void *src, size_t len)

	.extern _U(memcpy)
	.text
	.global	_U(memmove)
	.type	_U(memmove), @function
_U(memmove):
; if src < dest, we have to copy in reverse order
; otherwise memcpy will do the right thing
	cp	src_lo, dest_lo
	cpc	src_hi, dest_hi
	brcc	.memmove_fwd
	LOAD_Z(src_lo, src_hi)
	LOAD_X(dest_lo, dest_hi)
	add	ZL, len_lo
	adc	ZH, len_hi
	add	XL, len_lo
	adc	XH, len_hi
	rjmp	.memmove_start
.memmove_loop:
	ld	__tmp_reg__, -Z
	st	-X, __tmp_reg__
.memmove_start:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcc	.memmove_loop
; return dest (unchanged)
	ret
.memmove_fwd:
	XJMP	_U(memcpy)
.memmove_end:
	.size	_U(memmove), .memmove_end - _U(memmove)

