#!/usr/bin/perl -w
# vim: set sw=4 ts=4 si et:
# Copyright: GPL, Author: Guido Socher
#
use strict;
use vars qw($opt_h);
use Getopt::Std;
use Fcntl;
sub idletask();
sub schedulecmd($$);
sub lcdsend($);
sub help();
sub processqueue();
#
getopts("h")||die "ERROR: No such option. -h for help\n";
help() if ($opt_h);
my @processqueue;
$ARGV[0] || help();
#
# initialize the serial line:
print `ttydevinit \"$ARGV[0]\" 2>&1`;
sysopen(LCD,$ARGV[0],Fcntl::O_RDWR(),0666)||die "ERROR: can not open $ARGV[0]\n";
my ($rin,$rout,$timeout,$nfound,$timeleft,$str);
my %state;
$rin='';
$timeout=3; # seconds
#
idletask();
processqueue();
while(1){
    vec($rin,fileno(LCD),1)=1;
    # this statement blocks until timeout or returns immediately if
    # there is an answer available on the serial line.
    ($nfound,$timeleft) = select($rout=$rin, undef, undef, $timeout);
    if ($nfound){
        # data is available
        sysread LCD,$str,40; # there will never be more than 40 bytes
        print "$str";
    }
    processqueue();
}
# idletask will be called periodically if there is nothing else to do
sub idletask(){
    if ($state{'blinkled'}){
        lcdsend("l=10");
        $state{'blinkled'}=0;
    }else{
        lcdsend("l=11");
        $state{'blinkled'}=1;
    }
}
# put a command into the process queue
sub schedulecmd($$){
    my $c=shift;
    my $v=shift;
    push(@processqueue,{'cmd'=>$c,'val'=>$v});
}
# Send a command to the lcd panel
sub lcdsend($){
    my $s=shift;
    schedulecmd('lcd',$s);
}
# take the next command from the process queue and send it off
sub processqueue(){
    my $cmd;
    if (@processqueue){
        $cmd=shift @processqueue;
        if ($cmd->{'cmd'} eq "lcd"){
            syswrite LCD,$cmd->{'val'}."\n";
            print $cmd->{'val'}."\n";
        }
    }else{
        idletask() unless($state{'menutimeout'});
    }
}
		
	
#
sub help(){
print "This is a small perl program that shows how to use the
linux lcd panel. It will just cause the red LED to blink.
USAGE: ttytest.pl /dev/ttyS0\n";
exit;
}
__END__ 

