/* vim: set sw=8 ts=8 si : */
/*********************************************
* * Copyright: GPL
* *********************************************/
#include <io.h>
#include <stdarg.h>
#include <string-avr.h>
#include <progmem.h>

/* this is basically itoa except that the buffer is allready
* allocated and the convertion is to decimal */
char *int2str(unsigned int num){
        static char tmpstr[7];
        unsigned char i=6;
        tmpstr[6]='\0';
        do {
                i--;
                tmpstr[i]=num % 10 + '0';
                num /= 10;
        } while(num && i );
        return(&tmpstr[i]);
}

#define PRGSTRBUF 20
/* convert a string in program memory into a normal string 
* The string must not be longer than PRGSTRBUF */
char *prgstr2str(prog_char *s){
	static char buf[PRGSTRBUF+1];
	char c;
	unsigned char i=0;
	while ((c = PRG_RDB(s++)) && i<PRGSTRBUF) {
		buf[i]=c;
		i++;
	}
	buf[i]='\0';
	return(buf);
}

#define ROLLBUF 18
/* shift a text string over a given buffer length
* as shown below. The ROLLBUF size should be the
* visible display lenght or a bit smaller
* 00: |              |
* 01: |             h|
* 02: |            he|
* 03: |           hel|
* 04: |          hell|
* 05: |         hello|
* 06: |        hello |
* 07: |       hello  |
* 08: |      hello   |
* 09: |     hello    |
* 10: |    hello     |
* 11: |   hello      |
* 12: |  hello       |
* 13: | hello        |
* 14: |hello         |
* 15: |ello          |
* 16: |llo           |
* 17: |lo            |
* 18: |o             |
* 19: |              |
* 20: |              |
*
*/
char *rolltext(char *text, int shiftlen){
        static char buf[ROLLBUF+1];
        unsigned char i=0;
        unsigned char j=0;
        while(i < ROLLBUF){
                buf[i]=' ';
                i++;
        }
        i=0;
        if (shiftlen <= ROLLBUF){
                i=ROLLBUF-shiftlen;
        }else{
                j=shiftlen-ROLLBUF;
        }
        if (j > strlen(text)) return(buf);
        while(i < ROLLBUF){
                if (*(text+j)=='\0') break;
                buf[i]=*(text+j);
                j++;
                i++;
        }
        return(buf);
}

char *rolltext_p(prog_char *text, int shiftlen){
        static char buf[ROLLBUF+1];
        unsigned char i=0;
        unsigned char j=0;
        unsigned char textlen=0;
        while(i < ROLLBUF){
                buf[i]=' ';
                i++;
        }
	while (PRG_RDB(text+textlen)){
		textlen++;
	}
        i=0;
        if (shiftlen <= ROLLBUF){
                i=ROLLBUF-shiftlen;
        }else{
                j=shiftlen-ROLLBUF;
        }
        if (j > textlen) return(buf);
        while(i < ROLLBUF){
                if (PRG_RDB(text+j)=='\0') break;
                buf[i]=PRG_RDB(text+j);
                j++;
                i++;
        }
        return(buf);
}

#define SCRATCHLEN 16
int sprintf(char * buf, const char * format, ...)
/* simplified sprintf */
{
        char scratch[SCRATCHLEN]; /* temp buf for formatted string */
        char format_flag;
        int u_val = 0;
	int  base;
        char *ptr;
        va_list ap;

        va_start(ap, format);
        for (;;) {
                while ((format_flag = *format++) != '%') {      /* Until '%' or '
\0' */
                        if (!format_flag) {
                                va_end(ap);
                                return (0);
                        }
                        *buf = format_flag;
                        buf++;
                        *buf = 0;
                }

                switch (format_flag = *format++) {

                case 'c':
                        format_flag = va_arg(ap, int);
                default:
                        *buf = format_flag;
                        buf++;
                        *buf = 0;
                        continue;
                case 'S':
                case 's':
                        ptr = va_arg(ap, char *);
                        strcat(buf, ptr);
                        continue;
                case 'o':
                        base = 8;
                        *buf = '0';
                        buf++;
                        *buf = 0;
                        goto CONVERSION_LOOP;
                case 'i':
                        if (u_val < 0) {
                                u_val = -u_val;
                                *buf = '-';
                                buf++;
                                *buf = 0;
                        }
                        /* no break -> run into next case */
                case 'u':
                        base = 10;
                        goto CONVERSION_LOOP;
                case 'x':
                        base = 16;

                      CONVERSION_LOOP:
                        u_val = va_arg(ap, int);
                        ptr = scratch + SCRATCHLEN;
                        *--ptr = 0;
                        do {
                                char ch = u_val % base + '0';
                                if (ch > '9')
                                        ch += 'a' - '9' - 1;
                                *--ptr = ch;
                                u_val /= base;
                        } while (u_val);
                        strcat(buf, ptr);
                        buf += strlen(ptr);
                }
        }
}

