
#include "fx.h"
#include "DemoApp.h"
#include "DemoDlg.h"

// Message Map
FXDEFMAP(CDemoApp) CDemoAppMap[]=
{

    //________Message_Type_____________________ID____________Message_Handler_______
    FXMAPFUNC(SEL_COMMAND,  CDemoApp::ID_LAST,    CDemoApp::onShowDlg),

};


FXIMPLEMENT(CDemoApp,FXMainWindow,CDemoAppMap , ARRAYNUMBER(CDemoAppMap))


long CDemoApp::onShowDlg(FXObject*,FXSelector,void*)
{
    CDemoDlg modaldialog(this);
    modaldialog.execute();

    return 1;
}


CDemoApp::~CDemoApp()
{
    delete filemenu;
    delete demomenu;
    delete helpmenu;
}

// Construct a CDemoApp
CDemoApp::CDemoApp(FXApp *a):FXMainWindow(a,"DemoApp",NULL,NULL,DECOR_ALL,0,0,320,220)
{
        
    menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

    // File menu
    filemenu=new FXMenuPane(this);
    new FXMenuCommand(filemenu,"&New\tCtl-N\tCreate new document.");
    new FXMenuCommand(filemenu,"&Open\tCtl-O\tOpen document.");
    new FXMenuCommand(filemenu,"&Quit\tCtl-Q\tQuit application.");
    new FXMenuTitle(menubar,"&File",NULL,filemenu);

    // Demo menu
    demomenu = new FXMenuPane(this);
    new FXMenuCommand(demomenu, "Show DemoDlg",NULL,this,ID_SHOWDLG);
    new FXMenuTitle(menubar, "&Demo", NULL, demomenu);

    // Help menu
    helpmenu=new FXMenuPane(this);
    new FXMenuCommand(helpmenu,"&About FOX...");
    new FXMenuTitle(menubar,"&Help",NULL,helpmenu);

    // Status bar
    new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
}



// Create and initialize
void CDemoApp::create()
{
    // Create the windows
    FXMainWindow::create();

    // Make the main window appear
    show(PLACEMENT_SCREEN);
}



