
#include "fx.h"

#include "DemoDlg.h"

FXIMPLEMENT(CDemoDlg,FXDialogBox,NULL,0)

CDemoDlg::CDemoDlg(FXWindow* pParent) : FXDialogBox(pParent,"DemoDlg",DECOR_TITLE|DECOR_BORDER) 
{
    FXVerticalFrame *frame=new FXVerticalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);

    FXHorizontalFrame *contents=new FXHorizontalFrame(frame,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    /* group 1 */
    group1=new FXGroupBox(contents,"Group",GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    new FXLabel(group1,"Simple Text");
    new FXRadioButton(group1, "Radio1"); 
    new FXRadioButton(group1, "Radio2");
    new FXCheckButton(group1, "Check1");
    new FXCheckButton(group1, "Check2");
    new FXCheckButton(group1, "Check3");
    group1->setPadRight(90);

    /* group 2 */
    group2=new FXGroupBox(contents,"Group",GROUPBOX_TITLE_LEFT|FRAME_RIDGE|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    new FXLabel(group2, "Input");
    FXTextField *pText = new FXTextField(group2, 20, 0, 0,TEXTFIELD_NORMAL|LAYOUT_FILL_X);
    pText->setText("Test");

    new FXLabel(group2, "Choice");
    FXComboBox* pCombo=new FXComboBox(group2, 20,NULL,0,COMBOBOX_INSERT_LAST|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
    pCombo->appendItem("FOX");
    pCombo->appendItem("wxWidgets");

    new FXLabel(group2, "Progress");
    FXProgressBar *pbar=new FXProgressBar(group2, NULL,0, LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|PROGRESSBAR_PERCENTAGE);
    pbar->setProgress(75);
    pbar->setTotal(100);

    /* buttons */
    FXHorizontalFrame* contents2=new FXHorizontalFrame(frame,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_CENTER_X/*LAYOUT_FILL_X|LAYOUT_FILL_Y*/);
    
    new FXButton(contents2, "  Cancel  " );
    new FXButton(contents2, "  Apply  ");
}