#include <stdio.h>
#include <gnome.h>

static void about_cb (GtkWidget *w, gpointer data);
static void copy_cb (GtkWidget *w, gpointer data);
static void cut_cb (GtkWidget *w, gpointer data);
static void new_file_cb (GtkWidget *w, gpointer data);
static void open_file_cb (GtkWidget *w, gpointer data);
static void paste_cb (GtkWidget *w, gpointer data);
static void quit_cb (GtkWidget *w, gpointer data);
static void save_file_cb (GtkWidget *w, gpointer data);

GtkWidget *app = NULL;
GtkWidget *appbar = NULL;
GtkWidget *editor = NULL;

static GnomeUIInfo filemenu[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Create new file"),
	  new_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing file"),
	  open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Save"), N_("Save file"),
	  save_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
	  quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo editmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Cut"), N_("Cut selected text"),
	  cut_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_CUT, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy selected text"),
	  copy_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_COPY, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste text from clipboard"),
	  paste_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_PASTE, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo helpmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("About..."), N_("About this application"),
	  about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo mainmenu[] = {
	GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
	GNOMEUIINFO_SUBTREE(N_("Edit"), editmenu),
	GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
	GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Create new file"),
	  new_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing file"),
	  open_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Save"), N_("Save file"),
	  save_file_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Cut"), N_("Cut selected text"),
	  cut_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_CUT, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy selected text"),
	  copy_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_COPY, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste text from clipboard"),
	  paste_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_PASTE, 0, 0, NULL },
	GNOMEUIINFO_END
};

int
main (int argc, char *argv[])
{
	GtkWidget *scroll;

	/* inicializacin de gettext */
	bindtextdomain("editor", "/usr/share/locale");
	textdomain("editor");

	/* inicializacin de GNOME */
	gnome_init("editor", "0.1", argc, argv);

	/* crea la ventana principal */
	app = gnome_app_new("editor", "Editor");
	gtk_signal_connect(GTK_OBJECT(app),
	                   "destroy",
	                   GTK_SIGNAL_FUNC(quit_cb),
	                   NULL);
	gnome_app_create_menus(GNOME_APP(app), mainmenu);
	gnome_app_create_toolbar(GNOME_APP(app), toolbar);

	appbar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar(GNOME_APP(app), appbar);

	/* crea el editor */
	scroll = gtk_scrolled_window_new(NULL, NULL);
	editor = gtk_text_new(NULL, NULL);
	gtk_text_set_editable(GTK_TEXT(editor), TRUE);
	gtk_widget_show(editor);
	gtk_container_add(GTK_CONTAINER(scroll), editor);
	gnome_app_set_contents(GNOME_APP(app), scroll);

	gtk_widget_show_all(app);

	/* ejecuta bucle principal */
	gtk_main();
	return 0;
}

static void
filesel_button_clicked (GtkWidget *w, gpointer data) {
	glong *selected = (glong *) data;
	*selected = (glong) gtk_object_get_data(GTK_OBJECT(w), "button");
}

static gchar *
select_file (const gchar *title) {
	GtkWidget* filesel;
	glong*     selected;
	gchar*     res = NULL;
	
	selected = (glong *) g_malloc(sizeof(glong));
	*selected = 0;
	
	/* crea dilogo */
	filesel = gtk_file_selection_new(title);
	gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
	                    "button",
	                    (gpointer) 1);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
	                   "clicked",
	                   GTK_SIGNAL_FUNC(filesel_button_clicked),
	                   (gpointer) selected);
	gtk_object_set_data(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
	                    "button",
	                    (gpointer) 2);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
	                   "clicked",
	                   GTK_SIGNAL_FUNC(filesel_button_clicked),
	                   (gpointer) selected);
	gtk_widget_show(filesel);
	gtk_file_selection_show_fileop_buttons(GTK_FILE_SELECTION(filesel));
	
	/* espera a que el usuario seleccione un fichero */
	while (!*selected)
		gtk_main_iteration_do(TRUE);
	if (*selected == 1) /* botn OK */ {
		res = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));
	}
	else res = NULL;
	
	/* limpieza */
	gtk_widget_destroy(filesel);
	g_free((gpointer) selected);
	return res;
}

static void
about_cb (GtkWidget *w, gpointer data)
{
	const gchar *authors[] = { "Rodrigo Moya <rodrigo@gnome-db.org>",
	                           "Pepe",
	                           NULL };
	GtkWidget *about = gnome_about_new("editor", "0.1",
	                                   _("Copyright FSF"),
	                                   authors,
	                                   _("Simple GNOME text editor"),
	                                   NULL);
	gtk_widget_show(about);
}

static void
copy_cb (GtkWidget *w, gpointer data)
{
	gtk_editable_copy_clipboard(GTK_EDITABLE(editor));
}

static void
cut_cb (GtkWidget *w, gpointer data)
{
	gtk_editable_cut_clipboard(GTK_EDITABLE(editor));
}

static void
new_file_cb (GtkWidget *w, gpointer data)
{
	/* borramos el contenido del editor */
	gtk_editable_delete_text(GTK_EDITABLE(editor),
	                         0,
	                         gtk_text_get_length(GTK_TEXT(editor)));
}

static void
open_file_cb (GtkWidget *w, gpointer data)
{
	gchar *filename;

	filename = select_file(_("Save As..."));
	if (filename) {
		FILE *fp;
		gchar buffer[2048];

		fp = fopen(filename, "r");
		if (fp) {
			gtk_editable_delete_text(GTK_EDITABLE(editor),
			                         0,
			                         gtk_text_get_length(GTK_TEXT(editor)));
			while (!feof(fp)) {
				memset(buffer, 0, sizeof(buffer));
				fread(buffer, sizeof(buffer) - 1, 1, fp);
				gtk_text_insert(GTK_TEXT(editor),
				                NULL,
				                NULL,
				                NULL,
				                buffer,
				                strlen(buffer));
			}
			fclose(fp);
		}
		else gnome_app_error(GNOME_APP(app), _("No se pudo abrir el fichero"));
		g_free((gpointer) filename);
	}
}

static void
paste_cb (GtkWidget *w, gpointer data)
{
	gtk_editable_paste_clipboard(GTK_EDITABLE(editor));
}

static void
quit_cb (GtkWidget *w, gpointer data)
{
	gtk_main_quit();
}

static void
save_file_cb (GtkWidget *w, gpointer data)
{
	gchar *filename;

	filename = select_file(_("Save As..."));
	if (filename) {
		gchar *content;
		FILE *fp;

		content = gtk_editable_get_chars(GTK_EDITABLE(editor),
		                                 0,
		                                 gtk_text_get_length(GTK_TEXT(editor)));

		/* abre el fichero */
		fp = fopen(filename, "w");
		if (fp) {
			fwrite(content, strlen(content), 1, fp);
			fclose(fp);
		}
		else gnome_app_error(GNOME_APP(app), _("No se pudo crear fichero"));

		g_free((gpointer) filename);
	}
}