import anydbm
import time
import string
import pickle
class agenda:
    def __init__(self,fich='agenda.db'):
        self.db=anydbm.open(fich,'c')
    
    def volcado(self):
        ret=[]
        for k in self.db.keys():
            ret.append( (k,self.db[k]) )
        return ret
    def encuentra(self, clave):
        clave=string.upper(str(clave))
        try:
            return pickle.loads(self.db[clave])
        except:
            return None
        
    def busca(self, clave):
        ret=[]
        clave=string.upper(str(clave))
        for k in self.db.keys():
            if string.find(k,clave)>-1:
                ret.append( (k,pickle.loads(self.db[k])) )
        return ret
    def nuevo(self,clave,contenido):
        nombre=string.upper(str(clave))
        direccion=pickle.dumps(contenido)
        self.db[nombre]=direccion


if __name__=='__main__':
    
    import pprint
    ag=agenda()
    if not ag.db:
        ag.nuevo('ErnestoBKE', ('Ernesto Molina','emolina@grupoburke.com'))
        ag.nuevo('Ernesto', ('Ernesto Molina','rotoxl@jazzfree.com'))
        ag.nuevo('MarcosBKE', ('Marcos Snchez','msanchez@grupoburke.com'))
        ag.nuevo('Marcos', ('Marcos Snchez','rapto@arrakis.es'))
    print ag.encuentra('Ernesto')
    pprint.pprint (ag.busca('BKE'))
    
